/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IRefreshable;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;

public class RefreshHandler {
    private static final String PREF_REFRESH_INTERVAL = "PREF_REFRESH_INTERVAL";
    private static final String DEFAULT_PARAMETER_REFRESH_INTERVAL = "refreshInterval";
    private int fRefreshInterval = -1;
    private Job fRefreshJob;
    private String fName;
    IRefreshable fRefreshableObject;
    ISectionSite fSite;

    public RefreshHandler(IRefreshable refreshableObject) {
        this.fRefreshableObject = refreshableObject;
    }

    public void init(ISectionSite sectionSite, IMemento memento) {
        this.fName = sectionSite.getName();
        this.fSite = sectionSite;
        if (memento != null && memento.getInteger(PREF_REFRESH_INTERVAL) != null) {
            this.setRefreshInterval(memento.getInteger(PREF_REFRESH_INTERVAL));
        } else if (sectionSite.hasParameter(DEFAULT_PARAMETER_REFRESH_INTERVAL)) {
            this.setRefreshInterval(Integer.parseInt(sectionSite.getParameter(DEFAULT_PARAMETER_REFRESH_INTERVAL)));
        }
    }

    public void createMenu(Menu sectionMenu) {
        MenuItem refreshMenuItem = new MenuItem(sectionMenu, 64);
        refreshMenuItem.setText(Messages.RefreshHandler_REFRESH);
        Menu refreshMenu = new Menu((Decorations)sectionMenu.getShell(), 4);
        refreshMenuItem.setMenu(refreshMenu);
        MenuItem refreshNow = new MenuItem(refreshMenu, 0);
        refreshNow.setText(Messages.RefreshHandler_NOW);
        refreshNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefreshHandler.this.scheduleRefresh(0L);
            }
        });
        new MenuItem(refreshMenu, 2);
        int[] intervals = new int[]{-1, 3, 5, 10, 15, 30, 60};
        int i = 0;
        while (i < intervals.length) {
            final MenuItem refreshInterval = new MenuItem(refreshMenu, 16);
            final int interval = intervals[i];
            String text = interval == -1 ? Messages.RefreshHandler_DISABLED : NLS.bind((String)Messages.RefreshHandler_PATTERN_INTERVAL, (Object)intervals[i], (Object[])new Object[0]);
            refreshInterval.setText(text);
            refreshInterval.setSelection(this.fRefreshInterval == interval);
            refreshInterval.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RefreshHandler.this.setRefreshInterval(refreshInterval.getSelection() ? interval : -1);
                }
            });
            ++i;
        }
    }

    public void setRefreshInterval(int interval) {
        if (interval == this.fRefreshInterval) {
            return;
        }
        this.fRefreshInterval = interval;
        if (this.fRefreshJob != null && interval > 0) {
            this.scheduleRefresh(this.getRefreshIntervalMillis());
        }
    }

    public int getRefreshInterval() {
        return this.fRefreshInterval;
    }

    private Job getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new FoundationJob(NLS.bind((String)Messages.RefreshHandler_PATTERN_REFRESH_SECTION, (Object)this.fName, (Object[])new Object[0])){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        RefreshHandler.this.fRefreshableObject.refresh(monitor);
                        if (RefreshHandler.this.fRefreshInterval > 0) {
                            RefreshHandler.this.scheduleRefresh(RefreshHandler.this.getRefreshIntervalMillis());
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fRefreshJob.setSystem(true);
        }
        return this.fRefreshJob;
    }

    public void dispose() {
        if (this.fRefreshJob != null) {
            this.fRefreshJob.cancel();
        }
    }

    public void saveState(IMemento memento) {
        memento.putInteger(PREF_REFRESH_INTERVAL, this.fRefreshInterval);
    }

    public void scheduleRefresh(long delay) {
        Job refreshJob = this.getRefreshJob();
        if (refreshJob.getState() != 4) {
            refreshJob.cancel();
        }
        if (this.fSite.getProgressService() != null) {
            this.fSite.getProgressService().schedule(refreshJob, delay);
        } else {
            refreshJob.schedule(delay);
        }
    }

    private int getRefreshIntervalMillis() {
        return 60000 * this.fRefreshInterval;
    }
}

