/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.expression.Term;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.query.IGroupCount;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QueryDescriptorSummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySummaryInput {
    public static final int CONNECTION_ERROR = 1000;
    public static final int QUERY_DELETED_ERROR = 1001;
    public static final int LINK_QUERY_ERROR = 1002;
    private final List<IQueryDescriptorHandle> fQueryHandles;
    private final IQuerySummaryStrategy fStrategy;
    private List<IQueryDescriptor> fQueries;
    private List<IQuerySummary> fQuerySummaries;
    private List<IQuerySummary> fSortedSummaries;
    private IGroupingProvider fGroupingProvider;

    public QuerySummaryInput(List<IQueryDescriptorHandle> queries, IGroupingProvider groupingProvider, boolean showAllValues) {
        this.fQueryHandles = queries;
        this.fGroupingProvider = groupingProvider;
        IGroupingCollector.Mode mode = showAllValues ? IGroupingCollector.Mode.ALL_VALUES : IGroupingCollector.Mode.ACTUAL_VALUES;
        this.fStrategy = "com.ibm.team.workitem.groupingProvider.null".equals(groupingProvider.getId()) ? new IndividualSummaryStrategy() : new GroupedSummaryStrategy(groupingProvider, mode);
    }

    public IStatus resolve(IProgressMonitor monitor) {
        try {
            int progressFactor = 200;
            int usedFactor = 0;
            MultiStatus status = new MultiStatus("com.ibm.team.workitem.rcp.ui", 0, Messages.QuerySummaryInput_QUERY_SECTION_ERROR, null);
            monitor = ClientUtils.getProgressMonitor((IProgressMonitor)monitor);
            monitor.beginTask(Messages.QuerySummaryInput_REFRESHING_SUMMARIES, progressFactor * this.fQueryHandles.size());
            if (this.fQueries == null) {
                usedFactor += 100;
                this.fQueries = new ArrayList<IQueryDescriptor>(this.fQueryHandles.size());
                for (IQueryDescriptorHandle handle : this.fQueryHandles) {
                    IQueryDescriptor queryDescriptor = this.resolve(handle, (IProgressMonitor)new SubProgressMonitor(monitor, progressFactor), status);
                    if (queryDescriptor == null) continue;
                    this.fQueries.add(queryDescriptor);
                }
            }
            this.fQuerySummaries = this.fStrategy.createSummaries(this.fQueries, (IProgressMonitor)new SubProgressMonitor(monitor, (progressFactor - usedFactor) * this.fQueryHandles.size()), status);
            this.fSortedSummaries = null;
            if (status.getSeverity() == 4) {
                WorkItemRCPUIPlugin.getDefault().log((IStatus)status);
            }
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IQueryDescriptor resolve(IQueryDescriptorHandle handle, IProgressMonitor monitor, MultiStatus status) {
        try {
            monitor.beginTask(Messages.QuerySummaryInput_LOADING_QUERIES, 100);
            IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)handle, IAuditableClient.class);
            IQueryDescriptor iQueryDescriptor = (IQueryDescriptor)auditableClient.resolveAuditable((IAuditableHandle)handle, IQueryDescriptor.FULL_PROFILE, monitor);
            return iQueryDescriptor;
        }
        catch (ItemNotFoundException e) {
            status.add(this.createQueryNotFoundStatus(e));
            return null;
        }
        catch (TeamRepositoryException e) {
            status.add(QuerySummaryInput.createStatus(Messages.QuerySummaryInput_ERROR_RESOLVING_QUERY, e, (ITeamRepository)handle.getOrigin()));
            return null;
        }
        finally {
            monitor.done();
        }
    }

    public List<IQuerySummary> getQuerySummaries() {
        if (this.fQuerySummaries == null) {
            return Collections.emptyList();
        }
        if (this.fSortedSummaries == null) {
            ArrayList<IQuerySummary> summaries = new ArrayList<IQuerySummary>(this.fQuerySummaries);
            this.fGroupingProvider.sort(summaries);
            this.fSortedSummaries = summaries;
        }
        return this.fSortedSummaries;
    }

    public List<IQueryDescriptor> getResolvedQueries() {
        if (this.fQueries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.fQueries);
    }

    public static IStatus createStatus(String message, TeamRepositoryException e, ITeamRepository repository) {
        if (repository.loggedIn() && repository.getErrorState() == 0) {
            return QuerySummaryInput.createErrorStatus(message, e);
        }
        return QuerySummaryInput.createConnectionErrorStatus(e);
    }

    private static IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, "com.ibm.team.workitem.rcp.ui", message, e);
    }

    private static IStatus createConnectionErrorStatus(TeamRepositoryException e) {
        return new Status(2, "com.ibm.team.workitem.rcp.ui", 1000, Messages.QuerySummaryInput_CONNECTION_ERROR, (Throwable)e);
    }

    private IStatus createQueryNotFoundStatus(ItemNotFoundException e) {
        return new Status(2, "com.ibm.team.workitem.rcp.ui", 1001, Messages.QuerySummaryInput_SOME_QUERIES_NOT_FOUND, (Throwable)e);
    }

    private static IStatus createLinkQueryWarning(IQueryDescriptor queryDescriptor) {
        String message = NLS.bind((String)Messages.QuerySummaryInput_PATTERN_IGNORED_QUERY, (Object)queryDescriptor.getName(), (Object[])new Object[0]);
        return new Status(2, "com.ibm.team.workitem.rcp.ui", 1002, message, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupedSummaryStrategy
    implements IQuerySummaryStrategy {
        private final IGroupingProvider fGroupingProvider;
        private final IGroupingCollector.Mode fMode;

        public GroupedSummaryStrategy(IGroupingProvider provider, IGroupingCollector.Mode mode) {
            this.fGroupingProvider = provider;
            this.fMode = mode;
        }

        @Override
        public List<IQuerySummary> createSummaries(List<IQueryDescriptor> queries, IProgressMonitor monitor, MultiStatus status) {
            ArrayList<IQuerySummary> resultSummaries = new ArrayList<IQuerySummary>();
            if (queries.isEmpty()) {
                return resultSummaries;
            }
            ItemHandleAwareHashSet projectAreas = new ItemHandleAwareHashSet();
            for (IQueryDescriptor queryDescriptor : queries) {
                projectAreas.add((Object)queryDescriptor.getProjectArea());
            }
            for (IProjectAreaHandle projectArea : projectAreas) {
                IGroupingCollector collector = this.fGroupingProvider.createCollector(this.fMode);
                try {
                    Term combined = new Term(Term.Operator.OR);
                    for (IQueryDescriptor queryDescriptor : queries) {
                        if (!queryDescriptor.getProjectArea().sameItemId((IItemHandle)projectArea)) continue;
                        Expression conditions = QueryUtils.getConditions((Expression)queryDescriptor.getExpression());
                        combined.add(conditions);
                    }
                    if (combined.getExpressions().isEmpty()) continue;
                    IQueryableAttribute attribute = this.fGroupingProvider.getAttribute(projectArea, monitor);
                    IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IQueryClient.class);
                    List counts = queryClient.getGroupCounts(projectArea, (Expression)combined, attribute.getIdentifier(), monitor);
                    for (IGroupCount groupCount : counts) {
                        collector.add(projectArea, groupCount.getKey(), groupCount.getCount(), monitor);
                    }
                    List<IQuerySummary> adapters = this.createExpressionAdapters(combined, attribute, collector.getSummaries(), projectArea);
                    resultSummaries.addAll(adapters);
                }
                catch (SerializationException e) {
                    status.add(QuerySummaryInput.createErrorStatus(Messages.QuerySummaryInput_ERROR_TRANSFORMING_QUERY, e));
                }
                catch (TeamRepositoryException e) {
                    status.add(QuerySummaryInput.createStatus(Messages.QuerySummaryInput_ERROR_CREATING_SUMMARY, e, (ITeamRepository)projectArea.getOrigin()));
                }
            }
            return resultSummaries;
        }

        private List<IQuerySummary> createExpressionAdapters(Term combined, IQueryableAttribute attribute, List<IQuerySummary> summaries, IProjectAreaHandle projectArea) {
            ArrayList<IQuerySummary> adapters = new ArrayList<IQuerySummary>(summaries.size());
            AttributeOperation operator = AttributeOperation.EQUALS;
            for (IQuerySummary summary : summaries) {
                AttributeExpression expression = null;
                if (summary.getValues().size() == 1) {
                    expression = new AttributeExpression(attribute, operator, summary.getValues().iterator().next());
                } else if (!summary.getValues().isEmpty()) {
                    Term valueTerm = new Term(Term.Operator.OR);
                    for (Object value : summary.getValues()) {
                        valueTerm.add((Expression)new AttributeExpression(attribute, operator, value));
                    }
                    expression = valueTerm;
                }
                if (expression == null) continue;
                Term term = new Term(Term.Operator.AND);
                term.add((Expression)combined);
                term.add((Expression)expression);
                adapters.add(new QuerySummaryAdapter(summary, (Expression)term, projectArea));
            }
            return adapters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IQuerySummaryStrategy {
        public List<IQuerySummary> createSummaries(List<IQueryDescriptor> var1, IProgressMonitor var2, MultiStatus var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndividualSummaryStrategy
    implements IQuerySummaryStrategy {
        @Override
        public List<IQuerySummary> createSummaries(List<IQueryDescriptor> queries, IProgressMonitor monitor, MultiStatus status) {
            ArrayList<IQuerySummary> summaries = new ArrayList<IQuerySummary>(queries.size());
            for (IQueryDescriptor queryDescriptor : queries) {
                IProjectAreaHandle projectArea = queryDescriptor.getProjectArea();
                try {
                    Expression expression = queryDescriptor.getExpression();
                    IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)queryDescriptor, IQueryClient.class);
                    int count = queryClient.countExpressionResults(projectArea, expression, monitor);
                    QueryDescriptorSummary summary = new QueryDescriptorSummary(queryDescriptor, count);
                    summaries.add(summary);
                }
                catch (TeamRepositoryException e) {
                    status.add(QuerySummaryInput.createStatus(Messages.QuerySummaryInput_ERROR_COUNTING_RESULTS, e, (ITeamRepository)projectArea.getOrigin()));
                }
            }
            return summaries;
        }
    }
}

