/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.charts.IChartElementProviderExt;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummaryComparer;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.util.HashMap;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IViewSite;

public class QuerySummaryChartElementProvider
implements IChartElementProviderExt {
    private static ColorDescriptors[] NO_COLORS = new ColorDescriptors[0];
    private static int MAX_COLORS = 5;
    private ResourceManager fResourceManager;
    private FontDescriptor fBarFontDescriptor;
    private Font fBarFont;
    private int fColorCount;
    private ColorDescriptors[] fColorDescriptors;
    private final HashMap<Wrapper, Colors> fColorMap;
    private final QuerySummaryComparer fComparer;
    private Wrapper fWrapper = new Wrapper(null);

    public QuerySummaryChartElementProvider(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
        this.fBarFontDescriptor = Utils.createRelativeHeightFontDescriptor(-1);
        this.fBarFont = JazzResources.getFont((ResourceManager)this.fResourceManager, (FontDescriptor)this.fBarFontDescriptor, (Font)JFaceResources.getDefaultFont());
        this.fColorCount = MAX_COLORS;
        this.fColorDescriptors = NO_COLORS;
        this.fColorMap = new HashMap();
        this.fComparer = new QuerySummaryComparer();
    }

    public void setColorCount(int count) {
        this.fColorCount = Math.max(0, Math.min(count, MAX_COLORS));
    }

    private void updateColors() {
        if (this.fColorDescriptors.length == this.fColorCount) {
            return;
        }
        this.disposeColors();
        this.fColorDescriptors = new ColorDescriptors[this.fColorCount];
        int i = 0;
        while (i < this.fColorCount) {
            ColorDescriptors colorDescriptors = new ColorDescriptors();
            int colorIntensity = 140 + i * 100 / this.fColorCount;
            RGB rgb = new RGB(colorIntensity, colorIntensity, colorIntensity);
            colorDescriptors.foreground = ColorDescriptor.createFrom((RGB)ColorUtils.addColor((RGB)rgb, (float)50.0f));
            colorDescriptors.background = ColorDescriptor.createFrom((RGB)rgb);
            colorDescriptors.activeForeground = ColorDescriptor.createFrom((RGB)ColorUtils.addColor((RGB)rgb, (float)30.0f));
            colorDescriptors.activeBackground = ColorDescriptor.createFrom((RGB)ColorUtils.addColor((RGB)rgb, (RGB)new RGB(0, 0, 0), (float)8.0f));
            this.fColorDescriptors[i] = colorDescriptors;
            ++i;
        }
    }

    private void disposeColors() {
        ColorDescriptors[] colorDescriptorsArray = this.fColorDescriptors;
        int n = this.fColorDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDescriptors descriptor = colorDescriptorsArray[n2];
            this.fResourceManager.destroyColor(descriptor.foreground);
            this.fResourceManager.destroyColor(descriptor.background);
            this.fResourceManager.destroyColor(descriptor.activeForeground);
            this.fResourceManager.destroyColor(descriptor.activeBackground);
            ++n2;
        }
        this.fColorDescriptors = NO_COLORS;
        this.fColorMap.clear();
    }

    private Colors getColors(Object element) {
        this.updateColors();
        if (this.fColorDescriptors.length == 0) {
            return null;
        }
        this.fWrapper.fObject = element;
        Colors colors = this.fColorMap.get(this.fWrapper);
        if (colors == null) {
            colors = new Colors();
            ColorDescriptors descriptors = this.fColorDescriptors[this.fColorMap.size() % this.fColorCount];
            colors.foreground = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)descriptors.foreground);
            colors.background = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)descriptors.background);
            colors.activeForeground = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)descriptors.activeForeground);
            colors.activeBackground = JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)descriptors.activeBackground);
            this.fColorMap.put(new Wrapper(element), colors);
        }
        return colors;
    }

    public void init(IViewSite viewSite) {
    }

    public void dispose() {
        this.fResourceManager.destroyFont(this.fBarFontDescriptor);
        this.fBarFontDescriptor = null;
        this.fBarFont = null;
    }

    public Font getFont(Object element) {
        return this.fBarFont;
    }

    public String getShortText(Object element) {
        String text = this.getText(element);
        int maxLength = 6;
        String probe = NLS.bind((String)Messages.QuerySummaryChartElementProvider_SHORTENED, (Object)"");
        int probeLength = probe.length();
        if (probeLength >= maxLength) {
            return probe.substring(0, maxLength);
        }
        if (text.length() > maxLength) {
            return NLS.bind((String)Messages.QuerySummaryChartElementProvider_SHORTENED, (Object)text.substring(0, maxLength - probeLength));
        }
        return text;
    }

    public String getText(Object element) {
        if (element instanceof IQuerySummary) {
            IQuerySummary summary = (IQuerySummary)element;
            return summary.getLabel();
        }
        return "";
    }

    public int getValue(Object element) {
        if (element instanceof IQuerySummary) {
            IQuerySummary summary = (IQuerySummary)element;
            return summary.getCount();
        }
        return 0;
    }

    public String getValueAsString(Object element) {
        return String.valueOf(this.getValue(element));
    }

    public boolean isBusyLoading(Object element) {
        return false;
    }

    public String getAnnotation(Object element) {
        return null;
    }

    public Font getAnnotationFont(Object element) {
        return null;
    }

    public Color getActiveBackgroundColor(Object element) {
        Colors colors = this.getColors(element);
        return colors != null ? colors.activeBackground : null;
    }

    public Color getActiveForegroundColor(Object element) {
        Colors colors = this.getColors(element);
        return colors != null ? colors.activeForeground : null;
    }

    public Color getBackgroundColor(Object element) {
        Colors colors = this.getColors(element);
        return colors != null ? colors.background : null;
    }

    public Color getForegroundColor(Object element) {
        Colors colors = this.getColors(element);
        return colors != null ? colors.foreground : null;
    }

    public Color getColor(Object element) {
        return null;
    }

    private static class ColorDescriptors {
        ColorDescriptor foreground;
        ColorDescriptor background;
        ColorDescriptor activeForeground;
        ColorDescriptor activeBackground;

        private ColorDescriptors() {
        }
    }

    private static class Colors {
        Color foreground;
        Color background;
        Color activeForeground;
        Color activeBackground;

        private Colors() {
        }
    }

    private class Wrapper {
        private Object fObject;

        public Wrapper(Object object) {
            this.fObject = object;
        }

        public Object getObject() {
            return this.fObject;
        }

        public boolean equals(Object object) {
            if (object instanceof Wrapper) {
                object = ((Wrapper)object).getObject();
            }
            return QuerySummaryChartElementProvider.this.fComparer.equals(this.fObject, object);
        }

        public int hashCode() {
            return QuerySummaryChartElementProvider.this.fComparer.hashCode(this.fObject);
        }
    }
}

