/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.GroupingProviders;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySectionWizardContext {
    private QuerySectionConfiguration fConfiguration;
    private String fOriginalName;
    private int fOriginalRefreshInterval;
    private List<IProjectAreaHandle> fProjectAreas;
    private String fName;
    private QuerySectionConfiguration.BarStyle fStyle;
    private IGroupingProvider fGroupingProvider;
    private int fRefreshInterval;
    private boolean fShowAllGroups;
    private List<IQueryDescriptorHandle> fQueryHandles;

    public QuerySectionWizardContext(QuerySectionConfiguration configuration, String sectionName, int refreshInterval) {
        this.fConfiguration = configuration;
        this.fOriginalName = sectionName;
        this.fOriginalRefreshInterval = refreshInterval;
        this.initDefaults();
    }

    private void initDefaults() {
        this.fName = this.fOriginalName;
        this.fRefreshInterval = this.fOriginalRefreshInterval;
        this.fStyle = this.fConfiguration.getBarStyle();
        this.fGroupingProvider = this.fConfiguration.getGroupingProvider();
        this.fShowAllGroups = this.fConfiguration.getShowAllGroups();
        this.fQueryHandles = new ArrayList<IQueryDescriptorHandle>(this.fConfiguration.getLocations().getItems());
    }

    public List<IProjectAreaHandle> getSelectedProjectAreas() {
        return this.fProjectAreas != null ? this.fProjectAreas : Collections.emptyList();
    }

    public void setSelectedProjectAreas(List<IProjectAreaHandle> projectAreas) {
        this.fProjectAreas = projectAreas;
    }

    public List<IGroupingProvider> getGroupingProviders() {
        ArrayList<IGroupingProvider> groupingProviders = new ArrayList<IGroupingProvider>(GroupingProviders.getAll());
        Collections.sort(groupingProviders, GroupingProviders.COMPARATOR);
        return groupingProviders;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setStyle(QuerySectionConfiguration.BarStyle style) {
        this.fStyle = style;
    }

    public QuerySectionConfiguration.BarStyle getStyle() {
        return this.fStyle;
    }

    public void setGroupingProvider(IGroupingProvider provider) {
        this.fGroupingProvider = provider;
    }

    public IGroupingProvider getGroupingProvider() {
        return this.fGroupingProvider;
    }

    public void setRefreshInterval(int interval) {
        this.fRefreshInterval = interval;
    }

    public int getRefreshInterval() {
        return this.fRefreshInterval;
    }

    public List<Location> getMissingLocations() {
        return this.fConfiguration.getLocations().getMissingLocations();
    }

    public void setShowAllGroups(boolean show) {
        this.fShowAllGroups = show;
    }

    public boolean getShowAllGroups() {
        return this.fShowAllGroups;
    }

    public void setQueryHandles(List<IQueryDescriptorHandle> handles) {
        this.fQueryHandles = handles;
    }

    public List<IQueryDescriptorHandle> getQueryHandles() {
        return this.fQueryHandles;
    }
}

