/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.ide.ui.ProjectAreaConnectionPage;
import com.ibm.team.process.ide.ui.WizardContext;
import com.ibm.team.process.internal.ide.ui.wizards.AbstractWizardContext;
import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionWizardContext;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySectionWizardPage;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.SelectQueriesWizardPage;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class QuerySectionConfigurationWizard
extends Wizard {
    private RepositoryCreationPage fRepositoryCreationPage;
    private RepositorySelectionPage fRepositorySelectionPage;
    private ProjectAreaConnectionPage fProjectAreaConnectionPage;
    private SelectQueriesWizardPage fSelectQueriesPage;
    private QuerySectionWizardPage fQuerySectionPage;
    private WizardContext fProcessWizardContext = new WizardContext();
    private QuerySectionWizardContext fWizardContext;

    public QuerySectionConfigurationWizard(QuerySectionWizardContext context) {
        this.fWizardContext = context;
        this.setWindowTitle(Messages.QuerySectionConfigurationWizard_CONFIGURE_QUERY_SECTION);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addRepositoryCreationPage();
        this.addRepositorySelectionPage();
        this.addProjectAreaPage();
        this.addSelectQueriesPage();
        this.addQuerySectionPage();
    }

    public IWizardPage getStartingPage() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        if (repositories.length == 0) {
            return this.fRepositoryCreationPage;
        }
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(null);
        if (projectAreas.isEmpty()) {
            if (repositories.length == 1) {
                this.fProcessWizardContext.setTeamRepository(repositories[0]);
                return this.fProjectAreaConnectionPage;
            }
            return this.fRepositorySelectionPage;
        }
        this.fProcessWizardContext.setTeamRepository(repositories[0]);
        return this.fSelectQueriesPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage;
        if (page == this.fProjectAreaConnectionPage) {
            this.fWizardContext.setSelectedProjectAreas(this.fProjectAreaConnectionPage.getSelectedProjectAreas());
        }
        if ((nextPage = this.fProjectAreaConnectionPage.getNextPage(page, this.fRepositorySelectionPage, this.fRepositoryCreationPage, (AbstractWizardContext)this.fProcessWizardContext)) != null) {
            return nextPage;
        }
        return super.getNextPage(page);
    }

    private void addRepositoryCreationPage() {
        this.fRepositoryCreationPage = new RepositoryCreationPage(Messages.QuerySectionConfigurationWizard_CREATE_REPOSITORY);
        this.addPage((IWizardPage)this.fRepositoryCreationPage);
    }

    private void addRepositorySelectionPage() {
        this.fRepositorySelectionPage = new RepositorySelectionPage(Messages.QuerySectionConfigurationWizard_SELECT_REPOSITORY);
        this.addPage((IWizardPage)this.fRepositorySelectionPage);
    }

    private void addProjectAreaPage() {
        this.fProjectAreaConnectionPage = new ProjectAreaConnectionPage(this.fProcessWizardContext);
        this.addPage((IWizardPage)this.fProjectAreaConnectionPage);
    }

    private void addSelectQueriesPage() {
        this.fSelectQueriesPage = new SelectQueriesWizardPage(this.fWizardContext);
        this.addPage((IWizardPage)this.fSelectQueriesPage);
    }

    private void addQuerySectionPage() {
        this.fQuerySectionPage = new QuerySectionWizardPage(this.fWizardContext);
        this.addPage((IWizardPage)this.fQuerySectionPage);
    }

    public boolean canFinish() {
        return this.fWizardContext.getName().length() > 0;
    }

    public boolean performFinish() {
        this.fProjectAreaConnectionPage.connectSelectedProjectAreas();
        return true;
    }
}

