/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationGroup<T extends IItemHandle> {
    private static final String KEY_LOCATIONS = "locations";
    private static final String KEY_LOCATION = "location";
    private static final String KEY_URI = "uri";
    private static final String KEY_REPOSITORY_ID = "repoId";
    private Collection<T> fItems;
    private List<Location> fMissingLocations = new ArrayList<Location>();
    private static final String MEMENTO_PREF_QUERIES = "PREF_QUERIES";
    private static final String MEMENTO_PREF_REPOSITORIES = "REF_REPOSITORIES";

    public LocationGroup() {
        this.fItems = Collections.emptyList();
    }

    public Collection<T> getItems() {
        return this.fItems;
    }

    public void setItems(Collection<T> items) {
        this.fItems = items;
    }

    public List<Location> getMissingLocations() {
        return Collections.unmodifiableList(this.fMissingLocations);
    }

    public void init(IMemento memento) {
        ArrayList<T> items = new ArrayList<T>();
        IMemento locations = memento.getChild(KEY_LOCATIONS);
        if (locations != null) {
            IMemento[] iMementoArray = locations.getChildren(KEY_LOCATION);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento locationMemento = iMementoArray[n2];
                T handle = this.createItemHandle(locationMemento);
                if (handle != null) {
                    items.add(handle);
                }
                ++n2;
            }
        }
        this.fItems = items;
        if (this.fItems.isEmpty()) {
            this.fItems = this.findCompatibilityItems(memento);
        }
    }

    public void saveState(IMemento memento) {
        IMemento locations = memento.createChild(KEY_LOCATIONS);
        for (IItemHandle item : this.fItems) {
            ITeamRepository repository = (ITeamRepository)item.getOrigin();
            Location location = Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI());
            IMemento locationMemento = locations.createChild(KEY_LOCATION);
            locationMemento.putString(KEY_URI, location.toAbsoluteUri().toString());
            if (repository.getId() == null) continue;
            locationMemento.putString(KEY_REPOSITORY_ID, repository.getId().getUuidValue());
        }
    }

    private T createItemHandle(IMemento locationMemento) {
        ITeamRepository repository;
        ItemHandle handle;
        block6: {
            URI uri = new URI(locationMemento.getString(KEY_URI));
            String repositoryId = locationMemento.getString(KEY_REPOSITORY_ID);
            UUID repositoryUUID = repositoryId != null ? UUID.valueOf((String)repositoryId) : null;
            Location location = Location.location((URI)uri);
            handle = (ItemHandle)location.getItemHandle();
            repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(location.getRepoUri(), 4);
            if (repository == null) {
                repository = this.findRepository(repositoryUUID);
            }
            if (repository != null) break block6;
            this.fMissingLocations.add(location);
            return null;
        }
        try {
            handle.setOrigin((Object)repository);
            return (T)handle;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return null;
        }
    }

    private ITeamRepository findRepository(UUID repositoryId) {
        if (repositoryId != null) {
            ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
            int n = iTeamRepositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository repository = iTeamRepositoryArray[n2];
                if (repositoryId.equals((Object)repository.getId())) {
                    return repository;
                }
                ++n2;
            }
        }
        return null;
    }

    private List<T> findCompatibilityItems(IMemento memento) {
        String prefRepositories;
        String[] queries = null;
        String[] repoUrls = null;
        String prefQueries = memento.getString(MEMENTO_PREF_QUERIES);
        if (prefQueries != null && prefQueries.length() > 0) {
            queries = prefQueries.split("\\,");
        }
        if ((prefRepositories = memento.getString(MEMENTO_PREF_REPOSITORIES)) != null && prefRepositories.length() > 0) {
            repoUrls = prefRepositories.split("\\,");
        }
        if (queries != null && repoUrls != null && queries.length == repoUrls.length) {
            ArrayList<T> compatibilityList = new ArrayList<T>();
            int i = 0;
            while (i < repoUrls.length) {
                String uuid;
                T handle;
                String queryString = queries[i];
                int uuidEnd = queryString.indexOf(47);
                if (uuidEnd > 0 && (handle = this.createHandle(uuid = queryString.substring(0, uuidEnd), repoUrls[i])) != null) {
                    compatibilityList.add(handle);
                }
                ++i;
            }
            return compatibilityList;
        }
        return Collections.emptyList();
    }

    private T createHandle(String uuid, String repoUri) {
        try {
            UUID itemId = UUID.valueOf((String)uuid.trim());
            ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoUri.trim(), 4);
            if (repository != null) {
                return (T)IQueryDescriptor.ITEM_TYPE.createItemHandle((Object)repository, itemId, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }
}

