/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AuditableGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.EnumerationGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.Messages;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.ResolutionGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.StateGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.TagGroupingProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.TypeGroupingProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingProviders {
    public static final String NULL_GROUPING_PROVIDER_ID = "com.ibm.team.workitem.groupingProvider.null";
    public static final Comparator<? super IGroupingProvider> COMPARATOR = new Comparator<IGroupingProvider>(){
        Collator collator = Collator.getInstance();

        @Override
        public int compare(IGroupingProvider gp1, IGroupingProvider gp2) {
            if (GroupingProviders.NULL_GROUPING_PROVIDER_ID.equals(gp1.getId())) {
                return -1;
            }
            if (GroupingProviders.NULL_GROUPING_PROVIDER_ID.equals(gp2.getId())) {
                return 1;
            }
            return this.collator.compare(gp1.getDisplayName(), gp2.getDisplayName());
        }
    };
    private static IGroupingProvider NULL_GROUPING_PROVIDER = new IGroupingProvider(){

        @Override
        public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
            return null;
        }

        @Override
        public IQueryableAttribute getAttribute(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
            return null;
        }

        @Override
        public String getDisplayName() {
            return Messages.GroupingProviders_NO_GROUPING;
        }

        @Override
        public String getId() {
            return GroupingProviders.NULL_GROUPING_PROVIDER_ID;
        }

        @Override
        public boolean supportsShowAllGroups() {
            return false;
        }

        @Override
        public void sort(List<IQuerySummary> summaries) {
        }
    };
    private static List<? extends IGroupingProvider> fgProviders = Arrays.asList(NULL_GROUPING_PROVIDER, new EnumerationGroupingProvider<IPriority>(IPriority.class, Messages.GroupingProviders_PRIORITY, (Identifier<IAttribute>)WorkItemAttributes.PRIORITY, EnumerationGroupingProvider.SortOrder.SORT_BY_IDENTIFIER), new EnumerationGroupingProvider<ISeverity>(ISeverity.class, Messages.GroupingProviders_SEVERITY, (Identifier<IAttribute>)WorkItemAttributes.SEVERITY, EnumerationGroupingProvider.SortOrder.SORT_BY_IDENTIFIER), new TypeGroupingProvider(Messages.GroupingProviders_TYPE, (Identifier<IAttribute>)WorkItemAttributes.TYPE), new StateGroupingProvider(Messages.GroupingProviders_STATUS, false, WorkItemAttributes.STATE.getStringIdentifier()), new StateGroupingProvider(Messages.GroupingProviders_STATUS_GROUPS, true, "com.ibm.team.workitem.customGroups.statusGroup"), new ResolutionGroupingProvider(Messages.GroupingProviders_RESOLUTION, (Identifier<IAttribute>)WorkItemAttributes.RESOLUTION), new TagGroupingProvider(Messages.GroupingProviders_TAGS, (Identifier<IAttribute>)WorkItemAttributes.TAGS), new AuditableGroupingProvider(Messages.GroupingProviders_OWNER, (Identifier<IAttribute>)WorkItemAttributes.OWNER, IContributor.ITEM_TYPE), new AuditableGroupingProvider(Messages.GroupingProviders_RESOLVER, (Identifier<IAttribute>)WorkItemAttributes.RESOLVER, IContributor.ITEM_TYPE), new AuditableGroupingProvider(Messages.GroupingProviders_CREATOR, (Identifier<IAttribute>)WorkItemAttributes.CREATOR, IContributor.ITEM_TYPE), new AuditableGroupingProvider(Messages.GroupingProviders_CATEGORY, (Identifier<IAttribute>)WorkItemAttributes.CATEGORY, ICategory.ITEM_TYPE), new AuditableGroupingProvider(Messages.GroupingProviders_PLANNED_FOR, (Identifier<IAttribute>)WorkItemAttributes.TARGET, IIteration.ITEM_TYPE), new AuditableGroupingProvider(Messages.GroupingProviders_FOUND_IN, (Identifier<IAttribute>)WorkItemAttributes.VERSION, IDeliverable.ITEM_TYPE));

    public static List<IGroupingProvider> getAll() {
        return Collections.unmodifiableList(fgProviders);
    }

    public static IGroupingProvider get(String providerId) {
        for (IGroupingProvider iGroupingProvider : fgProviders) {
            if (!providerId.equals(iGroupingProvider.getId())) continue;
            return iGroupingProvider;
        }
        return null;
    }
}

