/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.icu.text.Collator;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IQuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationGroupingProvider<T extends ILiteral>
extends WorkItemGroupingProvider {
    private Class<T> fType;
    private SortOrder fSortOrder;

    public EnumerationGroupingProvider(Class<T> type, String label, Identifier<IAttribute> identifier, SortOrder sortOrder) {
        super(label, identifier);
        this.fType = type;
        this.fSortOrder = sortOrder;
    }

    @Override
    public boolean supportsShowAllGroups() {
        return true;
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new EnumerationCollector(mode);
    }

    @Override
    public void sort(List<IQuerySummary> summaries) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnumerationCollector
    extends AbstractGroupingCollector {
        private final IGroupingCollector.Mode fMode;
        private final HashMap<UUID, IEnumeration<T>> fCache;

        public EnumerationCollector(IGroupingCollector.Mode mode) {
            this.fMode = mode;
            this.fCache = new HashMap();
        }

        @Override
        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.isEmptyKey(key)) {
                return;
            }
            IEnumeration enumeration = this.findEnumeration(projectArea, monitor);
            if (enumeration != null) {
                QuerySummary summary = this.findSummary(enumeration, key);
                summary.addCount(count);
            }
        }

        @Override
        public List<IQuerySummary> getSummaries() {
            List<IQuerySummary> summaries = super.getSummaries();
            if (IGroupingCollector.Mode.ACTUAL_VALUES == this.fMode) {
                Iterator<IQuerySummary> iterator = summaries.iterator();
                while (iterator.hasNext()) {
                    IQuerySummary summary = iterator.next();
                    if (summary.getCount() != 0) continue;
                    iterator.remove();
                }
            }
            return summaries;
        }

        private QuerySummary findSummary(IEnumeration<T> enumeration, String key) {
            Identifier identifier;
            QuerySummary summary;
            if (this.isEmpty()) {
                ArrayList literals = new ArrayList(enumeration.getEnumerationLiterals());
                if (EnumerationGroupingProvider.this.fSortOrder == SortOrder.SORT_BY_IDENTIFIER) {
                    Collections.sort(literals, new Comparator<T>(){
                        private Collator collator = Collator.getInstance();

                        @Override
                        public int compare(T o1, T o2) {
                            return this.collator.compare(o1.getIdentifier2().getStringIdentifier(), o2.getIdentifier2().getStringIdentifier());
                        }
                    });
                }
                for (ILiteral literal : literals) {
                    QuerySummary summary2 = new QuerySummary(literal.getName(), 0);
                    summary2.addValue(literal.getIdentifier2());
                    this.addSummary(summary2);
                }
            }
            if ((summary = this.findExisting(identifier = Identifier.create((Class)EnumerationGroupingProvider.this.fType, (String)key))) == null) {
                ILiteral literal;
                String label = null;
                label = this.isEmptyKey(key) ? EMPTY_LABEL : ((literal = enumeration.findEnumerationLiteral(identifier)) != null ? literal.getName() : key);
                summary = new QuerySummary(label, 0);
                summary.addValue(identifier);
                this.addSummary(summary);
            }
            return summary;
        }

        private IEnumeration<T> findEnumeration(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient workItemClient;
            IAttribute attribute;
            IEnumeration enumeration = this.fCache.get(projectArea.getItemId());
            if (enumeration == null && (attribute = (workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class)).findAttribute(projectArea, EnumerationGroupingProvider.this.getAttributeIdentifier(), monitor)) != null) {
                enumeration = workItemClient.resolveEnumeration((IAttributeHandle)attribute, monitor);
                this.fCache.put(projectArea.getItemId(), enumeration);
            }
            return enumeration;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        SORT_BY_IDENTIFIER,
        SORT_BY_DECLARATION;

    }
}

