/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.dashboard;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.AbstractGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.IGroupingCollector;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.QuerySummary;
import com.ibm.team.workitem.rcp.ui.internal.dashboard.WorkItemGroupingProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditableGroupingProvider
extends WorkItemGroupingProvider {
    private IItemType fItemType;

    public AuditableGroupingProvider(String label, Identifier<IAttribute> identifier, IItemType itemType) {
        super(label, identifier);
        this.fItemType = itemType;
        Assert.isLegal((boolean)this.fItemType.isAuditable());
    }

    @Override
    public IGroupingCollector createCollector(IGroupingCollector.Mode mode) {
        return new AuditableCollector();
    }

    private class AuditableCollector
    extends AbstractGroupingCollector {
        private AuditableCollector() {
        }

        public void add(IProjectAreaHandle projectArea, String key, int count, IProgressMonitor monitor) throws TeamRepositoryException {
            QuerySummary summary = this.findSummary(projectArea, key, monitor);
            summary.addCount(count);
        }

        private QuerySummary findSummary(IProjectAreaHandle projectArea, String key, IProgressMonitor monitor) throws TeamRepositoryException {
            IAuditableHandle handle = this.getHandle(key, projectArea.getOrigin());
            QuerySummary summary = this.findExisting(handle);
            if (summary == null) {
                if (handle != null) {
                    IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IAuditableClient.class);
                    ItemProfile profile = AttributeLabelProviderFactory.getItemProfile(handle.getItemType());
                    IAuditable auditable = auditableClient.resolveAuditable(handle, profile, monitor);
                    IQueryableAttribute attribute = AuditableGroupingProvider.this.getAttribute(projectArea, monitor);
                    summary = new AuditableQuerySummary(attribute, auditable);
                } else {
                    summary = new QuerySummary(this.isEmptyKey(key) ? EMPTY_LABEL : key, 0);
                    summary.addValue(key);
                }
                this.addSummary(summary);
            }
            return summary;
        }

        private IAuditableHandle getHandle(String key, Object origin) {
            if (!this.isEmptyKey(key)) {
                UUID itemId = UUID.valueOf((String)key);
                return (IAuditableHandle)AuditableGroupingProvider.this.fItemType.createItemHandle(origin, itemId, null);
            }
            return null;
        }
    }

    private static class AuditableQuerySummary
    extends QuerySummary {
        private IQueryableAttribute fAttribute;
        private IAuditable fAuditable;
        private String fCachedLabel;

        public AuditableQuerySummary(IQueryableAttribute attribute, IAuditable auditable) {
            super(null, 0);
            this.fAttribute = attribute;
            this.fAuditable = auditable;
            this.fCachedLabel = "";
            this.addValue(auditable);
        }

        public String getLabel() {
            if (Display.getCurrent() != null) {
                IAttributeLabelProvider provider = AttributeLabelProviderFactory.createLabelProvider(this.fAttribute, false);
                this.fCachedLabel = provider.getText(this.fAuditable);
                provider.dispose();
            }
            return this.fCachedLabel != null ? this.fCachedLabel : EMPTY_LABEL;
        }
    }
}

