/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ChangeWorkItemStateOperation;
import com.ibm.team.workitem.rcp.ui.internal.ItemSelectionDialog;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.AbstractChangeWorkItemAttributeAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.AttributeValueSetDropDownAction;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.TypeFilterSelectionProvider;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueSelectorFactory {
    private static AttributeValueSelectorFactory fgInstance = new AttributeValueSelectorFactory();
    private HashSet<String> fMenuProviders = new HashSet();
    private HashMap<String, Class<? extends AbstractChangeWorkItemAttributeAction>> fActionProviders;

    public static AttributeValueSelectorFactory getInstance() {
        return fgInstance;
    }

    private AttributeValueSelectorFactory() {
        this.fMenuProviders.add("type");
        this.fMenuProviders.add("boolean");
        this.fActionProviders = new HashMap();
        this.fActionProviders.put(IWorkItem.OWNER_PROPERTY, ContributorSelectionAction.class);
        this.fActionProviders.put(IWorkItem.CATEGORY_PROPERTY, CategorySelectionAction.class);
        this.fActionProviders.put(IWorkItem.TARGET_PROPERTY, IterationSelectionAction.class);
    }

    public IContributionItem createValueSelector(IAttribute attribute, ISelectionProvider selectionProvider) {
        TypeFilterSelectionProvider provider = new TypeFilterSelectionProvider(selectionProvider, IWorkItem.class);
        if (IWorkItem.STATE_PROPERTY.equals(attribute.getIdentifier())) {
            return this.createMenuStateSelector(attribute, provider);
        }
        if (this.fMenuProviders.contains(attribute.getAttributeType())) {
            return this.createMenuValueSelector(attribute, provider);
        }
        if (AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType())) {
            return this.createMenuValueSelector(attribute, provider);
        }
        Class<? extends AbstractChangeWorkItemAttributeAction> clazz = this.fActionProviders.get(attribute.getIdentifier());
        if (clazz != null) {
            try {
                Constructor<? extends AbstractChangeWorkItemAttributeAction> ctor = clazz.getConstructor(IAttribute.class, ISelectionProvider.class);
                AbstractChangeWorkItemAttributeAction action = ctor.newInstance(attribute, provider);
                return new ActionContributionItem((IAction)action);
            }
            catch (Exception e) {
                WorkItemRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.AttributeValueSelectorFactory_COULD_NOT_CREATE_SELECTOR, (Object)attribute.getIdentifier(), (Object[])new Object[0]), e);
            }
        }
        return null;
    }

    private IContributionItem createMenuValueSelector(IAttribute attribute, ISelectionProvider provider) {
        IWorkItem workItem = this.getWorkItem(provider);
        if (workItem == null) {
            return null;
        }
        return new AttributeValueSetDropDownAction(AttributeValueSelectorFactory.createChangeLabel(attribute, false), attribute, provider).getMenuManager();
    }

    private static String createChangeLabel(IAttribute attribute, boolean ellipsis) {
        if (ellipsis) {
            return NLS.bind((String)Messages.AttributeValueSelectorFactory_PATTERN_CHANGE_ELLIPSIS, (Object)attribute.getDisplayName(), (Object[])new Object[0]);
        }
        return NLS.bind((String)Messages.AttributeValueSelectorFactory_PATTERN_CHANGE, (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private MenuManager createMenuStateSelector(IAttribute attribute, ISelectionProvider provider) {
        IWorkItem workItem = this.getWorkItem(provider);
        if (workItem != null) {
            Identifier[] actionIds;
            ITeamRepository repository = (ITeamRepository)attribute.getOrigin();
            IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
            IWorkflowInfo workflowInfo = client.findCachedWorkflowInfo(workItem);
            Identifier state = workItem.getState2();
            if (state != null && (actionIds = workflowInfo.getActionIds(state)).length > 0) {
                MenuManager menuManager = new MenuManager(AttributeValueSelectorFactory.createChangeLabel(attribute, false));
                int i = 0;
                while (i < actionIds.length) {
                    Identifier actionId = actionIds[i];
                    Identifier[] resIds = workflowInfo.getResolutionIds(actionId);
                    if (resIds != null && resIds.length > 1) {
                        menuManager.add((IContributionItem)this.createResolutionSubMenu((Identifier<IWorkflowAction>)actionId, resIds, workflowInfo, provider));
                    } else {
                        ImageDescriptor descriptor;
                        ChangeWorkItemStateAction action = new ChangeWorkItemStateAction(workflowInfo.getActionName(actionId), provider, (Identifier<IWorkflowAction>)actionId, null);
                        URL url = workflowInfo.getActionIconName(actionId);
                        if (url != null && (descriptor = WorkItemUI.getImageDescriptor(url)) != null) {
                            action.setImageDescriptor(descriptor);
                        }
                        menuManager.add((IAction)action);
                    }
                    ++i;
                }
                return menuManager;
            }
        }
        return null;
    }

    private MenuManager createResolutionSubMenu(Identifier<IWorkflowAction> actionId, Identifier<IResolution>[] resolutionsIds, IWorkflowInfo workflowInfo, ISelectionProvider provider) {
        ImageDescriptor image = null;
        URL menuIconUrl = workflowInfo.getActionIconName(actionId);
        if (menuIconUrl != null) {
            image = WorkItemUI.getImageDescriptor(menuIconUrl);
        }
        MenuManager result = new MenuManager(workflowInfo.getActionName(actionId), image, null);
        Identifier<IResolution>[] identifierArray = resolutionsIds;
        int n = resolutionsIds.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor descriptor;
            Identifier<IResolution> curResId = identifierArray[n2];
            ChangeWorkItemStateAction curResAction = new ChangeWorkItemStateAction(workflowInfo.getResolutionName(curResId), provider, actionId, curResId);
            URL curResIconUrl = workflowInfo.getResolutionIconName(curResId);
            if (curResIconUrl != null && (descriptor = WorkItemUI.getImageDescriptor(curResIconUrl)) != null) {
                curResAction.setImageDescriptor(descriptor);
            }
            result.add((IAction)curResAction);
            ++n2;
        }
        return result;
    }

    private IWorkItem getWorkItem(ISelectionProvider provider) {
        ISelection selection = provider.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            return (IWorkItem)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private static class CategorySelectionAction
    extends AbstractChangeWorkItemAttributeAction {
        private ISelectionProvider fSelectionProvider;

        public CategorySelectionAction(IAttribute attribute, ISelectionProvider provider) {
            super(attribute, provider);
            this.fSelectionProvider = provider;
            this.setText(AttributeValueSelectorFactory.createChangeLabel(attribute, true));
        }

        protected Object getValue() {
            IStructuredSelection ss;
            Object firstElement;
            IWorkItem workitem = null;
            ISelection selection = this.fSelectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IWorkItem) {
                workitem = (IWorkItem)firstElement;
            }
            if (workitem != null) {
                try {
                    return ItemSelectionDialog.getCategory(this.getShell(), workitem.getProjectArea(), workitem, null, false);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeWorkItemStateAction
    extends Action {
        private ISelectionProvider fSelectionProvider;
        private Identifier<IWorkflowAction> fActionId;
        private final Identifier<IResolution> fResolutionId;

        public ChangeWorkItemStateAction(String name, ISelectionProvider selectionProvider, Identifier<IWorkflowAction> actionId, Identifier<IResolution> resolutionId) {
            super(name);
            this.fSelectionProvider = selectionProvider;
            this.fActionId = actionId;
            this.fResolutionId = resolutionId;
        }

        public void run() {
            ISelection selection = this.fSelectionProvider.getSelection();
            if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            List elements = ((IStructuredSelection)selection).toList();
            ChangeWorkItemStateOperation operation = new ChangeWorkItemStateOperation(Messages.AttributeValueSelectorFactory_CHANGING_STATE, this.fActionId, this.fResolutionId);
            operation.runInJob(elements.toArray(new IWorkItemHandle[elements.size()]));
        }
    }

    private static class ContributorSelectionAction
    extends AbstractChangeWorkItemAttributeAction {
        public ContributorSelectionAction(IAttribute attribute, ISelectionProvider provider) {
            super(attribute, provider);
            this.setText(AttributeValueSelectorFactory.createChangeLabel(attribute, true));
        }

        protected Object getValue() {
            IContributorHandle[] contributorResult;
            TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.getShell(), this.getTeamRepository(), Collections.emptyList(), false);
            dialog.setTitle(Messages.AttributeValueSelectorFactory_USERS);
            dialog.setShellTitle(Messages.AttributeValueSelectorFactory_USERS);
            dialog.setMessage(Messages.AttributeValueSelectorFactory_SELECT_USER_MESSAGE);
            if (dialog.open() == 0 && (contributorResult = dialog.getContributorResult()).length > 0) {
                return contributorResult[0];
            }
            return null;
        }
    }

    private static class IterationSelectionAction
    extends AbstractChangeWorkItemAttributeAction {
        private ISelectionProvider fSelectionProvider;

        public IterationSelectionAction(IAttribute attribute, ISelectionProvider provider) {
            super(attribute, provider);
            this.fSelectionProvider = provider;
            this.setText(AttributeValueSelectorFactory.createChangeLabel(attribute, true));
        }

        protected Object getValue() {
            IStructuredSelection ss;
            Object firstElement;
            IWorkItem workitem = null;
            ISelection selection = this.fSelectionProvider.getSelection();
            if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IWorkItem) {
                workitem = (IWorkItem)firstElement;
            }
            if (workitem != null) {
                try {
                    Object value = ItemSelectionDialog.getIteration(this.getShell(), workitem.getProjectArea(), workitem, null);
                    if (value == null) {
                        value = AbstractChangeWorkItemAttributeAction.NULLVALUE;
                    }
                    return value;
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
            return null;
        }
    }
}

