/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.workflow.ICombinedWorkflowInfos;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class AttributeLabelProviderFactory {
    private static HashMap<String, Class> fgProviders = new HashMap();
    private static HashMap<String, ItemProfile> fgLabelProviderProfiles;

    static {
        fgProviders.put(IWorkItem.STATE_PROPERTY, StateLabelProvider.class);
        fgProviders.put(IWorkItem.SUMMARY_PROPERTY, SummaryLabelProvider.class);
        fgProviders.put(IWorkItem.RESOLUTION_PROPERTY, ResolutionLabelProvider.class);
        fgProviders.put("type", TypeLabelProvider.class);
        fgProviders.put(IWorkItem.DURATION_PROPERTY, EstimateLabelProvider.class);
        fgProviders.put(IWorkItem.SUBSCRIPTIONS_PROPERTY, ItemLabelProvider.class);
        fgProviders.put(IWorkItem.APPROVALS_PROPERTY, ItemLabelProvider.class);
        fgProviders.put("contributor", ItemLabelProvider.class);
        fgProviders.put("timestamp", TimestampLabelProvider.class);
        fgProviders.put("mediumHtml", HTMLLabelProvider.class);
        fgProviders.put("html", HTMLLabelProvider.class);
        fgProviders.put("category", CategoryLabelProvider.class);
        fgProviders.put("interval", IterationLabelProvider.class);
        fgProviders.put("approvalState", ApprovalStateLabelProvider.class);
        fgProviders.put("approvalType", ApprovalTypeLabelProvider.class);
        fgProviders.put("tags", TagsLabelProvider.class);
        fgProviders.put("teamArea", ProcessItemLabelProvider.class);
        fgProviders.put("processArea", ProcessItemLabelProvider.class);
        fgProviders.put("projectArea", ProcessItemLabelProvider.class);
        fgProviders.put("workItem", ItemLabelProvider.class);
        fgProviders.put("score", ScoreLabelProvider.class);
        fgProviders.put("stateGroup", StateGroupLabelProvider.class);
        fgLabelProviderProfiles = new HashMap();
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(IContributor.ITEM_TYPE), ItemProfile.CONTRIBUTOR_DEFAULT);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(ICategory.ITEM_TYPE), ICategory.SMALL_PROFILE);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(IIteration.ITEM_TYPE), ItemProfile.ITERATION_DEFAULT);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(IDeliverable.ITEM_TYPE), IDeliverable.SMALL_PROFILE);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(IWorkItem.ITEM_TYPE), IWorkItem.SMALL_PROFILE);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(IProjectArea.ITEM_TYPE), ItemProfile.PROJECT_AREA_DEFAULT);
        fgLabelProviderProfiles.put(AttributeLabelProviderFactory.getItemTypeKey(ITeamArea.ITEM_TYPE), ItemProfile.TEAM_AREA_DEFAULT);
    }

    private static String getItemTypeKey(IItemType type) {
        return String.valueOf(type.getNamespaceURI()) + type.getName();
    }

    public static ItemProfile getItemProfile(IItemType type) {
        ItemProfile profile = fgLabelProviderProfiles.get(AttributeLabelProviderFactory.getItemTypeKey(type));
        if (profile == null) {
            profile = ItemProfile.createFullProfile((IItemType)type);
        }
        return profile;
    }

    public static IAttributeLabelProvider createLabelProvider(IAttribute attribute) {
        return AttributeLabelProviderFactory.createLabelProvider((IQueryableAttribute)new QueryableWorkItemAttribute(attribute));
    }

    public static IAttributeLabelProvider createLabelProvider(IQueryableAttribute attribute) {
        return AttributeLabelProviderFactory.createLabelProvider(attribute, true);
    }

    public static IAttributeLabelProvider createLabelProvider(IQueryableAttribute attribute, boolean workItemRelative) {
        IAttributeLabelProvider labelProvider;
        Class providerClass = fgProviders.get(attribute.getIdentifier());
        if (providerClass == null) {
            providerClass = !AttributeTypes.isEnumerationAttributeType((String)attribute.getAttributeType()) ? fgProviders.get(attribute.getAttributeType()) : EnumerationLabelProvider.class;
        }
        if (providerClass == null) {
            labelProvider = new AttributeLabelProvider();
        } else {
            try {
                labelProvider = (IAttributeLabelProvider)providerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        labelProvider.init(attribute, workItemRelative);
        return labelProvider;
    }

    static class ApprovalStateLabelProvider
    extends AttributeLabelProvider {
        ApprovalStateLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            IApprovalState state = WorkItemApprovals.getState((String)value.toString());
            if (state != null) {
                label.setText(state.getDisplayName());
                label.setImage(this.getImage(state.getIconURL()));
                return;
            }
            super.doUpdateLabel(label, element);
        }
    }

    static class ApprovalTypeLabelProvider
    extends AttributeLabelProvider {
        ApprovalTypeLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            IApprovalType type = WorkItemApprovals.getType((String)value.toString());
            if (type != null) {
                label.setText(type.getDisplayName());
                label.setImage(this.getImage(type.getIconURL()));
                return;
            }
            super.doUpdateLabel(label, element);
        }
    }

    static class CategoryLabelProvider
    extends AttributeLabelProvider {
        CategoryLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            if (value instanceof ICategory) {
                ICategory category = (ICategory)value;
                label.setText(category.getHierarchicalName());
                return;
            }
            super.doUpdateLabel(label, element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnumerationLabelProvider
    extends AttributeLabelProvider {
        private long fLastAccessed;
        private IProjectAreaHandle fLastProjectArea;
        private IEnumeration<?> fCachedEnumeration;

        EnumerationLabelProvider() {
        }

        @Override
        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            IProjectAreaHandle projectAreaHandle = this.getProjectArea(element);
            if (value instanceof ILiteral) {
                ILiteral literal = (ILiteral)value;
                label.setText(literal.getName());
                label.setImage(this.getImage(literal.getIconURL()));
                return;
            }
            if (value instanceof Identifier && projectAreaHandle != null) {
                ILiteral literal = null;
                Identifier identifier = (Identifier)value;
                IEnumeration<?> enumeration = this.getEnumeration(projectAreaHandle);
                if (enumeration != null) {
                    literal = enumeration.findEnumerationLiteral(identifier);
                }
                if (literal != null) {
                    label.setText(literal.getName());
                    label.setImage(this.getImage(literal.getIconURL()));
                } else {
                    label.setText(identifier.getStringIdentifier());
                }
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private IEnumeration<?> getEnumeration(IProjectAreaHandle projectArea) {
            if (System.currentTimeMillis() - this.fLastAccessed > 1000L || this.fLastProjectArea == null || !this.fLastProjectArea.sameItemId((IItemHandle)projectArea)) {
                this.fCachedEnumeration = this.resolveEnumeration(projectArea);
                this.fLastProjectArea = projectArea;
            }
            this.fLastAccessed = System.currentTimeMillis();
            return this.fCachedEnumeration;
        }

        private IEnumeration<?> resolveEnumeration(IProjectAreaHandle projectAreaHandle) {
            IAttribute attribute = this.getAttribute();
            if (attribute != null) {
                IWorkItemClient client = this.getWorkItemClient((IItemHandle)projectAreaHandle);
                return client.findCachedEnumeration(attribute);
            }
            return null;
        }
    }

    static class EstimateLabelProvider
    extends AttributeLabelProvider {
        private DurationFormat fDurationFormat = null;

        EstimateLabelProvider() {
        }

        protected synchronized void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            if (value instanceof Number) {
                if (this.fDurationFormat == null) {
                    this.fDurationFormat = DurationFormat.getInstance();
                    this.fDurationFormat.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
                    this.fDurationFormat.setUnspecifiedString("");
                }
                label.setText(this.fDurationFormat.format(new Duration(((Number)value).longValue())));
                return;
            }
            super.doUpdateLabel(label, element);
        }
    }

    static class HTMLLabelProvider
    extends AttributeLabelProvider {
        HTMLLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            label.setText(value == null ? "" : XMLString.createFromXMLText((String)value.toString()).getPlainText());
        }
    }

    static class ItemLabelProvider
    extends AttributeLabelProvider
    implements ILabelProviderListener {
        private StandardLabelProvider fStdLp = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        public ItemLabelProvider() {
            this.fStdLp.addListener((ILabelProviderListener)this);
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            if (value != null) {
                this.fStdLp.updateLabel(label, value);
                return;
            }
            super.doUpdateLabel(label, element);
        }

        public void dispose() {
            this.fStdLp.dispose();
            super.dispose();
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            this.fireLabelProviderChanged(event);
        }
    }

    static class IterationLabelProvider
    extends AttributeLabelProvider {
        IterationLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            String text = this.getLabel(value);
            if (text != null) {
                label.setText(text);
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private String getLabel(Object value) {
            if (value == null) {
                return IWorkItem.UNASSIGNED_TARGET_NAME;
            }
            if (value instanceof IIteration) {
                return IterationLabelProvider.getIterationName((IIteration)value);
            }
            return null;
        }

        public static String getIterationName(IIteration iteration) {
            return iteration.getName() != null && !"".equals(iteration.getName()) ? iteration.getName() : iteration.getId();
        }
    }

    static class ProcessItemLabelProvider
    extends ItemLabelProvider {
        ProcessItemLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value;
            super.doUpdateLabel(label, element);
            if (this.getAttribute() == null || !"processArea".equals(this.getAttribute().getAttributeType())) {
                label.setImage(null);
            }
            if ((value = this.getAttributeValue(element)) instanceof IProjectArea) {
                label.setText(((IProjectArea)value).getName());
            }
        }
    }

    static class ResolutionLabelProvider
    extends AttributeLabelProvider {
        ResolutionLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                IWorkflowInfo workflow = resolved.getWorkflowInfo();
                this.updateResolutionLabel(label, resolved.getWorkItem(), workflow);
                return;
            }
            if (element instanceof IWorkItem) {
                IWorkItem workItem = (IWorkItem)element;
                this.updateResolutionLabel(label, workItem, null);
                return;
            }
            IProjectAreaHandle projectAreaHandle = this.getProjectArea(element);
            Identifier<IResolution> resolution = this.getResolution(element);
            if (resolution != null && projectAreaHandle != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)projectAreaHandle);
                ICombinedWorkflowInfos combinedWorkflowInfos = workItemClient.findCachedCombinedWorkflowInfos(projectAreaHandle);
                String name = combinedWorkflowInfos.getResolutionName(resolution);
                label.setText(name != null ? name : resolution.getStringIdentifier());
                label.setImage(this.getImage(combinedWorkflowInfos.getResolutionIconName(resolution)));
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private void updateResolutionLabel(ViewerLabel label, IWorkItem workItem, IWorkflowInfo workflow) {
            Identifier resolution = workItem.getResolution2();
            if (resolution != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)workItem.getProjectArea());
                if (workflow == null) {
                    workflow = workItemClient.findCachedWorkflowInfo(workItem);
                }
                if (workflow != null) {
                    String name = workflow.getResolutionName(resolution);
                    label.setText(name != null ? name : resolution.getStringIdentifier());
                    label.setImage(this.getImage(workflow.getResolutionIconName(resolution)));
                } else {
                    label.setText(resolution.getStringIdentifier());
                }
            }
        }
    }

    static class ScoreLabelProvider
    extends AttributeLabelProvider {
        NumberFormat fPercentFormat = NumberFormat.getPercentInstance();

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof Number) {
                String text = this.fPercentFormat.format(((Number)element).doubleValue());
                label.setText(text);
            }
        }
    }

    static class StateGroupLabelProvider
    extends AttributeLabelProvider {
        StateGroupLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                IWorkflowInfo workflow = resolved.getWorkflowInfo();
                this.updateStateGroupLabel(label, resolved.getWorkItem(), workflow);
                return;
            }
            if (element instanceof IWorkItem) {
                IWorkItem workItem = (IWorkItem)element;
                this.updateStateGroupLabel(label, workItem, null);
                return;
            }
            IProjectAreaHandle projectAreaHandle = this.getProjectArea(element);
            Identifier<IState> state = this.getState(element);
            if (state != null && projectAreaHandle != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)projectAreaHandle);
                ICombinedWorkflowInfos combinedWorkflowInfos = workItemClient.findCachedCombinedWorkflowInfos(projectAreaHandle);
                int stateGroup = combinedWorkflowInfos.getStateGroup(state);
                label.setText(this.getStateGroupLabel(stateGroup));
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private void updateStateGroupLabel(ViewerLabel label, IWorkItem workItem, IWorkflowInfo workflow) {
            Identifier state = workItem.getState2();
            if (state != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)workItem.getProjectArea());
                if (workflow == null) {
                    workflow = workItemClient.findCachedWorkflowInfo(workItem);
                }
                if (workflow != null) {
                    int stateGroup = workflow.getStateGroup(state);
                    label.setText(this.getStateGroupLabel(stateGroup));
                }
            }
        }

        private String getStateGroupLabel(int stateGroup) {
            switch (stateGroup) {
                case 1: {
                    return Messages.AttributeLabelProviderFactory_STATE_GROUP_OPEN;
                }
                case 4: {
                    return Messages.AttributeLabelProviderFactory_STATE_GROUP_PROGRESS;
                }
                case 2: {
                    return Messages.AttributeLabelProviderFactory_STATE_GROUP_CLOSED;
                }
            }
            return Messages.AttributeLabelProviderFactory_STATE_GROUP_UNKNOWN;
        }
    }

    static class StateLabelProvider
    extends AttributeLabelProvider {
        StateLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                IWorkflowInfo workflow = resolved.getWorkflowInfo();
                this.updateStateLabel(label, resolved.getWorkItem(), workflow);
                return;
            }
            if (element instanceof IWorkItem) {
                IWorkItem workItem = (IWorkItem)element;
                this.updateStateLabel(label, workItem, null);
                return;
            }
            IProjectAreaHandle projectAreaHandle = this.getProjectArea(element);
            Identifier<IState> state = this.getState(element);
            if (state != null && projectAreaHandle != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)projectAreaHandle);
                ICombinedWorkflowInfos combinedWorkflowInfos = workItemClient.findCachedCombinedWorkflowInfos(projectAreaHandle);
                URL url = combinedWorkflowInfos.getStateIconName(state);
                String name = combinedWorkflowInfos.getStateName(state);
                label.setText(name != null ? name : state.getStringIdentifier());
                label.setImage(this.getImage(url));
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private void updateStateLabel(ViewerLabel label, IWorkItem workItem, IWorkflowInfo workflow) {
            Identifier state = workItem.getState2();
            if (state != null) {
                IWorkItemClient workItemClient = this.getWorkItemClient((IItemHandle)workItem.getProjectArea());
                if (workflow == null) {
                    workflow = workItemClient.findCachedWorkflowInfo(workItem);
                }
                if (workflow != null) {
                    String name = workflow.getStateName(state);
                    label.setText(name != null ? name : state.getStringIdentifier());
                    label.setImage(this.getImage(workflow.getStateIconName(state)));
                } else {
                    label.setText(state.getStringIdentifier());
                }
            }
        }
    }

    static class SummaryLabelProvider
    extends AttributeLabelProvider {
        private Font fBold;
        private Color fCurrentColor;
        private Color fOwnerColor;
        private boolean fUseReducedColors;

        public SummaryLabelProvider() {
            FontDescriptor boldFontDescriptor = Utils.createRelativeHeightFontDescriptor(0, 1);
            this.fBold = JazzResources.getFont((ResourceManager)this.getResources(), (FontDescriptor)boldFontDescriptor, (Font)JFaceResources.getDefaultFont());
            this.fCurrentColor = JazzResources.getColor((ResourceManager)this.getResources(), (RGB)new RGB(6, 97, 240));
            this.fOwnerColor = JazzResources.getColor((ResourceManager)this.getResources(), (RGB)new RGB(0, 0, 128));
            this.fUseReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof ResolvedWorkItem) {
                this.updateSummaryLabel(label, ((ResolvedWorkItem)element).getWorkItem());
                return;
            }
            if (element instanceof IWorkItem) {
                this.updateSummaryLabel(label, (IWorkItem)element);
                return;
            }
            label.setText(XMLString.createFromXMLText((String)element.toString()).getPlainText());
        }

        private void updateSummaryLabel(ViewerLabel label, IWorkItem workItem) {
            label.setText(workItem.getHTMLSummary().getPlainText());
            if (!this.fUseReducedColors) {
                if (this.isCurrentWorkItem((IWorkItemHandle)workItem)) {
                    label.setForeground(this.fCurrentColor);
                } else if (this.isOwnedByCurrentUser(workItem)) {
                    label.setForeground(this.fOwnerColor);
                }
            }
            if (this.isUnread(workItem)) {
                label.setFont(this.fBold);
            }
        }

        private boolean isUnread(IWorkItem workItem) {
            IAdapterManager manager = Platform.getAdapterManager();
            IReadStateTracker tracker = (IReadStateTracker)manager.getAdapter((Object)workItem, IReadStateTracker.class);
            return tracker != null && !tracker.isMarkedRead();
        }

        private boolean isOwnedByCurrentUser(IWorkItem workItem) {
            IContributor loggedInUser = ((ITeamRepository)workItem.getOrigin()).loggedInContributor();
            return workItem.getOwner().sameItemId((IItemHandle)loggedInUser);
        }

        private boolean isCurrentWorkItem(IWorkItemHandle workItem) {
            IWorkItemHandle active = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
            return workItem.sameItemId((IItemHandle)active);
        }
    }

    static class TagsLabelProvider
    extends AttributeLabelProvider {
        TagsLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Object value = this.getAttributeValue(element);
            if (value instanceof Collection) {
                label.setText(SeparatedStringList.toCommaSeparatedValue((Collection)((Collection)value)));
            } else {
                label.setText(value.toString());
            }
        }
    }

    static class TimestampLabelProvider
    extends AttributeLabelProvider {
        private DateFormat fDateFormat = DateFormat.getDateTimeInstance(2, 3);

        TimestampLabelProvider() {
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            Timestamp timestamp = (Timestamp)this.getAttributeValue(element);
            label.setText(timestamp == null ? "" : this.fDateFormat.format(timestamp));
        }
    }

    static class TypeLabelProvider
    extends AttributeLabelProvider
    implements ILabelProviderListener {
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        public TypeLabelProvider() {
            this.fStandardLabelProvider.addListener((ILabelProviderListener)this);
        }

        protected void doUpdateLabel(ViewerLabel label, Object element) {
            if (element instanceof ResolvedWorkItem) {
                this.updateTypeIcon(label, ((ResolvedWorkItem)element).getWorkItem());
                return;
            }
            if (element instanceof IWorkItem) {
                this.updateTypeIcon(label, (IWorkItem)element);
                return;
            }
            if (element instanceof String && this.getProjectArea(element) != null) {
                element = this.getWorkItemClient((IItemHandle)this.getProjectArea(element)).findCachedWorkItemType(this.getProjectArea(element), (String)element);
            }
            if (element instanceof IWorkItemType) {
                this.fillLabel(label, (IWorkItemType)element);
                return;
            }
            super.doUpdateLabel(label, element);
        }

        private void updateTypeIcon(ViewerLabel label, IWorkItem workItem) {
            ViewerLabel localLabel = new ViewerLabel("", null);
            this.fStandardLabelProvider.updateLabel(localLabel, (Object)workItem);
            label.setImage(localLabel.getImage());
        }

        private void fillLabel(ViewerLabel label, IWorkItemType workItemType) {
            label.setText(workItemType.getDisplayName());
            label.setImage(this.getImage(WorkItemUI.getImageDescriptor(workItemType)));
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            this.fireLabelProviderChanged(event);
        }

        public void dispose() {
            this.fStandardLabelProvider.dispose();
            super.dispose();
        }
    }
}

