/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.expression.AttributeExpression;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AuditableResolver;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLabelProvider
extends TypeLabelProvider
implements IAttributeLabelProvider {
    private IQueryableAttribute fAttribute;
    private Map<UUID, IQueryableAttribute> fEquivalentAttributeMap = new HashMap<UUID, IQueryableAttribute>();
    private boolean fWorkItemRelative;

    @Override
    public void init(IQueryableAttribute attribute, boolean workItemRelative) {
        this.fAttribute = attribute;
        this.fWorkItemRelative = workItemRelative;
    }

    public ImageDescriptor getImageDescriptor(Object value) {
        return null;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof ResolvedWorkItem && !((ResolvedWorkItem)element).contains(this.fAttribute.getIdentifier())) {
            label.setForeground(Display.getCurrent().getSystemColor(16));
            label.setText(Messages.AttributeLabelProvider_NOT_AVAILABLE);
            return;
        }
        this.doUpdateLabel(label, element);
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        Object value = this.getAttributeValue(element);
        label.setText(value == null ? Messages.AttributeLabelProvider_UNASSIGNED_LITERAL : AttributeExpression.toString((Object)value));
    }

    protected Object getAttributeValue(Object element) {
        if (this.fWorkItemRelative) {
            if (element instanceof ResolvedWorkItem) {
                ResolvedWorkItem resolved = (ResolvedWorkItem)element;
                if (!resolved.contains(this.fAttribute.getIdentifier())) {
                    return null;
                }
                return resolved.getValue(this.fAttribute.getIdentifier());
            }
            if (element instanceof IWorkItem) {
                IQueryableAttribute attribute = this.getEquivalentAttribute(this.getProjectArea(element));
                if (attribute == null) {
                    return null;
                }
                element = attribute.getValue(element);
            }
        }
        if (element instanceof IAuditableHandle) {
            IAuditableHandle handle = (IAuditableHandle)element;
            return this.resolve(handle);
        }
        return element;
    }

    protected Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        ImageDescriptor descriptor = WorkItemUI.getImageDescriptor(url);
        return descriptor != null ? this.getImage(descriptor) : null;
    }

    protected IWorkItemClient getWorkItemClient(IItemHandle handle) {
        return (IWorkItemClient)((ITeamRepository)handle.getOrigin()).getClientLibrary(IWorkItemClient.class);
    }

    protected IProjectAreaHandle getProjectArea(Object element) {
        if (element instanceof IWorkItem) {
            return ((IWorkItem)element).getProjectArea();
        }
        IAttribute attribute = this.getAttribute();
        return attribute != null ? attribute.getProjectArea() : null;
    }

    protected IAttribute getAttribute() {
        return this.fAttribute instanceof QueryableWorkItemAttribute ? ((QueryableWorkItemAttribute)this.fAttribute).getAttribute() : null;
    }

    private Object resolve(IAuditableHandle handle) {
        AuditableResolver resolver = new AuditableResolver((ITeamRepository)handle.getOrigin());
        return resolver.resolve(handle, AttributeLabelProviderFactory.getItemProfile(handle.getItemType()), null);
    }

    protected Identifier<IResolution> getResolution(Object element) {
        if (element instanceof Identifier) {
            return (Identifier)element;
        }
        if (element instanceof String) {
            return Identifier.create(IResolution.class, (String)element.toString());
        }
        if (element instanceof Integer) {
            return Identifier.create(IResolution.class, (String)Integer.toString((Integer)element));
        }
        return null;
    }

    protected Identifier<IState> getState(Object element) {
        if (element instanceof Identifier) {
            return (Identifier)element;
        }
        if (element instanceof String) {
            return Identifier.create(IState.class, (String)element.toString());
        }
        if (element instanceof Integer) {
            return Identifier.create(IState.class, (String)Integer.toString((Integer)element));
        }
        return null;
    }

    private IQueryableAttribute getEquivalentAttribute(IProjectAreaHandle projectArea) {
        if (projectArea.sameItemId((IItemHandle)this.getAttribute().getProjectArea())) {
            return this.fAttribute;
        }
        if (!this.fEquivalentAttributeMap.containsKey(projectArea.getItemId())) {
            try {
                IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
                IAttribute attribute = workItemClient.findAttribute(projectArea, this.fAttribute.getIdentifier(), null);
                QueryableWorkItemAttribute equivalent = attribute != null ? new QueryableWorkItemAttribute(attribute) : null;
                this.fEquivalentAttributeMap.put(projectArea.getItemId(), (IQueryableAttribute)equivalent);
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.AttributeComparatorFactory_ERROR_RESOLVING_ATTRIBUTE, e);
                return this.fAttribute;
            }
        }
        return this.fEquivalentAttributeMap.get(projectArea.getItemId());
    }
}

