/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.expression.IQueryableAttributeFactory;
import com.ibm.team.workitem.common.expression.QueryableAttributes;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.query.SyntheticAttributeIdentifiers;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeColumn;
import com.ibm.team.workitem.rcp.ui.internal.attribute.Messages;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttributeColumnFactory {
    private HashMap<String, AttributeColumn> fColumns = new HashMap();
    private IProjectAreaHandle fProjectAreaFilter;
    private ITeamRepository fRepository;

    private AttributeColumnFactory(ITeamRepository repository, IProjectAreaHandle projectAreaFilter) {
        this.fRepository = repository;
        this.fProjectAreaFilter = projectAreaFilter;
        this.fColumns = new HashMap();
    }

    public static synchronized AttributeColumnFactory getInstance(ITeamRepository repository, IProjectAreaHandle projectAreaFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        AttributeColumnFactory columns = new AttributeColumnFactory(repository, projectAreaFilter);
        columns.resolve(monitor);
        return columns;
    }

    private void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
        IQueryableAttributeFactory factory = QueryableAttributes.getFactory((IItemType)IWorkItem.ITEM_TYPE);
        IAuditableClient auditableClient = (IAuditableClient)this.fRepository.getClientLibrary(IAuditableClient.class);
        List attributes = factory.findAllAttributes(this.fProjectAreaFilter, (IAuditableCommon)auditableClient, monitor);
        for (IQueryableAttribute attribute : attributes) {
            AttributeColumn column = this.createColumn(attribute);
            if (column == null) continue;
            this.fColumns.put(attribute.getIdentifier(), column);
        }
    }

    public AttributeColumn getColumn(String attributeIdentifier) {
        return this.fColumns.get(attributeIdentifier);
    }

    public AttributeColumn[] getColumns() {
        return this.fColumns.values().toArray(new AttributeColumn[this.fColumns.size()]);
    }

    private AttributeColumn createColumn(IQueryableAttribute attribute) {
        if (attribute.isSynthetic() && !SyntheticAttributeIdentifiers.COLUMN_ATTRIBUTES.contains(attribute.getIdentifier())) {
            return null;
        }
        if (attribute instanceof QueryableLinkAttribute) {
            return null;
        }
        AttributeType attributeType = AttributeTypes.getAttributeType((String)attribute.getAttributeType());
        if ("eSignature".equals(attributeType.getIdentifier())) {
            return null;
        }
        if (attribute.getIdentifier().equals(IWorkItem.STATE_PROPERTY)) {
            return new AttributeColumn(attribute, 70);
        }
        if (attribute.getIdentifier().equals(IWorkItem.SUMMARY_PROPERTY)) {
            return new AttributeColumn(attribute, 320);
        }
        if (attribute.getIdentifier().equals(IWorkItem.PRIORITY_PROPERTY)) {
            return new AttributeColumn(attribute, 16, true, 16384, Messages.AttributeColumnFactory_PRIORITY_SHORT);
        }
        if (attribute.getIdentifier().equals(IWorkItem.SEVERITY_PROPERTY)) {
            return new AttributeColumn(attribute, 16, true, 16384, Messages.AttributeColumnFactory_SEVERITY_SHORT);
        }
        if (attribute.getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
            return new AttributeColumn(attribute, 16, true, 16384, Messages.AttributeColumnFactory_TYPE_SHORT);
        }
        if (attribute.getIdentifier().equals("score")) {
            return new AttributeColumn(attribute, 50, false, 131072, null);
        }
        if (attributeType.getIdentifier().equals("contributor")) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("integer")) {
            return new AttributeColumn(attribute, 40);
        }
        if (attributeType.getIdentifier().equals("long")) {
            return new AttributeColumn(attribute, 40);
        }
        if (attributeType.getIdentifier().equals("duration")) {
            return new AttributeColumn(attribute, 70);
        }
        if (attributeType.getIdentifier().equals("timestamp")) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("boolean")) {
            return new AttributeColumn(attribute, 50);
        }
        if (AttributeTypes.STRING_TYPES.contains(attributeType.getIdentifier())) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("category")) {
            return new AttributeColumn(attribute, 140);
        }
        if (AttributeTypes.HTML_TYPES.contains(attributeType.getIdentifier())) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("interval")) {
            return new AttributeColumn(attribute, 70);
        }
        if (attributeType.getIdentifier().equals("tags")) {
            return new AttributeColumn(attribute, 70);
        }
        if (attributeType.getIdentifier().equals("teamArea")) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("processArea")) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("projectArea")) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getIdentifier().equals("workItem")) {
            return new AttributeColumn(attribute, 210);
        }
        if (attributeType.getIdentifier().equals("deliverable")) {
            return new AttributeColumn(attribute, 70);
        }
        if (AttributeTypes.isEnumerationAttributeType((String)attributeType.getIdentifier())) {
            return new AttributeColumn(attribute, 140);
        }
        if (attributeType.getInstanceType().equals(String.class)) {
            return new AttributeColumn(attribute, 70);
        }
        return null;
    }
}

