/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.attribute;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeComparatorFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.ImageOnlyLabelProvider;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;

public class AttributeColumn {
    private IQueryableAttribute fAttribute;
    private int fWidth;
    private String fHeaderName;
    private ImageDescriptor fHeaderImage;
    private int fAlignment;
    private boolean fImageOnly;
    private String fHeaderToolTip;

    public AttributeColumn(IQueryableAttribute attribute, int width) {
        this(attribute, width, false, 16384, null);
    }

    public AttributeColumn(IQueryableAttribute attribute, ImageDescriptor headerImage) {
        this(attribute, 16, true, 16384, null);
        this.fHeaderImage = headerImage;
    }

    public AttributeColumn(IQueryableAttribute attribute, int width, boolean hideText, int alignment, String headerText) {
        this.fAttribute = attribute;
        this.fImageOnly = hideText;
        this.fAlignment = alignment;
        this.fHeaderName = headerText;
        this.fWidth = width + 7;
    }

    public IQueryableAttribute getAttribute() {
        return this.fAttribute;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public String getHeaderName() {
        if (this.fHeaderName == null && this.fAttribute != null) {
            return this.fAttribute.getDisplayName();
        }
        return this.fHeaderName;
    }

    public ImageDescriptor getHeaderImage() {
        return this.fHeaderImage;
    }

    public String getHeaderToolTip() {
        if (this.fHeaderToolTip == null && this.fAttribute != null) {
            return this.fAttribute.getDisplayName();
        }
        return this.fHeaderToolTip;
    }

    public boolean useHeaderImage() {
        return this.fHeaderImage != null;
    }

    public ILabelProvider createLabelProvider() {
        Object provider = AttributeLabelProviderFactory.createLabelProvider(this.fAttribute);
        if (this.isTextHidden()) {
            provider = new ImageOnlyLabelProvider((ILabelProvider)provider);
        }
        return provider;
    }

    public Comparator createComparator() {
        return AttributeComparatorFactory.createComparator(this.fAttribute);
    }

    public boolean isTextHidden() {
        return this.fImageOnly;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public boolean showWorkItemToolTip() {
        return this.fAttribute == null || this.fAttribute.getIdentifier().equals(IWorkItem.TYPE_PROPERTY);
    }

    public boolean showFocusToolTip() {
        String id;
        String string = id = this.fAttribute != null ? this.fAttribute.getIdentifier() : null;
        return id != null && (id.equals(IWorkItem.TYPE_PROPERTY) || id.equals(IWorkItem.OWNER_PROPERTY) || id.equals(IWorkItem.CREATOR_PROPERTY));
    }

    public void setHeaderToolTip(String toolTip) {
        this.fHeaderToolTip = toolTip;
    }

    public static class Constraint {
        private int fIndex;
        private String fIdentifier;

        public Constraint(int index, String attributeIdentifier) {
            this.fIndex = index;
            this.fIdentifier = attributeIdentifier;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }
    }
}

