/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.activation;

import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.NoScrollbarsTable;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.IWorkItemActivationManager;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.activation.ActiveWorkItemControl;
import com.ibm.team.workitem.rcp.ui.internal.activation.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewSite;

public final class ActiveWorkItemSection
extends Section
implements ISectionListener {
    private static final IWorkItem[] NO_WORK_ITEMS = new IWorkItem[0];
    private boolean fCarbon = "carbon".equals(SWT.getPlatform());
    private boolean fExpanded = false;
    private IBaseLabelProvider fLabelProvider = null;
    private final WorkItemActivationParticipant fParticipant = new ActiveWorkItemListener();
    private final TeamRepositoryLoginListener fRepositoryListener = new TeamRepositoryLoginListener();
    private SectionLabel fSectionLabel = null;
    private NoScrollbarsTable fTable;
    private TableViewer fViewer = null;
    private IWorkItem fWorkItem = null;
    private ResourceManager fSectionLabelResourceManager;

    static final IWorkItem resolveWorkItem(IWorkItemHandle handle, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        Assert.isNotNull((Object)monitor);
        Object origin = handle.getOrigin();
        if (origin instanceof ITeamRepository) {
            ITeamRepository repository = (ITeamRepository)origin;
            try {
                return (IWorkItem)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, IWorkItem.MEDIUM_PROFILE.getProperties(), monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException exception) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.ActiveWorkItemSection_ERROR_RESOLVING_WORK_ITEM, exception);
            }
        }
        return null;
    }

    static final IWorkItem[] resolveWorkItems(IWorkItemHandle[] handles, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handles);
        Assert.isNotNull((Object)monitor);
        if (handles.length == 0) {
            return new IWorkItem[0];
        }
        try {
            IWorkItem item;
            HashMap<ITeamRepository, ArrayList<IWorkItemHandle>> map = new HashMap<ITeamRepository, ArrayList<IWorkItemHandle>>(handles.length);
            IWorkItemHandle[] iWorkItemHandleArray = handles;
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkItemHandle handle = iWorkItemHandleArray[n2];
                Object origin = handle.getOrigin();
                if (origin instanceof ITeamRepository) {
                    ITeamRepository repository = (ITeamRepository)origin;
                    ArrayList<IWorkItemHandle> collection = (ArrayList<IWorkItemHandle>)map.get(repository);
                    if (collection == null) {
                        collection = new ArrayList<IWorkItemHandle>(4);
                        map.put(repository, collection);
                    }
                    collection.add(handle);
                }
                ++n2;
            }
            monitor.beginTask(Messages.ActiveWorkItemSection_RESOLVING_WORK_ITEMS, map.size() * 100);
            HashMap<UUID, IWorkItem> mapping = new HashMap<UUID, IWorkItem>(handles.length);
            for (Map.Entry entry : map.entrySet()) {
                List unresolved = (List)entry.getValue();
                try {
                    List resolved = ((ITeamRepository)entry.getKey()).itemManager().fetchPartialItems(unresolved, 0, IWorkItem.MEDIUM_PROFILE.getProperties(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    int index = 0;
                    while (index < unresolved.size()) {
                        item = (IWorkItem)resolved.get(index);
                        if (item != null) {
                            mapping.put(((IWorkItemHandle)unresolved.get(index)).getItemId(), item);
                        }
                        ++index;
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {
                }
                catch (NotLoggedInException notLoggedInException) {
                }
                catch (TeamRepositoryException exception) {
                    WorkItemRCPUIPlugin.getDefault().log(Messages.ActiveWorkItemSection_ERROR_RESOLVING_WORK_ITEM, exception);
                }
            }
            ArrayList<IWorkItem> result = new ArrayList<IWorkItem>(handles.length);
            IWorkItemHandle[] iWorkItemHandleArray2 = handles;
            int n3 = handles.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkItemHandle handle = iWorkItemHandleArray2[n4];
                item = (IWorkItem)mapping.get(handle.getItemId());
                if (item != null) {
                    result.add(item);
                }
                ++n4;
            }
            IWorkItem[] iWorkItemArray = result.toArray(new IWorkItem[result.size()]);
            return iWorkItemArray;
        }
        finally {
            monitor.done();
        }
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        IWorkItemActivationManager manager = ClientModel.getWorkItemActivationManager();
        manager.addActivationParticipant(this.fParticipant);
        if (this.fCarbon) {
            this.fViewer = new TableViewer(new Table(parent, 98306));
        } else {
            this.fTable = new NoScrollbarsTable(parent, 98306);
            this.fTable.getTable().setBackground(parent.getBackground());
            this.fViewer = new TableViewer(this.fTable.getTable());
        }
        new ViewerDragSupport((Viewer)this.fViewer, 4);
        this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Control control = ActiveWorkItemSection.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    ActiveWorkItemSection.this.fViewer.refresh(true);
                }
            }
        });
        this.fViewer.setLabelProvider(this.fLabelProvider);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        new TooltipSupport((Control)this.fViewer.getTable(), true, true){

            protected void openRequested(Object element) {
                if (element instanceof IWorkItem) {
                    WorkItemUI.open(ActiveWorkItemSection.this.getSectionSite().getViewSite().getPage(), element);
                }
            }
        };
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fViewer);
        this.createContextMenu();
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection extended;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (element = (extended = (IStructuredSelection)selection).getFirstElement()) instanceof IWorkItemHandle) {
                    WorkItemUI.open(ActiveWorkItemSection.this.getSectionSite().getViewSite().getPage(), element);
                }
            }
        });
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fRepositoryListener);
        ITeamRepository[] repositories = service.getTeamRepositories();
        boolean loggedIn = false;
        ITeamRepository[] iTeamRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.fRepositoryListener.addedRepository(repository);
            if (repository.loggedIn()) {
                loggedIn = true;
                final IWorkItemHandle[] handles = manager.getActivationHistory();
                UIUpdaterJob job = new UIUpdaterJob(Messages.ActiveWorkItemSection_INITIALIZING_RECENT_WORK){
                    private IWorkItem[] fHistory;
                    {
                        super($anonymous0);
                        this.fHistory = new IWorkItem[0];
                    }

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        this.fHistory = ActiveWorkItemSection.resolveWorkItems(handles, monitor);
                        return Status.OK_STATUS;
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        Control control = ActiveWorkItemSection.this.fViewer.getControl();
                        if (control != null && !control.isDisposed()) {
                            ActiveWorkItemSection.this.fViewer.setInput((Object)this.fHistory);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                final IWorkItemHandle handle = manager.getActiveWorkItem();
                if (handle != null) {
                    job = new UIUpdaterJob(Messages.ActiveWorkItemSection_INITIALIZING_CURRENT_WORK){
                        private IWorkItem fWorkItem;
                        {
                            super($anonymous0);
                            this.fWorkItem = null;
                        }

                        public IStatus runInBackground(IProgressMonitor monitor) {
                            this.fWorkItem = ActiveWorkItemSection.resolveWorkItem(handle, monitor);
                            return Status.OK_STATUS;
                        }

                        public IStatus runInUI(IProgressMonitor monitor) {
                            Control control = ActiveWorkItemSection.this.fViewer.getControl();
                            if (control != null && !control.isDisposed()) {
                                ActiveWorkItemSection.this.updateTeaser(this.fWorkItem, true);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else {
                    this.updateTeaser(null, false);
                }
            }
            ++n2;
        }
        if (!loggedIn) {
            this.updateTeaser(null, false);
        }
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.rcp.ui.active_work_item_section");
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                Assert.isNotNull((Object)menu);
                menu.add((IContributionItem)new Separator("additions"));
            }
        });
        Control control = this.fViewer.getControl();
        control.setMenu(manager.createContextMenu(control));
        this.getSectionSite().getViewSite().registerContextMenu(manager, (ISelectionProvider)this.fViewer);
    }

    public void createTeaser(Composite parent) {
        Assert.isNotNull((Object)parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        layout.marginTop = 1;
        parent.setLayout((Layout)layout);
        this.fSectionLabel = new SectionLabel(parent, 131072);
        this.fSectionLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.fSectionLabel.setBackground(parent.getBackground());
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Assert.isNotNull((Object)manager);
                IViewSite site = ActiveWorkItemSection.this.getSectionSite().getViewSite();
                ActiveWorkItemControl.fillActiveWorkItemMenu(site.getShell(), site.getPage(), manager, (IWorkItemHandle)ActiveWorkItemSection.this.fWorkItem);
            }
        });
        this.fSectionLabel.setMenu(menu.createContextMenu((Control)this.fSectionLabel));
        new WorkItemTooltipSupport((Control)this.fSectionLabel);
        this.fSectionLabelResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fSectionLabel);
        this.fSectionLabel.setForeground(JazzResources.getColor((ResourceManager)this.fSectionLabelResourceManager, (RGB)new RGB(80, 80, 80)));
        Font font = JFaceResources.getDefaultFont();
        FontData[] data = font.getFontData();
        int index = 0;
        while (index < data.length) {
            data[index].setHeight(data[index].getHeight() - 1);
            ++index;
        }
        this.fSectionLabel.setFont(JazzResources.getFont((ResourceManager)this.fSectionLabelResourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])data), (Font)font));
        Menu sectionMenu = this.getSectionSite().getSectionMenu();
        MenuItem resetMenu = new MenuItem(sectionMenu, 0);
        resetMenu.setText(Messages.ActiveWorkItemSection_CLEAR_HISTORY);
        resetMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                ClientModel.getWorkItemActivationManager().resetActivationHistory();
                ActiveWorkItemSection.this.fViewer.setInput((Object)new Object[0]);
            }
        });
        HelpContextIds.hookHelpListener((Control)parent.getParent(), "com.ibm.team.workitem.rcp.ui.active_work_item_section");
    }

    public void dispose() {
        ITeamRepository[] repositories;
        super.dispose();
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.fRepositoryListener.removedRepository(repository);
            ++n2;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.fTable != null) {
            this.fTable.dispose();
        }
        ClientModel.getWorkItemActivationManager().removeActivationParticipant(this.fParticipant);
    }

    private ITeamRepository getTeamRepository() {
        if (this.fWorkItem != null && this.fWorkItem.getOrigin() instanceof ITeamRepository) {
            return (ITeamRepository)this.fWorkItem.getOrigin();
        }
        return null;
    }

    public void sectionCollapsed() {
        this.fExpanded = false;
    }

    public void sectionExpanded() {
        this.fExpanded = true;
    }

    public void sectionMaximized(boolean isContentClipped) {
        if (!this.fCarbon && isContentClipped && this.fTable != null && !this.fTable.isDisposed()) {
            this.fTable.showVerticalScrollBarsOnce();
        }
    }

    public void sectionOpened() {
    }

    public void sectionResized() {
    }

    public void setFocus() {
        if (this.fExpanded) {
            if (this.fCarbon && ((Table)this.fViewer.getControl()).getSelectionCount() > 0) {
                this.fViewer.getControl().setFocus();
            } else if (this.fTable.getTable().getSelectionCount() > 0) {
                this.fTable.getTable().setFocus();
            }
        }
    }

    private void updateTeaser(IWorkItem item, boolean enforce) {
        this.fWorkItem = item;
        this.fSectionLabel.setForeground(JazzResources.getColor((ResourceManager)this.fSectionLabelResourceManager, (RGB)new RGB(80, 80, 80)));
        if (item == null) {
            if (enforce) {
                this.fSectionLabel.setText(Messages.ActiveWorkItemSection_TEXT_ERROR_RESOLVING_WORK_ITEM);
                this.fSectionLabel.setForeground(this.fSectionLabel.getDisplay().getSystemColor(3));
            } else {
                this.fSectionLabel.setText(Messages.ActiveWorkItemSection_NO_CURRENT_WORK);
            }
        } else {
            this.fSectionLabel.setText(MessageFormat.format(Messages.ActiveWorkItemSection_CURRENT_WORK, WorkItemTextUtilities.getWorkItemText((IWorkItem)item, (int)32)));
        }
        this.getSectionSite().layoutTeaser();
    }

    private final class ActiveWorkItemListener
    extends WorkItemActivationParticipant {
        private ActiveWorkItemListener() {
        }

        public IStatus handleActivationEvent(WorkItemActivationEvent event, IProgressMonitor monitor) {
            int type;
            Assert.isNotNull((Object)event);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if ((type = event.getType()) == 0) {
                try {
                    monitor.beginTask(Messages.ActiveWorkItemSection_RESOLVING_WORK_ITEMS, 100);
                    IWorkItem[] history = ActiveWorkItemSection.resolveWorkItems(ClientModel.getWorkItemActivationManager().getActivationHistory(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    final IWorkItem item = ActiveWorkItemSection.resolveWorkItem(event.getWorkItem(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    Display.getDefault().asyncExec(new Runnable((IWorkItemHandle[])history){
                        private final /* synthetic */ IWorkItemHandle[] val$history;
                        {
                            this.val$history = iWorkItemHandleArray;
                        }

                        public void run() {
                            ActiveWorkItemSection.this.updateTeaser(item, true);
                            ActiveWorkItemSection.this.fViewer.setInput((Object)this.val$history);
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
            if (type == 1) {
                try {
                    monitor.beginTask(Messages.ActiveWorkItemSection_RESOLVING_WORK_ITEMS, 50);
                    IWorkItem[] history = ActiveWorkItemSection.resolveWorkItems(ClientModel.getWorkItemActivationManager().getActivationHistory(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    Display.getDefault().asyncExec(new Runnable((IWorkItemHandle[])history){
                        private final /* synthetic */ IWorkItemHandle[] val$history;
                        {
                            this.val$history = iWorkItemHandleArray;
                        }

                        public void run() {
                            ActiveWorkItemSection.this.updateTeaser(null, false);
                            ActiveWorkItemSection.this.fViewer.setInput((Object)this.val$history);
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }
    }

    private final class TeamRepositoryLoginListener
    implements ITeamRepositoryService.IRepositoryServiceListener,
    IListener {
        TeamRepositoryLoginListener() {
        }

        public void addedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.addGenericListener((Object)"state", (IListener)this);
        }

        public void handleEvents(List events) {
            Assert.isNotNull((Object)events);
            block4: for (Object event : events) {
                IEventSource source;
                PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                ITeamRepository repository = (ITeamRepository)source;
                IWorkItemActivationManager manager = ClientModel.getWorkItemActivationManager();
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        final IWorkItemHandle[] history = manager.getActivationHistory();
                        UIUpdaterJob job = new UIUpdaterJob(Messages.ActiveWorkItemSection_INITIALIZING_RECENT_WORK){
                            private IWorkItem[] fHistory;
                            {
                                super($anonymous0);
                                this.fHistory = new IWorkItem[0];
                            }

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                this.fHistory = ActiveWorkItemSection.resolveWorkItems(history, monitor);
                                return Status.OK_STATUS;
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                Control control = ActiveWorkItemSection.this.fViewer.getControl();
                                if (control != null && !control.isDisposed()) {
                                    ActiveWorkItemSection.this.fViewer.setInput((Object)this.fHistory);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                        final IWorkItemHandle handle = manager.getActiveWorkItem();
                        if (handle != null) {
                            job = new UIUpdaterJob(Messages.ActiveWorkItemSection_INITIALIZING_CURRENT_WORK){
                                private IWorkItem fWorkItem;
                                {
                                    super($anonymous0);
                                    this.fWorkItem = null;
                                }

                                public IStatus runInBackground(IProgressMonitor monitor) {
                                    this.fWorkItem = ActiveWorkItemSection.resolveWorkItem(handle, monitor);
                                    return Status.OK_STATUS;
                                }

                                public IStatus runInUI(IProgressMonitor monitor) {
                                    Control control = ActiveWorkItemSection.this.fViewer.getControl();
                                    if (control != null && !control.isDisposed()) {
                                        ActiveWorkItemSection.this.updateTeaser(this.fWorkItem, true);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                            break;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                Control control = ActiveWorkItemSection.this.fViewer.getControl();
                                if (control != null && !control.isDisposed()) {
                                    ActiveWorkItemSection.this.updateTeaser(null, false);
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        ITeamRepository other = ActiveWorkItemSection.this.getTeamRepository();
                        if (other == null || !other.getRepositoryURI().equals(repository.getRepositoryURI())) continue block4;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                Control control = ActiveWorkItemSection.this.fViewer.getControl();
                                if (control != null && !control.isDisposed()) {
                                    ActiveWorkItemSection.this.updateTeaser(null, false);
                                    ActiveWorkItemSection.this.fViewer.setInput((Object)NO_WORK_ITEMS);
                                }
                            }
                        });
                    }
                }
            }
        }

        public void removedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.removeGenericListener((Object)"state", (IListener)this);
        }
    }

    private final class WorkItemTooltipSupport
    extends TooltipSupport {
        public WorkItemTooltipSupport(Control control) {
            super(control, true, true, false);
        }

        protected Object mapElement(int x, int y) {
            return ClientModel.getWorkItemActivationManager().getActiveWorkItem();
        }

        protected void openRequested(Object element) {
            IWorkItemHandle handle = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
            if (handle != null) {
                WorkItemUI.openEditor(ActiveWorkItemSection.this.getSectionSite().getViewSite().getPage(), handle);
            }
        }
    }
}

