/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.activation;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.IWorkItemActivationManager;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.activation.Messages;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;

public final class ActiveWorkItemControl
extends Composite {
    private static final String INACTIVE_LABEL = Messages.ActiveWorkItemControl_NO_CURRENT_WORK;
    private static final String INACTIVE_TOOLTIP = Messages.ActiveWorkItemControl_DRAG_AND_DROP;
    private static final String LOGGED_OUT_LABEL = Messages.ActiveWorkItemControl_NOT_LOGGED_IN;
    private static final String LOGGED_OUT_TOOLTIP = Messages.ActiveWorkItemControl_LOG_INTO_REPOSITORY;
    private CLabel fImageLabel = null;
    private final StandardLabelProvider fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    private final WorkItemActivationParticipant fParticipant = new ActiveWorkItemListener();
    private final TeamRepositoryLoginListener fRepositoryListener = new TeamRepositoryLoginListener();
    private CLabel fTextLabel = null;
    private IWorkItem fWorkItem = null;

    static void fillActiveWorkItemMenu(Shell shell, IWorkbenchPage page, IMenuManager manager, IWorkItemHandle handle) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)manager);
        if (handle != null) {
            manager.add((IAction)new OpenWorkItemAction(page, handle));
            manager.add((IContributionItem)new Separator("open"));
            ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, (ISelectionProvider)new WorkItemSelectionProvider(handle));
        }
        IWorkItemActivationManager activationManager = ClientModel.getWorkItemActivationManager();
        ArrayList<IWorkItemHandle> history = new ArrayList<IWorkItemHandle>(Arrays.asList(activationManager.getActivationHistory()));
        IWorkItemHandle item = activationManager.getActiveWorkItem();
        if (item != null) {
            IWorkItemHandle remove = null;
            for (IWorkItemHandle entry : history) {
                if (!entry.sameItemId((IItemHandle)item)) continue;
                remove = entry;
                break;
            }
            if (remove != null) {
                history.remove(remove);
            }
        }
        MenuManager recentContribution = null;
        IContributionItem activateContribution = manager.find("com.ibm.team.workitem.rcp.ui.activate");
        if (!history.isEmpty()) {
            recentContribution = new MenuManager(Messages.ActiveWorkItemControl_RECENT_WORK, "com.ibm.team.workitem.rcp.ui.recent");
            if (activateContribution != null) {
                manager.insertAfter(activateContribution.getId(), (IContributionItem)recentContribution);
            } else {
                manager.add((IContributionItem)recentContribution);
            }
            for (IWorkItemHandle entry : history) {
                recentContribution.add((IAction)new ActivateWorkItemAction(entry));
            }
        }
        SelectWorkItemAction selectAction = new SelectWorkItemAction(shell, handle);
        if (activateContribution != null) {
            manager.insertAfter(activateContribution.getId(), (IAction)selectAction);
        } else if (recentContribution != null) {
            manager.insertBefore(recentContribution.getId(), (IAction)selectAction);
        } else {
            manager.add((IAction)selectAction);
        }
        manager.remove(activateContribution);
    }

    private static IWorkbenchPage getWorkbenchPage() {
        IWorkbenchPage page;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page;
        }
        return null;
    }

    static final IWorkItem resolveWorkItem(IWorkItemHandle handle, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        Assert.isNotNull((Object)monitor);
        Object origin = handle.getOrigin();
        if (origin instanceof ITeamRepository) {
            ITeamRepository repository = (ITeamRepository)origin;
            try {
                return (IWorkItem)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, IWorkItem.MEDIUM_PROFILE.getProperties(), monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException exception) {
                WorkItemRCPUIPlugin.getDefault().log("Error while resolving work item:", exception);
            }
        }
        return null;
    }

    public ActiveWorkItemControl(Composite parent) {
        super(parent, 0);
        ITeamRepository[] repositories;
        final IWorkItemActivationManager manager = ClientModel.getWorkItemActivationManager();
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItemHandle handle;
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.fRepositoryListener.addedRepository(repository);
            if (repository.loggedIn() && (handle = manager.getActiveWorkItem()) != null && !handle.sameItemId((IItemHandle)this.fWorkItem)) {
                FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_INITIALIZING_CURRENT_WORK_JOB_NAME){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        ActiveWorkItemControl.this.setActiveWorkItem(handle, monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.setSystem(true);
                job.schedule();
            }
            ++n2;
        }
        manager.addActivationParticipant(this.fParticipant);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = "win32".equals(SWT.getPlatform()) ? 3 : 0;
        this.setLayout((Layout)layout);
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITeamRepository repository = ActiveWorkItemControl.this.getTeamRepository();
                if (repository == null || repository.loggedIn()) {
                    ActiveWorkItemControl.fillActiveWorkItemMenu(ActiveWorkItemControl.this.getShell(), ActiveWorkItemControl.getWorkbenchPage(), manager, (IWorkItemHandle)ActiveWorkItemControl.this.fWorkItem);
                }
                manager.add((IContributionItem)new Separator("close"));
                manager.add((IAction)new Action(Messages.ActiveWorkItemControl_CLOSE){

                    public void run() {
                        IWorkbenchWindow[] windows;
                        IPreferenceStore store = WorkItemRCPUIPlugin.getDefault().getPreferenceStore();
                        store.setDefault("com.ibm.team.workitem.active.trim", true);
                        store.setValue("com.ibm.team.workitem.active.trim", false);
                        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        int n = windows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWindowTrim trim;
                            WorkbenchWindow extended;
                            ITrimManager trimManager;
                            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                            if (window instanceof WorkbenchWindow && (trimManager = (extended = (WorkbenchWindow)window).getTrimManager()) != null && (trim = trimManager.getTrim("com.ibm.team.workitem.rcp.ui.WorkitemActivationGroup")) != null) {
                                trimManager.setTrimVisible(trim, false);
                                trim.getControl().getParent().layout(true);
                                MessageDialog.openInformation((Shell)ActiveWorkItemControl.this.getShell(), (String)Messages.ActiveWorkItemControl_WORKITEM, (String)Messages.ActiveWorkItemControl_REENABLE_MESSAGE);
                            }
                            ++n2;
                        }
                    }
                });
            }
        });
        Menu contextMenu = menu.createContextMenu((Control)this);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                IWorkbenchPage page;
                if (ActiveWorkItemControl.this.fWorkItem != null && (page = ActiveWorkItemControl.getWorkbenchPage()) != null) {
                    WorkItemUI.openEditor(page, ActiveWorkItemControl.this.fWorkItem);
                }
            }
        };
        this.fImageLabel = new CLabel((Composite)this, 0);
        GridData data = new GridData(4, 0x1000000, true, true);
        data.minimumWidth = 24;
        this.fImageLabel.setLayoutData((Object)data);
        this.fImageLabel.setMenu(contextMenu);
        this.fImageLabel.addMouseListener((MouseListener)listener);
        this.fImageLabel.setToolTipText(INACTIVE_TOOLTIP);
        new WorkItemTooltipSupport((Control)this.fImageLabel);
        this.fTextLabel = new CLabel((Composite)this, 0);
        this.fTextLabel.setText(INACTIVE_LABEL);
        this.fTextLabel.setToolTipText(INACTIVE_TOOLTIP);
        data = new GridData(4, 0x1000000, true, true);
        data.minimumWidth = 200;
        this.fTextLabel.setLayoutData((Object)data);
        this.fTextLabel.setMenu(contextMenu);
        this.fTextLabel.addMouseListener((MouseListener)listener);
        new WorkItemTooltipSupport((Control)this.fTextLabel);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Shell shell;
                ITeamRepository[] repositories;
                ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
                service.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)ActiveWorkItemControl.this.fRepositoryListener);
                ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository repository = iTeamRepositoryArray[n2];
                    ActiveWorkItemControl.this.fRepositoryListener.removedRepository(repository);
                    ++n2;
                }
                manager.removeActivationParticipant(ActiveWorkItemControl.this.fParticipant);
                ActiveWorkItemControl.this.fLabelProvider.dispose();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (shell = window.getShell()) != null && !shell.isDisposed() && shell.isVisible()) {
                    WorkItemRCPUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.active.trim", ActiveWorkItemControl.this.isVisible());
                }
            }
        });
        this.addDragSupport((Control)this.fImageLabel);
        this.addDragSupport((Control)this.fTextLabel);
        this.addDropSupport((Control)this.fImageLabel);
        this.addDropSupport((Control)this.fTextLabel);
        this.fLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                if (!ActiveWorkItemControl.this.isDisposed()) {
                    ActiveWorkItemControl.this.updateLabel();
                }
            }
        });
    }

    private void addDragSupport(Control control) {
        Assert.isNotNull((Object)control);
        new DragSupport(control, 4){

            public ISelection getSelection() {
                if (ActiveWorkItemControl.this.fWorkItem != null) {
                    return new StructuredSelection((Object)ActiveWorkItemControl.this.fWorkItem);
                }
                return StructuredSelection.EMPTY;
            }
        };
    }

    private void addDropSupport(Control control) {
        Assert.isNotNull((Object)control);
        DropTarget target = new DropTarget(control, 4);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void drop(DropTargetEvent event) {
                this.performDrop(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.validateDrop(event);
            }

            private void performDrop(DropTargetEvent event) {
                ISelection selection;
                Assert.isNotNull((Object)event);
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection extended = (IStructuredSelection)selection;
                    for (final Object element : extended) {
                        if (!(element instanceof IWorkItemHandle)) continue;
                        if ((event.operations & 4) != 0) {
                            event.detail = 4;
                        }
                        FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_START_WORKING_JOB_NAME){

                            protected IStatus runProtected(IProgressMonitor monitor) {
                                return ClientModel.getWorkItemActivationManager().activateWorkItem((IWorkItemHandle)element, monitor);
                            }
                        };
                        job.schedule();
                    }
                }
            }

            private void validateDrop(DropTargetEvent event) {
                ISelection selection;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                    IStructuredSelection extended = (IStructuredSelection)selection;
                    for (Object element : extended) {
                        if (!(element instanceof IWorkItemHandle)) continue;
                        if ((event.operations & 4) != 0) {
                            event.detail = 4;
                        }
                        return;
                    }
                }
                event.detail = 0;
            }
        });
    }

    void clearActiveWorkItem() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ActiveWorkItemControl.this.fWorkItem = null;
                ActiveWorkItemControl.this.fTextLabel.setText(INACTIVE_LABEL);
                ActiveWorkItemControl.this.fTextLabel.setToolTipText(INACTIVE_TOOLTIP);
                ActiveWorkItemControl.this.fImageLabel.setImage(null);
                ActiveWorkItemControl.this.fImageLabel.setToolTipText(INACTIVE_TOOLTIP);
            }
        });
    }

    private ITeamRepository getTeamRepository() {
        if (this.fWorkItem != null && this.fWorkItem.getOrigin() instanceof ITeamRepository) {
            return (ITeamRepository)this.fWorkItem.getOrigin();
        }
        return null;
    }

    void setActiveWorkItem(IWorkItemHandle handle, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        final IWorkItem item = ActiveWorkItemControl.resolveWorkItem(handle, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ActiveWorkItemControl.this.fWorkItem = item;
                ActiveWorkItemControl.this.updateLabel();
            }
        });
    }

    void updateLabel() {
        if (this.fWorkItem != null) {
            if (!this.fTextLabel.isDisposed()) {
                this.fTextLabel.setText(WorkItemTextUtilities.getWorkItemText((IWorkItem)this.fWorkItem, (int)36));
                this.fTextLabel.setToolTipText("");
            }
            if (!this.fImageLabel.isDisposed()) {
                this.fImageLabel.setImage(this.fLabelProvider.getImage((Object)this.fWorkItem));
                this.fImageLabel.setToolTipText("");
            }
        } else {
            if (!this.fTextLabel.isDisposed()) {
                this.fTextLabel.setText(INACTIVE_LABEL);
                this.fTextLabel.setToolTipText(INACTIVE_TOOLTIP);
            }
            if (!this.fImageLabel.isDisposed()) {
                this.fImageLabel.setImage(null);
                this.fImageLabel.setToolTipText(INACTIVE_TOOLTIP);
            }
        }
    }

    private static final class ActivateWorkItemAction
    extends Action {
        private final IWorkItemHandle fHandle;

        ActivateWorkItemAction(IWorkItemHandle handle) {
            Assert.isNotNull((Object)handle);
            this.fHandle = handle;
            this.setText(Messages.ActiveWorkItemControl_PENDING);
            this.setDescription(Messages.ActiveWorkItemControl_PENDING);
            FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_RESOLVING_WORKITEM){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    final IWorkItem item = ActiveWorkItemControl.resolveWorkItem(ActivateWorkItemAction.this.fHandle, monitor);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (item != null) {
                                String label = WorkItemTextUtilities.getWorkItemText((IWorkItem)item, (int)24);
                                ActivateWorkItemAction.this.setText(label);
                                ActivateWorkItemAction.this.setDescription(MessageFormat.format(Messages.ActiveWorkItemControl_START_WORKING_ON, label));
                            } else {
                                ActivateWorkItemAction.this.setText(Messages.ActiveWorkItemControl_NOT_AVAILABLE);
                                ActivateWorkItemAction.this.setDescription(Messages.ActiveWorkItemControl_BOT_AVAILABLE);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public void run() {
            FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_START_WORKING){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    return ClientModel.getWorkItemActivationManager().activateWorkItem(ActivateWorkItemAction.this.fHandle, monitor);
                }
            };
            job.schedule();
        }
    }

    private final class ActiveWorkItemListener
    extends WorkItemActivationParticipant {
        private ActiveWorkItemListener() {
        }

        public IStatus handleActivationEvent(WorkItemActivationEvent event, IProgressMonitor monitor) {
            Assert.isNotNull((Object)event);
            int type = event.getType();
            if (type == 0) {
                ActiveWorkItemControl.this.setActiveWorkItem(event.getWorkItem(), monitor);
            } else if (type == 1) {
                ActiveWorkItemControl.this.clearActiveWorkItem();
            }
            return Status.OK_STATUS;
        }
    }

    private static final class OpenWorkItemAction
    extends Action {
        private final IWorkItemHandle fHandle;
        private final IWorkbenchPage fPage;

        OpenWorkItemAction(IWorkbenchPage page, IWorkItemHandle handle) {
            super(Messages.ActiveWorkItemControl_OPEN);
            Assert.isNotNull((Object)page);
            Assert.isNotNull((Object)handle);
            this.fPage = page;
            this.fHandle = handle;
        }

        public void run() {
            WorkItemUI.openEditor(this.fPage, this.fHandle);
        }
    }

    private static final class SelectWorkItemAction
    extends Action {
        private final IWorkItemHandle fHandle;
        private final Shell fShell;

        SelectWorkItemAction(Shell shell, IWorkItemHandle handle) {
            super(Messages.ActiveWorkItemControl_START_WORKING_ELLIPSES);
            Assert.isNotNull((Object)shell);
            this.fShell = shell;
            this.fHandle = handle;
            this.setDescription(Messages.ActiveWorkItemControl_SELECT_WORKITEM_DESCRIPTION);
            this.setToolTipText(Messages.ActiveWorkItemControl_START_WORKING_TOOLTIP_TEXT);
        }

        public void run() {
            IWorkItemHandle handle;
            Object origin;
            ITeamRepository repository = null;
            if (this.fHandle != null && (origin = this.fHandle.getOrigin()) instanceof ITeamRepository) {
                repository = (ITeamRepository)origin;
            }
            WorkItemSelectionDialog dialog = null;
            dialog = repository != null && repository.loggedIn() ? new WorkItemSelectionDialog(this.fShell, repository, false) : new WorkItemSelectionDialog(this.fShell, false);
            if (this.fHandle != null) {
                dialog.setExcluded(new IWorkItemHandle[]{this.fHandle});
            }
            if ((handle = dialog.getSingleWorkItem()) != null) {
                final IWorkItemHandle workItem = handle;
                FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_START_WORKING_JOB_NAME){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        return ClientModel.getWorkItemActivationManager().activateWorkItem(workItem, monitor);
                    }
                };
                job.schedule();
            }
        }
    }

    private final class TeamRepositoryLoginListener
    implements ITeamRepositoryService.IRepositoryServiceListener,
    IListener {
        TeamRepositoryLoginListener() {
        }

        public void addedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.addGenericListener((Object)"state", (IListener)this);
        }

        public void handleEvents(List events) {
            Assert.isNotNull((Object)events);
            for (Object event : events) {
                IEventSource source;
                PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                final ITeamRepository repository = (ITeamRepository)source;
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        final IWorkItemHandle handle = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
                        if (handle != null) {
                            FoundationJob job = new FoundationJob(Messages.ActiveWorkItemControl_INIT_CURRENT_WORK_JOB_NAME){

                                protected IStatus runProtected(IProgressMonitor monitor) {
                                    ActiveWorkItemControl.this.setActiveWorkItem(handle, monitor);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setPriority(20);
                            job.setSystem(true);
                            job.schedule();
                            break;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!ActiveWorkItemControl.this.fTextLabel.isDisposed() && !ActiveWorkItemControl.this.fImageLabel.isDisposed()) {
                                    ActiveWorkItemControl.this.fTextLabel.setText(INACTIVE_LABEL);
                                    ActiveWorkItemControl.this.fTextLabel.setToolTipText(INACTIVE_TOOLTIP);
                                    ActiveWorkItemControl.this.fImageLabel.setImage(null);
                                    ActiveWorkItemControl.this.fImageLabel.setToolTipText(INACTIVE_TOOLTIP);
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                ITeamRepository other = ActiveWorkItemControl.this.getTeamRepository();
                                if (other != null && other.getRepositoryURI().equals(repository.getRepositoryURI()) && !ActiveWorkItemControl.this.fTextLabel.isDisposed() && !ActiveWorkItemControl.this.fImageLabel.isDisposed()) {
                                    ActiveWorkItemControl.this.fTextLabel.setText(LOGGED_OUT_LABEL);
                                    ActiveWorkItemControl.this.fTextLabel.setToolTipText(LOGGED_OUT_TOOLTIP);
                                    ActiveWorkItemControl.this.fImageLabel.setImage(null);
                                    ActiveWorkItemControl.this.fImageLabel.setToolTipText(LOGGED_OUT_TOOLTIP);
                                }
                            }
                        });
                    }
                }
            }
        }

        public void removedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.removeGenericListener((Object)"state", (IListener)this);
        }
    }

    private static final class WorkItemSelectionProvider
    implements ISelectionProvider {
        private final IStructuredSelection fSelection;

        WorkItemSelectionProvider(IWorkItemHandle handle) {
            Assert.isNotNull((Object)handle);
            this.fSelection = new StructuredSelection((Object)handle);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.fSelection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private final class WorkItemTooltipSupport
    extends TooltipSupport {
        WorkItemTooltipSupport(Control control) {
            super(control, true, true);
        }

        protected Object mapElement(int x, int y) {
            ITeamRepository repository = ActiveWorkItemControl.this.getTeamRepository();
            if (repository != null && repository.loggedIn()) {
                return ActiveWorkItemControl.this.fWorkItem;
            }
            return null;
        }

        protected void openRequested(Object element) {
            IWorkbenchPage page;
            if (ActiveWorkItemControl.this.fWorkItem != null && (page = ActiveWorkItemControl.getWorkbenchPage()) != null) {
                WorkItemUI.openEditor(page, ActiveWorkItemControl.this.fWorkItem);
            }
        }
    }
}

