/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.HelpContextIds;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.RepositoryOperationRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RenameQueryAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public RenameQueryAction() {
    }

    public RenameQueryAction(IWorkbenchPart part, IStructuredSelection selection) {
        this.fWorkbenchPart = part;
        this.fSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        IQueryDescriptorHandle handle = this.getQueryDescriptorHandle();
        if (handle != null) {
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)new RenameQueryWizard(handle));
            dialog.setHelpAvailable(false);
            dialog.setMinimumPageSize(0, 0);
            dialog.open();
        }
    }

    private IQueryDescriptorHandle getQueryDescriptorHandle() {
        if (this.fSelection != null && !this.fSelection.isEmpty() && this.fSelection.getFirstElement() instanceof IQueryDescriptorHandle) {
            return (IQueryDescriptorHandle)this.fSelection.getFirstElement();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    private Shell getShell() {
        return this.fWorkbenchPart.getSite().getShell();
    }

    private static class RenameQueryWizard
    extends Wizard {
        private RenameQueryWizardPage fRenamePage;

        public RenameQueryWizard(IQueryDescriptorHandle queryDescriptor) {
            this.fRenamePage = new RenameQueryWizardPage(Messages.RenameQueryAction_RENAME_QUERY_PAGE_NAME, queryDescriptor);
            this.addPage((IWizardPage)this.fRenamePage);
            this.setWindowTitle(Messages.RenameQueryAction_TITLE);
            this.setNeedsProgressMonitor(true);
        }

        public boolean performFinish() {
            RepositoryOperationRunnable runnable = new RepositoryOperationRunnable(){

                protected IQueryDescriptorWorkingCopy performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                    RenameQueryWizard.this.fRenamePage.getWorkingCopy().save(monitor);
                    return RenameQueryWizard.this.fRenamePage.getWorkingCopy();
                }
            };
            runnable.run((IRunnableContext)this.getContainer());
            if (!runnable.getStatus().isOK()) {
                this.fRenamePage.setErrorMessage(runnable.getStatus().getMessage());
                return false;
            }
            return true;
        }
    }

    private static class RenameQueryWizardPage
    extends WizardPage {
        private ModifyListener fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameQueryWizardPage.this.handleModification(e);
            }
        };
        private final IQueryDescriptorHandle fHandle;
        private IQueryDescriptorWorkingCopy fWorkingCopy;
        private boolean fResolvingStarted;
        private Text fNameText;

        public RenameQueryWizardPage(String title, IQueryDescriptorHandle handle) {
            super("com.ibm.team.workitem.rcp.ui.RenameQueryWizard", title, null);
            this.setDescription(Messages.RenameQueryAction_PROVIDE_NEW_QUERY_NAME);
            Assert.isNotNull((Object)handle);
            this.fHandle = handle;
            this.fResolvingStarted = false;
        }

        public void setVisible(boolean visible) {
            if (!this.fResolvingStarted) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        RenameQueryWizardPage.this.resolveInput();
                    }
                });
                this.fResolvingStarted = true;
            }
            super.setVisible(visible);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.RenameQueryAction_NEW_NAME_LABEL);
            GridDataFactory.swtDefaults().applyTo((Control)label);
            this.fNameText = new Text(composite, 2048);
            this.fNameText.addModifyListener(this.fModifyListener);
            GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(40), -1).applyTo((Control)this.fNameText);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.workitem.rcp.ui.rename_query_wizard_main_page");
        }

        public boolean isPageComplete() {
            return this.fWorkingCopy != null && this.fWorkingCopy.getQueryDescriptor().getName().trim().length() > 0;
        }

        public String getNewName() {
            return this.fNameText.getText().trim();
        }

        private void handleModification(ModifyEvent e) {
            if (this.fWorkingCopy != null) {
                this.fWorkingCopy.getQueryDescriptor().setName(this.getNewName());
                if (this.fWorkingCopy.getQueryDescriptor().getName().length() == 0) {
                    this.setErrorMessage(Messages.RenameQueryAction_NAME_MUST_NOT_BE_EMPTY);
                } else {
                    this.setErrorMessage(null);
                }
            }
            this.getContainer().updateButtons();
        }

        private void resolveInput() {
            RepositoryOperationRunnable<IQueryDescriptorWorkingCopy> runnable = new RepositoryOperationRunnable<IQueryDescriptorWorkingCopy>(){

                @Override
                protected IQueryDescriptorWorkingCopy performOperation(IProgressMonitor monitor) throws TeamRepositoryException {
                    IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)RenameQueryWizardPage.this.fHandle, IQueryClient.class);
                    queryClient.getWorkingCopyManager().connect(RenameQueryWizardPage.this.fHandle, monitor);
                    return queryClient.getWorkingCopyManager().getWorkingCopy(RenameQueryWizardPage.this.fHandle);
                }

                @Override
                protected String getErrorMessage(Throwable e) {
                    if (e instanceof ItemNotFoundException) {
                        return Messages.RenameQueryAction_QUERY_WAS_DELETED;
                    }
                    return super.getErrorMessage(e);
                }
            };
            this.fWorkingCopy = (IQueryDescriptorWorkingCopy)runnable.run((IRunnableContext)this.getContainer());
            if (runnable.getStatus().isOK()) {
                this.fNameText.setText(this.fWorkingCopy.getQueryDescriptor().getName());
                this.fNameText.setSelection(0, this.fNameText.getCharCount());
            } else {
                this.setErrorMessage(runnable.getStatus().getMessage());
            }
        }

        public IQueryDescriptorWorkingCopy getWorkingCopy() {
            return this.fWorkingCopy;
        }

        public void dispose() {
            if (this.fWorkingCopy != null) {
                IQueryClient queryClient = (IQueryClient)ClientUtils.getClientLibrary((IItemHandle)this.fHandle, IQueryClient.class);
                queryClient.getWorkingCopyManager().disconnect(this.fHandle);
            }
            super.dispose();
        }
    }
}

