/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenWorkItemAction
extends Action
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public OpenWorkItemAction() {
    }

    public OpenWorkItemAction(IWorkbenchPart part, IStructuredSelection selection) {
        this.fWorkbenchPart = part;
        this.fSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(ISelection selection) {
        boolean enabled = false;
        if (selection instanceof IStructuredSelection) {
            enabled = true;
            for (Object element : ((IStructuredSelection)selection).toList()) {
                enabled &= WorkItemRCPUIPlugin.canOpenAsWorkItem(element);
            }
        }
        return enabled;
    }

    public void run() {
        if (this.fWorkbenchPart != null) {
            for (Object element : ((IStructuredSelection)this.fSelection).toList()) {
                WorkItemUI.openEditor(this.fWorkbenchPart.getSite().getPage(), element);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }
}

