/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.ide.ui.EditorUtilities;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUIOperation;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.IDefaultProjectAreaListener;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.actions.NewWorkItemsFromTemplateAction;
import com.ibm.team.workitem.rcp.ui.internal.wizards.NewWorkItemWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWorkItemAction
implements IWorkbenchWindowPulldownDelegate {
    public static final String NO_TYPES_AVAILABLE_TITLE = Messages.NewWorkItemAction_NO_TYPES_AVALIABLE_TITLE;
    public static final String NO_TYPES_AVAILABLE_MESSAGE = Messages.NewWorkItemAction_NO_TYPES_AVAILABLE_MESSAGE;
    public static final String SHOW_PROCESS_SPECIFICATION_CAPTION = Messages.NewWorkItemAction_SHOW_PROCESS_SPEC_CAPTION;
    private IWorkbenchWindow fWindow;
    private Menu fMenu;
    private IAction fAction;
    private ProjectAreaPicker.ProjectAreaLabelProvider fLabelProvider;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private ConnectedProjectAreaListener fConnectedProjectAreaListener;
    private Set<IProjectAreaHandle> fFailingProjectAreas = new ItemHandleAwareHashSet();

    public void init(IWorkbenchWindow window) {
        this.fLabelProvider = new ProjectAreaPicker.ProjectAreaLabelProvider(ProjectAreaPicker.getAllConnectedProjectAreas(true));
        this.fWindow = window;
        this.fConnectedProjectAreaListener = new ConnectedProjectAreaListener();
        ConnectedProjectAreaRegistry.getDefault().addListener((IConnectedProjectAreaRegistryListener)this.fConnectedProjectAreaListener);
        ConnectedProjectAreas.getInstance().addListener(this.fConnectedProjectAreaListener);
    }

    public void run(IAction action) {
        this.fAction = action;
        this.updateAction();
        IProjectAreaHandle defaultProjectArea = this.getDefaultProjectArea();
        if ((defaultProjectArea == null || this.fAction != null && this.fAction.getStyle() == 1) && ProjectAreaPicker.getAllConnectedProjectAreas(true).size() == 1) {
            defaultProjectArea = ProjectAreaPicker.getAllConnectedProjectAreas(true).get(0);
        }
        if (defaultProjectArea != null) {
            NewWorkItemAction.createWorkItem(defaultProjectArea, null);
        } else {
            NewWorkItemWizard wizard = new NewWorkItemWizard();
            wizard.init(this.fWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog dialog = new WizardDialog(this.fWindow.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public static boolean createWorkItem(IProjectAreaHandle projectArea, IWorkItemType type) {
        return NewWorkItemAction.createWorkItem(projectArea, type, null);
    }

    public static boolean createWorkItem(final IProjectAreaHandle projectArea, final IWorkItemType type, final WorkItemOperation postCreationOperation) {
        if (projectArea != null) {
            final ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
            final WorkItemUIOperation operation = new WorkItemUIOperation(Messages.NewWorkItemAction_CREATING_WORKITEM_OPERATION_NAME){

                protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                    if (postCreationOperation != null) {
                        postCreationOperation.run((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                    }
                }
            };
            FoundationJob job = new FoundationJob(operation.getName()){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    try {
                        if (!repository.loggedIn()) {
                            repository.login(monitor);
                        }
                        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                        if (type == null) {
                            List types = workItemClient.findWorkItemTypes(projectArea, monitor);
                            if (!types.isEmpty()) {
                                operation.run((IWorkItemType)types.get(0), monitor);
                            } else {
                                operation.run(workItemClient.findWorkItemType(projectArea, "defect", monitor), monitor);
                            }
                        } else {
                            IWorkItemType t = workItemClient.findWorkItemType(projectArea, type.getIdentifier(), monitor);
                            if (t == null) {
                                String message = NLS.bind((String)Messages.NewWorkItemAction_WORKITEM_TYPE_DOES_NOT_EXIST, (Object)type.getIdentifier(), (Object[])new Object[0]);
                                return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, null);
                            }
                            operation.run(t, monitor);
                        }
                    }
                    catch (TeamRepositoryException x) {
                        String message = NLS.bind((String)Messages.NewWorkItemAction_EXCEPTION_RUNNING_OPERATION, (Object)operation.getName(), (Object[])new Object[0]);
                        return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, message, (Throwable)x);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
            return true;
        }
        return false;
    }

    private void setDefaultProjectArea(IProjectAreaHandle projectArea) {
        ConnectedProjectAreas.getInstance().setDefaultProjectArea(projectArea);
        this.updateAction();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fAction = action;
        this.updateAction();
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            this.fMenu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    NewWorkItemAction.this.fillMenu();
                }
            });
        }
        return this.fMenu;
    }

    private void fillMenu() {
        MenuItem[] menuItemArray = this.fMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        List<IProjectAreaHandle> areas = ProjectAreaPicker.getAllConnectedProjectAreas(true);
        if (areas.isEmpty()) {
            ActionContributionItem item = new ActionContributionItem((IAction)new ShowWizardAction(null));
            item.fill(this.fMenu, -1);
        } else {
            Collections.sort(areas, ProjectAreaPicker.fgProjectAreaComparator);
            IProjectAreaHandle defaultProjectArea = this.getDefaultProjectArea();
            if (defaultProjectArea == null && areas.size() == 1) {
                defaultProjectArea = areas.get(0);
            }
            if (defaultProjectArea != null) {
                this.fillTypeActions(this.fMenu, defaultProjectArea);
            } else {
                ActionContributionItem item = new ActionContributionItem((IAction)new ShowWizardAction(null));
                item.fill(this.fMenu, -1);
            }
            if (defaultProjectArea != null) {
                new Separator().fill(this.fMenu, -1);
                this.fillTemplateActions(this.fMenu, defaultProjectArea);
            }
            if (areas.size() > 1 || defaultProjectArea == null) {
                new Separator().fill(this.fMenu, -1);
                for (IProjectAreaHandle projectArea : areas) {
                    boolean isDefault = projectArea.sameItemId((IItemHandle)defaultProjectArea);
                    Image image = this.fLabelProvider.getImage(projectArea);
                    if (isDefault) {
                        int style = 16;
                        String text = ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), projectArea);
                        if ("gtk".equals(SWT.getPlatform())) {
                            style = 8;
                            text = NLS.bind((String)Messages.NewWorkItemAction_PATTERN_GTK_DEFAULT, (Object)text, (Object[])new Object[0]);
                        }
                        MenuItem item = new MenuItem(this.fMenu, style);
                        item.setSelection(true);
                        item.setEnabled(false);
                        item.setText(NewWorkItemAction.asMenuName(text));
                        if (image == null) continue;
                        item.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImageDescriptor.createFromImage((Image)image)));
                        continue;
                    }
                    MenuItem item = new MenuItem(this.fMenu, 64);
                    item.setText(NewWorkItemAction.asMenuName(ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), projectArea)));
                    if (image != null) {
                        item.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImageDescriptor.createFromImage((Image)image)));
                    }
                    Menu sub = new Menu(item);
                    item.setMenu(sub);
                    this.fillTypeActions(sub, projectArea);
                    new Separator().fill(sub, -1);
                    this.fillTemplateActions(sub, projectArea);
                    new Separator().fill(sub, -1);
                    ActionContributionItem def = new ActionContributionItem((IAction)new SetDefaultProjectAreaAction(projectArea));
                    def.fill(sub, -1);
                }
            }
        }
    }

    private void fillTypeActions(Menu menu, IProjectAreaHandle projectArea) {
        ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        List<IWorkItemType> types = NewWorkItemAction.findCachedWorkItemTypes(workItemClient, projectArea);
        if (types != null) {
            if (!types.isEmpty()) {
                for (IWorkItemType type : types) {
                    ActionContributionItem item = new ActionContributionItem((IAction)new NewWorkItemWithTypeAction(projectArea, type, this.getImageDescriptor(type)));
                    item.fill(menu, -1);
                }
            } else {
                ActionContributionItem item = new ActionContributionItem((IAction)new NoWorkItemTypesAction(this.fWindow.getShell(), projectArea));
                item.fill(menu, -1);
            }
        } else {
            ActionContributionItem item = new ActionContributionItem((IAction)new ShowWizardAction(projectArea));
            item.fill(menu, -1);
        }
    }

    private void fillTemplateActions(Menu menu, IProjectAreaHandle projectArea) {
        ActionContributionItem item = new ActionContributionItem((IAction)new NewWorkItemsFromTemplateAction(projectArea));
        item.fill(menu, -1);
    }

    private ImageDescriptor getImageDescriptor(IWorkItemType type) {
        if (type.getIconURL() == null) {
            return null;
        }
        return WorkItemUI.getImageDescriptor(type.getIconURL());
    }

    private void updateAction() {
        if (this.fAction == null) {
            return;
        }
        if (this.getDefaultProjectArea() == null) {
            this.fAction.setToolTipText(Messages.NewWorkItemAction_NO_PROJECT_AREA_TOOLTIP);
        } else {
            String tooltipText = NLS.bind((String)Messages.NewWorkItemAction_PROJECT_AREA_TOOLTIP, (Object)ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), this.getDefaultProjectArea()), (Object[])new Object[0]);
            this.fAction.setToolTipText(tooltipText);
        }
    }

    private IProjectAreaHandle getDefaultProjectArea() {
        return ConnectedProjectAreas.getInstance().getDefaultProjectArea(true);
    }

    static String asMenuName(String text) {
        return text.replaceAll("&", "&&");
    }

    static String asActionName(String text) {
        String name = NewWorkItemAction.asMenuName(text);
        if (name.indexOf(64) > -1) {
            name = String.valueOf(name) + '@';
        }
        return name;
    }

    public void dispose() {
        if (this.fConnectedProjectAreaListener != null) {
            ConnectedProjectAreaRegistry.getDefault().removeListener((IConnectedProjectAreaRegistryListener)this.fConnectedProjectAreaListener);
            ConnectedProjectAreas.getInstance().removeListener(this.fConnectedProjectAreaListener);
            this.fConnectedProjectAreaListener = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        this.fResourceManager.dispose();
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        this.fWindow = null;
    }

    private void populateCache(IWorkItemClient workItemClient, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fFailingProjectAreas.contains(projectArea)) {
            return;
        }
        boolean success = false;
        try {
            NewWorkItemAction.findWorkItemTypes(workItemClient, projectArea, monitor);
            success = true;
        }
        finally {
            if (!success) {
                this.fFailingProjectAreas.add(projectArea);
            }
        }
    }

    public static List<IWorkItemType> findWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea resolved = (IProjectArea)workItemClient.getAuditableCommon().resolveAuditable((IAuditableHandle)projectArea, ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        if (!resolved.isInitialized()) {
            return Collections.emptyList();
        }
        ICategory unassigned = workItemClient.findUnassignedCategory(projectArea, ICategory.DEFAULT_PROFILE, monitor);
        ITeamAreaHandle teamArea = unassigned.getDefaultTeamArea();
        if (teamArea == null) {
            return workItemClient.findWorkItemTypes(projectArea, monitor);
        }
        return NewWorkItemAction.findWorkItemTypes(workItemClient, projectArea, teamArea, monitor);
    }

    private static List<IWorkItemType> findWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea, ITeamAreaHandle teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return workItemClient.findWorkItemTypes(projectArea, monitor);
    }

    private static List<IWorkItemType> findCachedWorkItemTypes(IWorkItemClient workItemClient, IProjectAreaHandle projectArea) {
        return workItemClient.findCachedWorkItemTypes(projectArea);
    }

    private class ConnectedProjectAreaListener
    implements IConnectedProjectAreaRegistryListener,
    IDefaultProjectAreaListener {
        private ConnectedProjectAreaListener() {
        }

        public void connectedProjectAreaRegistryChanged(final IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            List connectedPAs;
            IWorkItemClient workItemClient;
            ITeamRepository teamRepository;
            if (NewWorkItemAction.this.fLabelProvider != null) {
                NewWorkItemAction.this.fLabelProvider.setProjectAreas(ProjectAreaPicker.getAllConnectedProjectAreas(true));
            }
            if (changeEvent.getType() == 1 && changeEvent.getAddedProjectArea() != null) {
                teamRepository = changeEvent.getTeamRepository();
                if (teamRepository.loggedIn()) {
                    workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    FoundationJob j = new FoundationJob(Messages.NewWorkItemAction_UPDATE_TYPES_JOB_NAME){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            try {
                                IProjectAreaHandle projectArea = changeEvent.getAddedProjectArea();
                                NewWorkItemAction.this.populateCache(workItemClient, projectArea, monitor);
                            }
                            catch (NotLoggedInException notLoggedInException) {
                                return Status.OK_STATUS;
                            }
                            catch (TeamRepositoryException e) {
                                return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.NewWorkItemAction_EXCEPTION_FETCHING_TYPES, (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    j.setSystem(true);
                    j.schedule();
                }
            } else if (changeEvent.getType() == 0 && (teamRepository = changeEvent.getTeamRepository()).loggedIn()) {
                workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                connectedPAs = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository);
                final ArrayList<IProjectAreaHandle> nonCached = new ArrayList<IProjectAreaHandle>();
                for (IProjectAreaHandle candidate : connectedPAs) {
                    if (NewWorkItemAction.findCachedWorkItemTypes(workItemClient, candidate) != null) continue;
                    nonCached.add(candidate);
                }
                if (!nonCached.isEmpty()) {
                    FoundationJob j = new FoundationJob(Messages.NewWorkItemAction_UPDATE_TYPES_JOB_NAME){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            try {
                                for (IProjectAreaHandle projectArea : nonCached) {
                                    NewWorkItemAction.this.populateCache(workItemClient, projectArea, monitor);
                                }
                            }
                            catch (NotLoggedInException notLoggedInException) {
                                return Status.OK_STATUS;
                            }
                            catch (TeamRepositoryException e) {
                                return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.NewWorkItemAction_EXCEPTION_FETCHING_TYPES, (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    j.setSystem(true);
                    j.schedule();
                }
            }
            IProjectAreaHandle defaultProjectArea = NewWorkItemAction.this.getDefaultProjectArea();
            ITeamRepository teamRepository2 = changeEvent.getTeamRepository();
            connectedPAs = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository2);
            for (IProjectAreaHandle candidate : connectedPAs) {
                if (!candidate.sameItemId((IItemHandle)defaultProjectArea)) continue;
                NewWorkItemAction.this.updateAction();
                return;
            }
            NewWorkItemAction.this.setDefaultProjectArea(null);
        }

        public void defaultProjectAreaChanged(IProjectAreaHandle before, IProjectAreaHandle after) {
            NewWorkItemAction.this.updateAction();
        }
    }

    private class NewWorkItemWithTypeAction
    extends Action {
        private IWorkItemType fType;
        private IProjectAreaHandle fProjectArea;

        public NewWorkItemWithTypeAction(IProjectAreaHandle projectArea, IWorkItemType type, ImageDescriptor desc) {
            super(NewWorkItemAction.asActionName(type.getDisplayName()), 1);
            this.fType = type;
            this.fProjectArea = projectArea;
            if (desc != null) {
                this.setImageDescriptor(desc);
            }
        }

        public void run() {
            if (NewWorkItemAction.this.getDefaultProjectArea() == null && ProjectAreaPicker.getAllConnectedProjectAreas(true).size() > 1) {
                NewWorkItemAction.this.setDefaultProjectArea(this.fProjectArea);
            }
            NewWorkItemAction.createWorkItem(this.fProjectArea, this.fType);
        }
    }

    private class NoWorkItemTypesAction
    extends Action {
        private Shell fShell;
        private IProjectAreaHandle fProjectArea;

        private NoWorkItemTypesAction(Shell shell, IProjectAreaHandle projectArea) {
            super(NO_TYPES_AVAILABLE_TITLE);
            this.fShell = shell;
            this.fProjectArea = projectArea;
        }

        public void run() {
            MessageDialog dialog = new MessageDialog(this.fShell, NO_TYPES_AVAILABLE_TITLE, null, NO_TYPES_AVAILABLE_MESSAGE, 2, new String[]{IDialogConstants.OK_LABEL}, 0){

                protected Control createCustomArea(Composite parent) {
                    Hyperlink link = new Hyperlink(parent, 0);
                    link.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
                    link.setText(SHOW_PROCESS_SPECIFICATION_CAPTION);
                    link.setToolTipText(SHOW_PROCESS_SPECIFICATION_CAPTION);
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            this.okPressed();
                            IWorkbenchPage page = null;
                            if (NewWorkItemAction.this.fWindow != null) {
                                page = NewWorkItemAction.this.fWindow.getActivePage();
                            }
                            EditorUtilities.openProjectAreaEditor((IWorkbenchPage)page, (IProjectAreaHandle)NoWorkItemTypesAction.this.fProjectArea, (String)"processConfiguration");
                        }
                    });
                    HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
                    hyperlinkGroup.add(link);
                    return link;
                }
            };
            dialog.open();
        }
    }

    private class SetDefaultProjectAreaAction
    extends Action {
        private IProjectAreaHandle fProjectArea;

        public SetDefaultProjectAreaAction(IProjectAreaHandle projectArea) {
            super(NewWorkItemAction.asActionName(NLS.bind((String)Messages.NewWorkItemAction_MAKE_DEFAULT_PROJECT_AREA, (Object)ProjectAreaPicker.getUnambiguousProjectName(ProjectAreaPicker.getAllConnectedProjectAreas(true), projectArea), (Object[])new Object[0])), 1);
            this.fProjectArea = projectArea;
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)NewWorkItemAction.this.fLabelProvider.getImage(projectArea)));
        }

        public void run() {
            NewWorkItemAction.this.setDefaultProjectArea(this.fProjectArea);
        }
    }

    private class ShowWizardAction
    extends Action {
        private IProjectAreaHandle fProjectArea;

        public ShowWizardAction(IProjectAreaHandle projectArea) {
            super(Messages.NewWorkItemAction_CREATE_WORKITEM_ACTION_NAME);
            this.fProjectArea = projectArea;
        }

        public void run() {
            NewWorkItemWizard wizard = new NewWorkItemWizard(null, this.fProjectArea);
            wizard.init(NewWorkItemAction.this.fWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog dialog = new WizardDialog(NewWorkItemAction.this.fWindow.getShell(), (IWizard)wizard);
            dialog.open();
        }
    }
}

