/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.readstate.IReadStateManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MarkReadAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (action != null) {
            action.setEnabled(this.isEnabled(selection));
        }
    }

    private boolean isEnabled(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        for (IWorkItemHandle handle : (IStructuredSelection)selection) {
            IWorkItem workitem;
            if (handle.hasFullState() && (workitem = (IWorkItem)handle.getFullState()) != null && workitem.isNewItem()) {
                return false;
            }
            if (IReadStateManager.DEFAULT.isMarkedRead((IItemHandle)handle, null)) continue;
            return true;
        }
        return false;
    }

    public void run(IAction action) {
        Iterator iterator = ((IStructuredSelection)this.fSelection).iterator();
        final ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof IWorkItemHandle)) continue;
            handles.add((IWorkItemHandle)o);
        }
        new FoundationJob(Messages.MarkReadAction_RESOLVING_WORKITEMS_READSTATE){

            protected IStatus runProtected(IProgressMonitor monitor) {
                for (IWorkItemHandle handle : handles) {
                    ITeamRepository repo = (ITeamRepository)handle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)repo.getClientLibrary(IAuditableClient.class);
                    try {
                        IWorkItem workitem = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)handle, IWorkItem.SMALL_PROFILE, monitor);
                        IReadStateTracker readStateTracker = (IReadStateTracker)Adapters.getAdapter((Object)workitem, IReadStateTracker.class);
                        if (readStateTracker != null) {
                            readStateTracker.markRead();
                            continue;
                        }
                        IReadStateManager.DEFAULT.markRead((IItem)workitem);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        IReadStateManager.DEFAULT.markRead((IItemHandle)handle, new Date());
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

