/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindWorkItemsSimilarToClipboardAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        String clipboardContents = this.getTextFromClipboard();
        if (clipboardContents == null) {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)Messages.FindWorkItemsSimilarToClipboardAction_FIND_SIMILAR_TO_CLIPBOARD, (String)Messages.FindWorkItemsSimilarToClipboardAction_CLIPBOARD_DOES_NOT_CONTAIN_TEXT);
        } else {
            IProjectAreaHandle projectArea = WorkItemUI.selectProjectArea(this.fWindow.getShell());
            if (projectArea != null) {
                QueriesUI.showRelatedWorkItems(this.fWindow, projectArea, Messages.FindWorkItemsSimilarToClipboardAction_SIMILAR_TO_CLIPBOARD_CONTENTS, "", clipboardContents);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private boolean clipboardContainsText() {
        Clipboard clipboard = new Clipboard(this.fWindow.getShell().getDisplay());
        TransferData[] data = clipboard.getAvailableTypes();
        int i = 0;
        while (i < data.length) {
            if (TextTransfer.getInstance().isSupportedType(data[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTextFromClipboard() {
        if (!this.clipboardContainsText()) {
            return null;
        }
        Clipboard clipboard = new Clipboard(this.fWindow.getShell().getDisplay());
        return (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
    }
}

