/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FindSimilarWorkItemsAction
implements IObjectActionDelegate {
    private IWorkItem fWorkItem;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fWorkItem = this.getWorkItemFromSelection(selection);
        if (action != null) {
            action.setEnabled(this.fWorkItem != null);
        }
    }

    private IWorkItem getWorkItemFromSelection(ISelection selection) {
        Object selected;
        if (selection instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IWorkItem) {
            return (IWorkItem)selected;
        }
        return null;
    }

    public void run(IAction action) {
        IWorkbenchWindow window = this.fWorkbenchPart != null ? this.fWorkbenchPart.getSite().getWorkbenchWindow() : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && this.fWorkItem != null) {
            if (this.fWorkItem.isWorkingCopy()) {
                ITeamRepository repository = (ITeamRepository)this.fWorkItem.getOrigin();
                IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                IWorkItemWorkingCopyManager manager = workItemClient.getWorkItemWorkingCopyManager();
                if (manager.connectLocal((IWorkItemHandle)this.fWorkItem, IWorkItem.FULL_PROFILE)) {
                    try {
                        WorkItemWorkingCopy copy = manager.getWorkingCopy((IWorkItemHandle)this.fWorkItem);
                        QueriesUI.showRelatedWorkItems(window, copy);
                    }
                    finally {
                        manager.disconnect((IWorkItemHandle)this.fWorkItem);
                    }
                } else {
                    QueriesUI.showRelatedWorkItems(window, this.fWorkItem);
                }
            } else {
                QueriesUI.showRelatedWorkItems(window, this.fWorkItem);
            }
        }
    }
}

