/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.core.queries.Query;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class EditQueryAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fPart;

    public EditQueryAction() {
    }

    public EditQueryAction(IWorkbenchPart part, IStructuredSelection selection) {
        this.fPart = part;
        this.fSelection = selection;
    }

    public void run() {
        Object object = this.getSelection().getFirstElement();
        if (object instanceof IQueryDescriptorHandle) {
            this.handleQueryDescriptor((IQueryDescriptorHandle)object);
        } else if (object instanceof Query) {
            Query query = (Query)object;
            this.handleExpression(query.getName(), query.getExpression());
        } else if (object instanceof Expression) {
            this.handleExpression(Messages.EditQueryAction_DEFAULT_QUERY_NAME, (Expression)object);
        }
    }

    private void handleExpression(String name, Expression expression) {
        IProjectAreaHandle projectArea = QueryUtils.getProjectArea((Expression)expression);
        if (projectArea == null) {
            projectArea = ProjectAreaPicker.showDialog(this.getShell(), false);
        }
        if (projectArea != null) {
            ITeamRepository repository = (ITeamRepository)projectArea.getOrigin();
            IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
            IQueryDescriptor descriptor = queryClient.createQuery(projectArea, "com.ibm.team.workitem.workItemType", name, expression);
            this.editQuery(this.fPart.getSite().getPage(), (IQueryDescriptorHandle)descriptor);
        }
    }

    private void handleQueryDescriptor(IQueryDescriptorHandle handle) {
        this.editQuery(this.fPart.getSite().getPage(), handle);
    }

    private void editQuery(IWorkbenchPage page, IQueryDescriptorHandle query) {
        ITeamRepository repository = (ITeamRepository)query.getOrigin();
        if (FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)true, null).isOK()) {
            QueriesUI.editQuery(page, query);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    private Shell getShell() {
        if (this.fPart != null) {
            return this.fPart.getSite().getShell();
        }
        return Display.getDefault().getActiveShell();
    }
}

