/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.query.IAssociation;
import com.ibm.team.workitem.common.query.IAssociations;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DuplicateQueryAction
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        final Object object = this.fSelection.getFirstElement();
        new UIUpdaterJob(Messages.DuplicateQueryAction_DUPLICATING_QUERY){
            IQueryDescriptor fQueryDescriptor;

            public IStatus runInBackground(IProgressMonitor monitor) {
                if (object instanceof IQueryDescriptorHandle) {
                    try {
                        IQueryDescriptorHandle handle = (IQueryDescriptorHandle)object;
                        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                        IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                        this.fQueryDescriptor = (IQueryDescriptor)auditableClient.fetchCurrentAuditable((IAuditableHandle)handle, IQueryDescriptor.FULL_PROFILE, null);
                    }
                    catch (TeamRepositoryException e) {
                        this.fQueryDescriptor = null;
                        WorkItemRCPUIPlugin.getDefault().log("Loading query failed", e);
                    }
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fQueryDescriptor != null) {
                    ITeamRepository repository = (ITeamRepository)this.fQueryDescriptor.getOrigin();
                    IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
                    String name = NLS.bind((String)Messages.DuplicateQueryAction_PATTERN_DUPLICATED_QUERY_NAME, (Object)this.fQueryDescriptor.getName(), (Object[])new Object[0]);
                    IQueryDescriptor descriptor = queryClient.createQuery(this.fQueryDescriptor.getProjectArea(), this.fQueryDescriptor.getQueryType(), name, this.fQueryDescriptor.getExpression());
                    List sharing = this.fQueryDescriptor.getAssociations().getPublicContents();
                    if (!sharing.isEmpty() && MessageDialog.openQuestion((Shell)DuplicateQueryAction.this.fWorkbenchPart.getSite().getShell(), (String)Messages.DuplicateQueryAction_COPY_SHARING, (String)Messages.DuplicateQueryAction_COPY_SHARING_CONFIRMATION)) {
                        IAssociations copiedAssociations = descriptor.getAssociations();
                        for (IAssociation association : sharing) {
                            IAssociation copied = copiedAssociations.createAssociation(association.getTarget());
                            copiedAssociations.associate(copied);
                        }
                    }
                    QueriesUI.editQuery(DuplicateQueryAction.this.fWorkbenchPart.getSite().getPage(), (IQueryDescriptorHandle)descriptor);
                }
                return super.runInUI(monitor);
            }
        }.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }
}

