/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IQueryClient;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteQueryAction
extends Action
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public DeleteQueryAction(IWorkbenchPart part, IStructuredSelection selection) {
        this.fWorkbenchPart = part;
        this.fSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        ArrayList<IQueryDescriptorHandle> handles = new ArrayList<IQueryDescriptorHandle>(this.fSelection.size());
        for (Object object : this.fSelection) {
            if (!(object instanceof IQueryDescriptorHandle)) continue;
            handles.add((IQueryDescriptorHandle)object);
        }
        if (!handles.isEmpty()) {
            String message = handles.size() == 1 ? Messages.DeleteQueryAction_CONFIRM_DELETE_ONE : NLS.bind((String)Messages.DeleteQueryAction_CONFIRM_DELETE_MANY, (Object)handles.size(), (Object[])new Object[0]);
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.DeleteQueryAction_CONFIRM_DELETE_TITLE, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (dialog.open() == 0) {
                this.deleteQueries(handles);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
        action.setEnabled(DeleteQueryAction.getEnabledState(this.fSelection));
    }

    public static boolean getEnabledState(IStructuredSelection selection) {
        return true;
    }

    private void deleteQueries(final Collection<IQueryDescriptorHandle> queries) {
        FoundationJob job = new FoundationJob(Messages.DeleteQueryAction_DELETING_QUERIES){

            protected IStatus runProtected(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.DeleteQueryAction_DELETING_QUERIES, queries.size());
                    for (IQueryDescriptorHandle handle : queries) {
                        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                        IQueryClient queryClient = (IQueryClient)repository.getClientLibrary(IQueryClient.class);
                        queryClient.delete(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamOperationCanceledException teamOperationCanceledException) {
                    IStatus iStatus = DeleteQueryAction.this.showPermissionDeniedMessage();
                    return iStatus;
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    IStatus iStatus = DeleteQueryAction.this.showPermissionDeniedMessage();
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages.DeleteQueryAction_DELETING_FAILED, (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.fWorkbenchPart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (service != null) {
            service.schedule((Job)job, 0L, true);
        } else {
            job.schedule();
        }
    }

    private Shell getShell() {
        return this.fWorkbenchPart.getSite().getShell();
    }

    private IStatus showPermissionDeniedMessage() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)DeleteQueryAction.this.getShell(), (String)Messages.DeleteQueryAction_DELETE_QUERY_PERMISSION_TITLE, (String)Messages.DeleteQueryAction_DELETE_QUERY_PERMISSION_DESCRIPTION);
            }
        });
        return Status.OK_STATUS;
    }
}

