/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.foundation.common.IFeedConstants;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.feed.UserFeedbackNewsManagerListener;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class CreateUserFeedAction
implements IObjectActionDelegate {
    private static final String DFLT_ENCODING = "UTF-8";
    private static final String FEED_SERVICE = IFeedConstants.SERVICE_NAME;
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        Object object = this.fSelection.getFirstElement();
        if (object instanceof IContributorHandle) {
            IContributor contributor;
            final IContributorHandle contributorHandle = (IContributorHandle)object;
            final ITeamRepository repo = (ITeamRepository)contributorHandle.getOrigin();
            if (contributorHandle.hasFullState()) {
                contributor = (IContributor)contributorHandle.getFullState();
            } else {
                contributor = (IContributor)repo.itemManager().getSharedItemIfKnown((IItemHandle)contributorHandle);
                if (contributor == null) {
                    if (repo.loggedIn()) {
                        new UIUpdaterJob(Messages.CreateUserFeedAction_RESOLVING){
                            IContributor fContributor;
                            TeamRepositoryException fException;

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.fContributor = (IContributor)repo.itemManager().fetchCompleteItem((IItemHandle)contributorHandle, 0, monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    this.fException = e;
                                }
                                return super.runInBackground(monitor);
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                if (this.fContributor != null) {
                                    CreateUserFeedAction.this.createChannel(this.fContributor, repo);
                                }
                                if (this.fException != null) {
                                    String description = NLS.bind((String)Messages.CreateUserFeedAction_ERROR_CREATING_SUBSCRIPTION_DESCRIPTION, (Object)this.fException.getLocalizedMessage(), (Object[])new Object[0]);
                                    MessageDialog.openError((Shell)CreateUserFeedAction.this.getSite().getShell(), (String)Messages.CreateUserFeedAction_ERROR_CREATING_SUBSCRIPTION_TITLE, (String)description);
                                }
                                return super.runInUI(monitor);
                            }
                        }.schedule();
                        return;
                    }
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CreateUserFeedAction_COULD_NOT_CREATE_SUBSCRIPTION_TITLE, (String)Messages.CreateUserFeedAction_COULD_NOT_CREATE_SUBSCRIPTION_DESCRIPTION);
                    return;
                }
            }
            this.createChannel(contributor, repo);
        }
    }

    private void createChannel(IContributor contributor, ITeamRepository repo) {
        FeedManager newsMgr = FeedManager.getDefault();
        String url = null;
        try {
            url = this.buildURL(repo, contributor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.CreateUserFeedAction_ERROR_CONSTRUCTING_SUBSCRIPTION_URL);
            WorkItemRCPUIPlugin.getDefault().log("Error Constructing Subscription URL", e);
            return;
        }
        this.createChannel(contributor, newsMgr, url);
    }

    protected void createChannel(IContributor contributor, FeedManager newsMgr, String url) {
        if (newsMgr.getChannel(url) != null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CreateUserFeedAction_SUBSCRIPTION_EXISTS_TITLE, (String)Messages.CreateUserFeedAction_SUBSCRIPTION_EXISTS_DESCRIPTION);
            return;
        }
        String format = this.escape(Messages.CreateUserFeedAction_CHANNEL_DESCRIPTION);
        String description = NLS.bind((String)format, (Object)("<i>" + this.escape(contributor.getName()) + "</i>"), (Object[])new Object[0]);
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(Messages.CreateUserFeedAction_LOADING);
        channel.setDescription(description);
        channel.setForceDownload(true);
        channel.setUpdateInterval(10);
        channel.setItemLimit(1000);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        this.notifySuccess(channel);
    }

    protected IWorkbenchPartSite getSite() {
        return this.fWorkbenchPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    private String buildURL(ITeamRepository repo, IContributor contributor) throws UnsupportedEncodingException, URISyntaxException {
        StringBuffer url = new StringBuffer();
        String repositoryURI = com.ibm.team.workitem.common.internal.util.Utils.getHttpRepositoryUrl((String)repo.getRepositoryURI());
        url.append(com.ibm.team.workitem.common.internal.util.Utils.getBaseURI((URI)new URI(repositoryURI)));
        url.append("service/");
        url.append(FEED_SERVICE);
        url.append("?provider=usermodified");
        url.append("&user=");
        url.append(URLEncoder.encode(contributor.getUserId(), DFLT_ENCODING));
        return url.toString();
    }

    private void notifySuccess(Channel channel) {
        FeedManager newsMgr = FeedManager.getDefault();
        new UserFeedbackNewsManagerListener(this.fWorkbenchPart, channel);
        newsMgr.addChannel(channel);
        channel.setExplicitRefresh(true);
        newsMgr.loadNews(channel);
    }

    private String escape(String string) {
        return Utils.escapeToHTML(string);
    }
}

