/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.foundation.common.IFeedConstants;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.ProcessAreaSelectionDialog;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.feed.UserFeedbackNewsManagerListener;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class CreateTeamFeedAction
implements IObjectActionDelegate {
    private static final String DFLT_ENCODING = "UTF-8";
    private static final String FEED_SERVICE = IFeedConstants.SERVICE_NAME;
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    public void run(IAction action) {
        Object object = this.fSelection.getFirstElement();
        boolean isChosenFromDialog = false;
        if (object == FeedManager.getDefault()) {
            isChosenFromDialog = true;
            ProcessAreaSelectionDialog dialog = new ProcessAreaSelectionDialog(this.getShellProvider().getShell(), false);
            dialog.setInput((Object)ConnectedProjectAreaRegistry.getDefault());
            if (dialog.open() == 0) {
                IProcessArea selectedProcessArea = dialog.getSelectedProcessArea();
                object = selectedProcessArea;
            } else {
                return;
            }
        }
        if (object instanceof IProcessAreaHandle) {
            IProcessArea processArea;
            final IProcessAreaHandle procesAreaHandle = (IProcessAreaHandle)object;
            final ITeamRepository repo = (ITeamRepository)procesAreaHandle.getOrigin();
            if (procesAreaHandle.hasFullState()) {
                processArea = (IProcessArea)procesAreaHandle.getFullState();
            } else {
                processArea = (IProcessArea)repo.itemManager().getSharedItemIfKnown((IItemHandle)procesAreaHandle);
                if (processArea == null) {
                    if (repo.loggedIn()) {
                        new UIUpdaterJob(Messages.CreateTeamFeedAction_RESOLVING){
                            IProcessArea fProcessArea;
                            TeamRepositoryException fException;

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.fProcessArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)procesAreaHandle, 0, monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    this.fException = e;
                                }
                                return super.runInBackground(monitor);
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                if (this.fProcessArea != null) {
                                    CreateTeamFeedAction.this.createChannel(this.fProcessArea, repo);
                                }
                                if (this.fException != null) {
                                    String message = NLS.bind((String)Messages.CreateTeamFeedAction_ERROR_CREATING_SUBSCRIPTION_DESCRIPTION, (Object)this.fException.getLocalizedMessage(), (Object[])new Object[0]);
                                    MessageDialog.openError((Shell)CreateTeamFeedAction.this.getShellProvider().getShell(), (String)Messages.CreateTeamFeedAction_ERROR_CREATING_SUBSCRIPTION_TITLE, (String)message);
                                }
                                return super.runInUI(monitor);
                            }
                        }.schedule();
                        return;
                    }
                    MessageDialog.openError((Shell)this.getShellProvider().getShell(), (String)Messages.CreateTeamFeedAction_COULD_NOT_CREATE_SUBSCRIPTION_TITLE, (String)Messages.CreateTeamFeedAction_COULD_NOT_CREATE_SUBSCRIPTION_DESCRIPTION);
                    return;
                }
            }
            boolean success = this.createChannel(processArea, repo);
            if (!success && isChosenFromDialog) {
                this.run(action);
            }
        }
    }

    private boolean createChannel(IProcessArea processArea, ITeamRepository repo) {
        FeedManager newsMgr = FeedManager.getDefault();
        String url = null;
        try {
            url = this.buildURL(repo, processArea);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShellProvider().getShell(), null, (String)Messages.CreateTeamFeedAction_ERROR_CREATING_SUBSCRIPTION);
            WorkItemRCPUIPlugin.getDefault().log("Error Constructing Subscription URL", e);
            return false;
        }
        return this.createChannel(processArea, newsMgr, url);
    }

    protected boolean createChannel(IProcessArea processArea, FeedManager newsMgr, String url) {
        if (newsMgr.getChannel(url) != null) {
            MessageDialog.openError((Shell)this.getShellProvider().getShell(), (String)Messages.CreateTeamFeedAction_SUBSCRIPTION_EXISTS_TITLE, (String)Messages.CreateTeamFeedAction_SUBSCRIPTION_EXISTS_DESCRIPTION);
            return false;
        }
        String format = processArea instanceof ITeamArea ? this.escape(Messages.CreateTeamFeedAction_CHANNEL_DESCRIPTION_TA) : this.escape(Messages.CreateTeamFeedAction_CHANNEL_DESCRIPTION_PA);
        String description = NLS.bind((String)format, (Object)("<i>" + this.escape(processArea.getName()) + "</i>"), (Object[])new Object[0]);
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(this.getTitle(processArea, newsMgr));
        channel.setDescription(description);
        channel.setForceDownload(true);
        channel.setUpdateInterval(10);
        channel.setItemLimit(1000);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        this.notifySuccess(channel);
        return true;
    }

    protected IWorkbenchPartSite getSite() {
        return this.fWorkbenchPart != null ? this.fWorkbenchPart.getSite() : null;
    }

    protected IShellProvider getShellProvider() {
        if (this.fWorkbenchPart != null) {
            return this.fWorkbenchPart.getSite();
        }
        return FoundationUIUtils.getShellProvider();
    }

    private String getTitle(IProcessArea processArea, FeedManager mgr) {
        String inittitle;
        String title = inittitle = NLS.bind((String)Messages.CreateTeamFeedAction_PATTERN_TITLE, (Object)processArea.getName(), (Object[])new Object[0]);
        boolean ok = false;
        int tries = 0;
        while (!ok) {
            if (tries > 0) {
                title = NLS.bind((String)Messages.CreateTeamFeedAction_PATTERN_UNIQUE_TITLE, (Object)inittitle, (Object[])new Object[]{tries});
            }
            ++tries;
            Channel[] channels = mgr.getChannels();
            ok = true;
            Channel[] channelArray = channels;
            int n = channels.length;
            int n2 = 0;
            while (n2 < n) {
                Channel channel = channelArray[n2];
                if (channel.getTitle().equals(title)) {
                    ok = false;
                }
                ++n2;
            }
        }
        return title;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    private String buildURL(ITeamRepository repo, IProcessArea processArea) throws UnsupportedEncodingException, URISyntaxException {
        StringBuffer url = new StringBuffer();
        String repositoryURI = com.ibm.team.workitem.common.internal.util.Utils.getHttpRepositoryUrl((String)repo.getRepositoryURI());
        url.append(com.ibm.team.workitem.common.internal.util.Utils.getBaseURI((URI)new URI(repositoryURI)));
        url.append("service/");
        url.append(FEED_SERVICE);
        if (processArea instanceof ITeamArea) {
            url.append("?provider=team&team_area=");
        } else {
            url.append("?provider=team&project_area=");
            url.append(URLEncoder.encode(processArea.getName(), DFLT_ENCODING));
            url.append("&project_area_id=");
        }
        url.append(processArea.getItemId().getUuidValue());
        url.append("&user=");
        url.append("{$user}");
        return url.toString();
    }

    private void notifySuccess(Channel channel) {
        FeedManager newsMgr = FeedManager.getDefault();
        new UserFeedbackNewsManagerListener(this.fWorkbenchPart, channel);
        newsMgr.addChannel(channel);
        channel.setExplicitRefresh(true);
        newsMgr.loadNews(channel);
    }

    private String escape(String string) {
        return Utils.escapeToHTML(string);
    }
}

