/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.actions.AbstractChangeWorkItemAttributeAction;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.attribute.AttributeLabelProviderFactory;
import com.ibm.team.workitem.rcp.ui.internal.attribute.IAttributeLabelProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class AttributeValueSetDropDownAction {
    private final IAttribute fAttribute;
    private final ISelectionProvider fSelectionProvider;
    private MenuManager fMenuManager;
    private final String fName;

    public AttributeValueSetDropDownAction(String name, IAttribute attribute, ISelectionProvider provider) {
        Assert.isNotNull((Object)attribute);
        Assert.isNotNull((Object)provider);
        this.fName = name;
        this.fAttribute = attribute;
        this.fSelectionProvider = provider;
    }

    private void populateMenuEntries() {
        final IWorkItem workItem = this.getWorkItem();
        if (workItem == null) {
            this.createInfoItem(Messages.AttributeValueSetDropDownAction_NO_VALUES);
            return;
        }
        this.createInfoItem(Messages.AttributeValueSetDropDownAction_LOADING);
        UIUpdaterJob job = new UIUpdaterJob(Messages.AttributeValueSetDropDownAction_RESOLVING_VALUES){
            private Object[] fValues;
            {
                super($anonymous0);
                this.fValues = null;
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)workItem, IAuditableClient.class);
                try {
                    this.fValues = AttributeValueSetDropDownAction.this.fAttribute.getValueSet((IAuditableCommon)auditableClient, workItem, monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.AttributeValueSetDropDownAction_ERROR_WHILE_RESOLVING, (Throwable)e);
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                AttributeValueSetDropDownAction.this.createMenuActions(this.fValues);
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    private void createMenuActions(Object[] values) {
        if (this.isDisposed()) {
            return;
        }
        this.fMenuManager.removeAll();
        if (values == null || values.length == 0) {
            this.createInfoItem(Messages.AttributeValueSetDropDownAction_NO_VALUES);
            return;
        }
        IAttributeLabelProvider labelProvider = AttributeLabelProviderFactory.createLabelProvider(this.fAttribute);
        try {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                IAction action = this.createAction(value);
                action.setText(labelProvider.getText(value));
                Image image = labelProvider.getImage(value);
                if (image != null) {
                    action.setImageDescriptor(ImageDescriptor.createFromImageData((ImageData)image.getImageData()));
                }
                this.fMenuManager.add(action);
                ++n2;
            }
            this.fMenuManager.update(true);
        }
        finally {
            labelProvider.dispose();
        }
    }

    protected IAction createAction(Object value) {
        return new ChangeWorkItemAttributeAction(this.fAttribute, value, this.fSelectionProvider);
    }

    private void createInfoItem(String label) {
        Action info = new Action(label){};
        info.setEnabled(false);
        this.fMenuManager.add((IAction)info);
        this.fMenuManager.update(true);
    }

    private boolean isDisposed() {
        return this.fMenuManager == null || this.fMenuManager.getMenu() == null || this.fMenuManager.getMenu().isDisposed();
    }

    private IWorkItem getWorkItem() {
        Object firstElement;
        ISelection selection = this.fSelectionProvider.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IWorkItem) {
            return (IWorkItem)firstElement;
        }
        return null;
    }

    public IContributionItem getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new MenuManager(this.fName);
            this.fMenuManager.setRemoveAllWhenShown(true);
            this.createInfoItem(Messages.AttributeValueSetDropDownAction_LOADING);
            this.fMenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    AttributeValueSetDropDownAction.this.populateMenuEntries();
                }
            });
        }
        return this.fMenuManager;
    }

    private static class ChangeWorkItemAttributeAction
    extends AbstractChangeWorkItemAttributeAction {
        private Object fValue;

        public ChangeWorkItemAttributeAction(IAttribute attribute, Object value, ISelectionProvider provider) {
            super(attribute, provider);
            this.fValue = value;
        }

        protected Object getValue() {
            return this.fValue;
        }
    }
}

