/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IFeedService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import com.ibm.team.workitem.rcp.ui.internal.feed.UserFeedbackNewsManagerListener;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class AddQueryToSubscriptionsAction
implements IObjectActionDelegate {
    private static final String DFLT_ENCODING = "UTF-8";
    private static final String FEED_SERVICE = IFeedService.SERVICE_NAME;
    private IStructuredSelection fSelection;
    private IWorkbenchPart fWorkbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.fWorkbenchPart;
    }

    public void run(IAction action) {
        Object object = this.fSelection.getFirstElement();
        if (object instanceof IQueryDescriptorHandle) {
            IQueryDescriptor query;
            final IQueryDescriptorHandle queryhandle = (IQueryDescriptorHandle)object;
            final ITeamRepository repo = (ITeamRepository)queryhandle.getOrigin();
            if (queryhandle.hasFullState()) {
                query = (IQueryDescriptor)queryhandle.getFullState();
            } else {
                query = (IQueryDescriptor)repo.itemManager().getSharedItemIfKnown((IItemHandle)queryhandle);
                if (query == null) {
                    if (repo.loggedIn()) {
                        new UIUpdaterJob(Messages.AddQueryToSubscriptionsAction_RESOLVING){
                            IQueryDescriptor fQuery;
                            TeamRepositoryException fException;

                            public IStatus runInBackground(IProgressMonitor monitor) {
                                try {
                                    this.fQuery = (IQueryDescriptor)repo.itemManager().fetchCompleteItem((IItemHandle)queryhandle, 0, monitor);
                                }
                                catch (TeamRepositoryException e) {
                                    this.fException = e;
                                }
                                return super.runInBackground(monitor);
                            }

                            public IStatus runInUI(IProgressMonitor monitor) {
                                if (this.fQuery != null) {
                                    AddQueryToSubscriptionsAction.this.createChannel(this.fQuery, repo);
                                }
                                if (this.fException != null) {
                                    String details = NLS.bind((String)Messages.AddQueryToSubscriptionsAction_ERROR_CREATING_SUBSCRIPTION_DETAILS, (Object)this.fException.getLocalizedMessage(), (Object[])new Object[0]);
                                    MessageDialog.openError((Shell)AddQueryToSubscriptionsAction.this.getWorkbenchPart().getSite().getShell(), (String)Messages.AddQueryToSubscriptionsAction_ERROR_CREATING_SUBSCRIPTION, (String)details);
                                }
                                return super.runInUI(monitor);
                            }
                        }.schedule();
                        return;
                    }
                    MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.AddQueryToSubscriptionsAction_COULD_NOT_CREATE_SUBSCRIPTION, (String)Messages.AddQueryToSubscriptionsAction_REASON_NOT_LOGGED_IN);
                    return;
                }
            }
            this.createChannel(query, repo);
        }
    }

    protected void createChannel(IQueryDescriptor query, ITeamRepository repo) {
        FeedManager newsMgr = FeedManager.getDefault();
        String url = null;
        try {
            url = this.buildURL(repo, query);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), null, (String)Messages.AddQueryToSubscriptionsAction_ERROR_CONSTRUCTING_URL);
            WorkItemRCPUIPlugin.getDefault().log("Error Constructing Subscription URL", e);
            return;
        }
        if (newsMgr.getChannel(url) != null) {
            MessageDialog.openError((Shell)this.fWorkbenchPart.getSite().getShell(), (String)Messages.AddQueryToSubscriptionsAction_SUBSCRIPTION_EXISTS_TITLE, (String)Messages.AddQueryToSubscriptionsAction_SUBSCRIPTION_EXISTS_DETAILS);
            return;
        }
        String format = this.escape(Messages.AddQueryToSubscriptionsAction_PATTERN_CHANNEL_TITLE);
        String description = NLS.bind((String)format, (Object)("<i>" + this.escape(query.getName()) + "</i>"), (Object[])new Object[0]);
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(Messages.AddQueryToSubscriptionsAction_LOADING);
        channel.setDescription(description);
        channel.setForceDownload(true);
        channel.setUpdateInterval(10);
        channel.setItemLimit(1000);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        new UserFeedbackNewsManagerListener(this.getWorkbenchPart(), channel);
        newsMgr.addChannel(channel);
        channel.setExplicitRefresh(true);
        newsMgr.loadNews(channel);
    }

    private String escape(String string) {
        return Utils.escapeToHTML(string);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    protected String buildURL(ITeamRepository repo, IQueryDescriptor query) throws UnsupportedEncodingException, URISyntaxException {
        StringBuffer url = new StringBuffer();
        String repositoryURI = com.ibm.team.workitem.common.internal.util.Utils.getHttpRepositoryUrl((String)repo.getRepositoryURI());
        url.append(com.ibm.team.workitem.common.internal.util.Utils.getBaseURI((URI)new URI(repositoryURI)));
        url.append("service/");
        url.append(FEED_SERVICE);
        url.append("?provider=query&user=");
        url.append(URLEncoder.encode(repo.loggedInContributor().getUserId(), DFLT_ENCODING));
        url.append("&query=");
        url.append(query.getItemId().getUuidValue());
        return url.toString();
    }
}

