/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal.actions;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.internal.actions.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShowWorkAction
implements IObjectActionDelegate {
    private IWorkbenchPart fTargetPart;
    private IStructuredSelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fTargetPart = targetPart;
    }

    public void run(IAction action) {
        if (!this.getSelectedContributors().isEmpty()) {
            CreateExpressionJob job = new CreateExpressionJob();
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
        }
    }

    protected ITeamRepository getTeamRepository() {
        List<IContributorHandle> contributors = this.getSelectedContributors();
        return (ITeamRepository)(contributors.isEmpty() ? null : contributors.get(0).getOrigin());
    }

    protected IAuditableClient getAuditableClient() {
        ITeamRepository repository = this.getTeamRepository();
        if (repository != null) {
            return (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
        }
        return null;
    }

    protected List<IContributorHandle> getSelectedContributors() {
        ArrayList<IContributorHandle> contributors = new ArrayList<IContributorHandle>();
        if (this.fSelection != null) {
            ITeamRepository repository = null;
            for (Object next : this.fSelection) {
                if (!(next instanceof IContributorHandle)) continue;
                IContributorHandle contributor = (IContributorHandle)next;
                if (repository == null) {
                    repository = (ITeamRepository)contributor.getOrigin();
                }
                if (!repository.equals(contributor.getOrigin())) continue;
                contributors.add(contributor);
            }
        }
        return contributors;
    }

    protected String getNameList(IProgressMonitor monitor) throws TeamRepositoryException {
        String nameList = "";
        List contributors = this.getAuditableClient().resolveAuditables(this.getSelectedContributors(), ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
        for (IContributor contributor : contributors) {
            if (contributor == null) continue;
            nameList = nameList.length() == 0 ? contributor.getName() : NLS.bind((String)Messages.AbstractShowWorkAction_USER_NAME_LIST, (Object)nameList, (Object[])new Object[]{contributor.getName()});
        }
        return nameList;
    }

    protected IProjectAreaHandle getDefaultProjectArea(IAuditableClient auditableClient, IProgressMonitor monitor) throws TeamRepositoryException {
        return QueryUtils.findSomeProjectArea((IAuditableCommon)auditableClient, (IProgressMonitor)monitor);
    }

    protected abstract void initialize(IProgressMonitor var1) throws TeamRepositoryException;

    protected abstract Expression getExpression();

    protected abstract String getLabel();

    private class CreateExpressionJob
    extends UIUpdaterJob {
        public CreateExpressionJob() {
            super(Messages.AbstractShowWorkAction_CREATING_EXPRESSION_JOB_NAME);
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                AbstractShowWorkAction.this.initialize(monitor);
                return super.runInBackground(monitor);
            }
            catch (TeamRepositoryException e) {
                return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.AbstractShowWorkAction_ERROR_CREATING_EXPRESSION, (Throwable)e);
            }
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            QueriesUI.showQueryResults(AbstractShowWorkAction.this.fTargetPart.getSite().getWorkbenchWindow(), AbstractShowWorkAction.this.getTeamRepository(), AbstractShowWorkAction.this.getLabel(), AbstractShowWorkAction.this.getExpression());
            return super.runInUI(monitor);
        }
    }
}

