/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import com.ibm.team.workitem.rcp.core.activation.IWorkItemActivationManager;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ActivationTrackerFactory;
import com.ibm.team.workitem.rcp.ui.internal.ConnectedProjectAreas;
import com.ibm.team.workitem.rcp.ui.internal.LinkDetectorConnectionManager;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ReadStateTrackerFactory;
import com.ibm.team.workitem.rcp.ui.internal.SubjectRelationshipTrackerFactory;
import com.ibm.team.workitem.rcp.ui.internal.activation.WorkItemWorkflowParticipant;
import com.ibm.team.workitem.rcp.ui.internal.feed.FeedsMigration;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WorkItemRCPUIPlugin
extends AbstractUIPlugin {
    private static final String QUICK_SEARCH_TRIM_GROUP = "com.ibm.team.workitem.rcp.ui.SearchBarGroup";
    private static final String REUSE_WORKITEM_EDITOR_PREF = "com.ibm.team.workitem.rcp.ui.reuseWorkItemEditor";
    public static final String PLUGIN_ID = "com.ibm.team.workitem.rcp.ui";
    public static final ISchedulingRule REFRESH_RULE = new ExclusiveSchedulingRule();
    private static final String ARTIFACT_NAVIGATOR = "com.ibm.team.process.rcp.ui.teamArtifactsNavigator";
    private static WorkItemRCPUIPlugin fgPlugin;
    private ResourceManager fResourceManager;
    private ResourceBundle fResourceBundle;
    private InternalUpdaterJob fUpdaterJob;
    private FeedsMigration fFeedsMigration;
    private final WorkItemWorkflowParticipant fWorkflowParticipant = new WorkItemWorkflowParticipant();
    private LinkDetectorConnectionManager fLinkDetectorConnectionManager;

    public WorkItemRCPUIPlugin() {
        fgPlugin = this;
        try {
            this.fResourceBundle = ResourceBundle.getBundle("com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.fResourceBundle = null;
        }
    }

    public static WorkItemRCPUIPlugin getDefault() {
        return fgPlugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!Utils.PLUGIN_TEST) {
            IAdapterManager manager = Platform.getAdapterManager();
            Object factory = new ReadStateTrackerFactory();
            manager.registerAdapters((IAdapterFactory)factory, IWorkItemHandle.class);
            manager.registerAdapters((IAdapterFactory)factory, IReference.class);
            factory = new ActivationTrackerFactory();
            manager.registerAdapters((IAdapterFactory)factory, IWorkItemHandle.class);
            manager.registerAdapters((IAdapterFactory)factory, IReference.class);
            factory = new SubjectRelationshipTrackerFactory();
            manager.registerAdapters((IAdapterFactory)factory, IWorkItemHandle.class);
            manager.registerAdapters((IAdapterFactory)factory, IReference.class);
        }
        this.fUpdaterJob = new InternalUpdaterJob();
        this.fUpdaterJob.start();
        this.fFeedsMigration = new FeedsMigration();
        this.fFeedsMigration.start();
        FoundationJob activationJob = new FoundationJob(Messages.WorkItemRCPUIPlugin_ACTIVATING_PLUGIN){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ITeamRepository[] repositories;
                IWorkItemActivationManager manager = ClientModel.getWorkItemActivationManager();
                manager.addActivationParticipant((WorkItemActivationParticipant)WorkItemRCPUIPlugin.this.fWorkflowParticipant);
                ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
                service.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)WorkItemRCPUIPlugin.this.fWorkflowParticipant);
                ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository repository = iTeamRepositoryArray[n2];
                    IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                    if (client != null) {
                        client.addWorkItemListener((IWorkItemListener)WorkItemRCPUIPlugin.this.fWorkflowParticipant);
                    }
                    ++n2;
                }
                WorkItemRCPUIPlugin.this.fLinkDetectorConnectionManager = new LinkDetectorConnectionManager();
                return Status.OK_STATUS;
            }
        };
        activationJob.setSystem(true);
        activationJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        ITeamRepository[] repositories;
        if (this.fLinkDetectorConnectionManager != null) {
            this.fLinkDetectorConnectionManager.dispose();
        }
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fWorkflowParticipant);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            IWorkItemClient client = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
            if (client != null) {
                client.removeWorkItemListener((IWorkItemListener)this.fWorkflowParticipant);
            }
            ++n2;
        }
        IWorkItemActivationManager manager = ClientModel.getWorkItemActivationManager();
        manager.removeActivationParticipant((WorkItemActivationParticipant)this.fWorkflowParticipant);
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        if (this.fUpdaterJob != null) {
            this.fUpdaterJob.cancel();
            this.fUpdaterJob = null;
        }
        this.fFeedsMigration.stop();
        ConnectedProjectAreas.saveState();
        super.stop(context);
        fgPlugin = null;
    }

    public boolean getQuickSearchTrimVisibilityPreference() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault(QUICK_SEARCH_TRIM_GROUP, true);
        return preferenceStore.getBoolean(QUICK_SEARCH_TRIM_GROUP);
    }

    public void setQuickSearchTrimVisibilityPreference(boolean visible) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue(QUICK_SEARCH_TRIM_GROUP, visible);
    }

    public void updateQuickSearchTrimVisibility() {
        boolean visible = this.getQuickSearchTrimVisibilityPreference();
        this.setQuickSearchTrimVisibility(visible);
    }

    public void setQuickSearchTrimVisibility(IWorkbenchWindow window, boolean visible) {
        IWindowTrim trim;
        ITrimManager manager;
        if (window instanceof WorkbenchWindow && (manager = ((WorkbenchWindow)window).getTrimManager()) != null && (trim = manager.getTrim(QUICK_SEARCH_TRIM_GROUP)) != null) {
            manager.setTrimVisible(trim, visible);
            trim.getControl().getParent().layout(true);
        }
    }

    public void setQuickSearchTrimVisibility(boolean visible) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.setQuickSearchTrimVisibility(window, visible);
            ++n2;
        }
    }

    public boolean getReuseWorkItemEditorPref() {
        this.getPreferenceStore().setDefault(REUSE_WORKITEM_EDITOR_PREF, true);
        return this.getPreferenceStore().getBoolean(REUSE_WORKITEM_EDITOR_PREF);
    }

    public void setReuseWorkItemEditorPref(boolean reuse) {
        this.getPreferenceStore().setValue(REUSE_WORKITEM_EDITOR_PREF, reuse);
    }

    @Deprecated
    public static void showWorkItems(IWorkbenchWindow window, String title, IWorkItemHandle[] workItems) {
        WorkItemUI.showWorkItems(window, title, workItems);
    }

    @Deprecated
    public static void openArtifactNavigator(IWorkbenchWindow window, ISelection selection) {
        try {
            IViewPart view = window.getActivePage().showView(ARTIFACT_NAVIGATOR);
            ISelectionProvider provider = view.getSite().getSelectionProvider();
            if (provider != null) {
                provider.setSelection(selection);
            }
        }
        catch (PartInitException e) {
            WorkItemRCPUIPlugin.getDefault().log("can't open artifact navigator", e);
        }
    }

    @Deprecated
    public static Image getImage(ImageDescriptor imageDesc) {
        return JazzResources.getImageWithDefault((ResourceManager)WorkItemRCPUIPlugin.getDefault().getResourceManager(), (ImageDescriptor)imageDesc);
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String pathRelativeToPlugin) {
        ImageDescriptor id = WorkItemRCPUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)pathRelativeToPlugin);
        JazzResources.registerPath((ImageDescriptor)id, (String)PLUGIN_ID, (String)pathRelativeToPlugin);
        return id;
    }

    public void log(String message, Throwable exception) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public static IStatus run(String name, IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException x) {
            return new Status(4, PLUGIN_ID, 4, NLS.bind((String)Messages.WorkItemRCPUIPlugin_EXCEPTION_EXECUTING, (Object)name, (Object[])new Object[0]), (Throwable)x);
        }
        catch (InterruptedException x) {
            return new Status(8, PLUGIN_ID, 8, NLS.bind((String)Messages.WorkItemRCPUIPlugin_INTERRUPTED_EXECUTING, (Object)name, (Object[])new Object[0]), (Throwable)x);
        }
        return Status.OK_STATUS;
    }

    public static IStatus runInBackground(final String name, final IRunnableWithProgress runnable, IProgressMonitor monitor) {
        if (Display.getCurrent() == null) {
            return WorkItemRCPUIPlugin.run(name, runnable, monitor);
        }
        FoundationJob job = new FoundationJob(name){

            public IStatus runProtected(IProgressMonitor monitor) {
                return WorkItemRCPUIPlugin.run(name, runnable, null);
            }
        };
        job.setSystem(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    public static IStatus runInUI(final String name, final IRunnableWithProgress runnable, IProgressMonitor monitor) {
        if (Display.getCurrent() != null) {
            return WorkItemRCPUIPlugin.run(name, runnable, monitor);
        }
        FoundationUIJob job = new FoundationUIJob(name){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                return WorkItemRCPUIPlugin.run(name, runnable, monitor);
            }
        };
        job.setSystem(true);
        job.schedule();
        return Status.OK_STATUS;
    }

    public static ITeamRepository selectTeamRepository(Shell parentShell) {
        ITeamRepository[] repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        ArrayList<ITeamRepository> loggedin = new ArrayList<ITeamRepository>();
        int i = 0;
        while (i < repos.length) {
            if (repos[i].loggedIn()) {
                loggedin.add(repos[i]);
            }
            ++i;
        }
        if (loggedin.size() > 0) {
            repos = loggedin.toArray(new ITeamRepository[loggedin.size()]);
        }
        if (repos.length > 1) {
            int returnCode;
            ListDialog dialog = new ListDialog(parentShell);
            dialog.setTitle(Messages.WorkItemRCPUIPlugin_SELECT_TEAM_REPOSITORY_TITLE);
            dialog.setLabelProvider((ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            dialog.setContentProvider(new IStructuredContentProvider(){
                private Object[] fInput;

                public Object[] getElements(Object inputElement) {
                    return this.fInput;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    this.fInput = (Object[])newInput;
                }
            });
            dialog.setInput((Object)repos);
            if (repos.length > 0) {
                dialog.setInitialSelections((Object[])new ITeamRepository[]{repos[0]});
            }
            if ((returnCode = dialog.open()) == 0 && dialog.getResult().length > 0) {
                Object[] result = dialog.getResult();
                if (result != null) {
                    return (ITeamRepository)result[0];
                }
                return null;
            }
        }
        if (repos.length == 1) {
            return repos[0];
        }
        return null;
    }

    public static IWebBrowser openInBrowser(URI input) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        String scheme = input.getScheme();
        boolean launchExternal = "mailto".equals(scheme);
        if (!launchExternal && browserSupport.isInternalWebBrowserAvailable()) {
            try {
                int style = 14;
                IWebBrowser browser = browserSupport.createBrowser(style, "com.ibm.team.feed.core.ui.displayNews", null, input.toString());
                browser.openURL(input.toURL());
                return browser;
            }
            catch (PartInitException e) {
                WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
            }
            catch (MalformedURLException e) {
                WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
            }
            return null;
        }
        try {
            IWebBrowser webBrowser = browserSupport.getExternalBrowser();
            webBrowser.openURL(input.toURL());
            return webBrowser;
        }
        catch (PartInitException partInitException) {
            Program.launch((String)input.toString());
        }
        catch (MalformedURLException e) {
            WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
        }
        return null;
    }

    public static String getWorkItemDescription(IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)workItemHandle.getOrigin();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItem wi = (IWorkItem)auditableClient.resolveAuditable((IAuditableHandle)workItemHandle, IWorkItem.SMALL_PROFILE, monitor);
        return WorkItemTextUtilities.getWorkItemText((IWorkItem)wi);
    }

    public static IWorkItemHandle getWorkItemHandle(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IWorkItemHandle) {
            return (IWorkItemHandle)object;
        }
        if (object instanceof WorkItemEditorHistoryEntry) {
            WorkItemEditorHistoryEntry entry = (WorkItemEditorHistoryEntry)object;
            return entry.getWorkItem();
        }
        if (object instanceof ResolvedWorkItem) {
            return ((ResolvedWorkItem)object).getWorkItem();
        }
        if (object instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)object;
            return (IWorkItemHandle)a.getAdapter(IWorkItemHandle.class);
        }
        IAdapterManager manager = Platform.getAdapterManager();
        return (IWorkItemHandle)manager.getAdapter(object, IWorkItemHandle.class);
    }

    public static boolean canOpenAsWorkItem(Object input) {
        return WorkItemRCPUIPlugin.getWorkItemHandle(input) != null;
    }

    private static class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }

    private class InternalUpdaterJob
    extends FoundationJob {
        private static final long UPDATE_INTERVAL = 600000L;

        public InternalUpdaterJob() {
            super(Messages.WorkItemRCPUIPlugin_REFRESHING_PROJECT_AREAS);
            this.setSystem(true);
            this.setPriority(30);
            this.setRule(REFRESH_RULE);
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            try {
                ITeamRepository[] teamRepositories;
                ITeamRepository[] iTeamRepositoryArray = teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
                int n = teamRepositories.length;
                int n2 = 0;
                while (n2 < n) {
                    ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                    if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                        IItemManager itemManager = teamRepository.itemManager();
                        ArrayList<IProjectAreaHandle> cached = new ArrayList<IProjectAreaHandle>();
                        List connected = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(teamRepository);
                        for (IProjectAreaHandle handle : connected) {
                            if (itemManager.getSharedItemIfKnown((IItemHandle)handle) == null) continue;
                            cached.add(handle);
                        }
                        if (!cached.isEmpty()) {
                            itemManager.fetchPartialItems(cached, 1, (Collection)Collections.EMPTY_LIST, monitor);
                        }
                    }
                    ++n2;
                }
                if (!monitor.isCanceled()) {
                    this.start();
                }
                return Status.OK_STATUS;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                if (!monitor.isCanceled()) {
                    this.start();
                }
                return Status.OK_STATUS;
            }
        }

        public void start() {
            this.schedule(600000L);
        }
    }
}

