/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.DimmedIconDescriptor;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.internal.util.ImageURLPool;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class WorkItemLabelProvider
extends TypeLabelProvider {
    public static final String[] REQUIRED_PROPERTIES = new String[]{IWorkItem.ID_PROPERTY, IWorkItem.SUMMARY_PROPERTY, IWorkItem.TYPE_PROPERTY, IWorkItem.STATE_PROPERTY, IWorkItem.TYPE_PROPERTY};
    Map<UUID, IWorkItem> fLabeledWorkItems = new HashMap<UUID, IWorkItem>();
    Map<UUID, IWorkItem> fWorkItemsBeingRefreshed = new HashMap<UUID, IWorkItem>();
    private IWorkItemHandle fActiveWorkItemHandle = null;
    private WorkItemActivationParticipant fActivationListener = new WorkItemActivationParticipant(){

        public IStatus handleActivationEvent(WorkItemActivationEvent event, IProgressMonitor monitor) {
            int type = event.getType();
            final IWorkItemHandle handle = event.getWorkItem();
            if (type == 0) {
                WorkItemLabelProvider.this.fActiveWorkItemHandle = handle;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelProvider.this, (Object)WorkItemLabelProvider.this.fActiveWorkItemHandle));
                    }
                });
            } else if (type == 1) {
                WorkItemLabelProvider.this.fActiveWorkItemHandle = null;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelProvider.this, (Object)handle));
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };
    private IWorkItemListener fWorkItemListener = new IWorkItemListener(){

        public void workItemAttributeChanged(final WorkItemChangeEvent event) {
            if (this.affectsLabel(event)) {
                FoundationUIJob job = new FoundationUIJob(Messages.WorkItemLabelProvider_HANDLING_WORK_ITEM_CHANGE){

                    public IStatus runProtectedInUI(IProgressMonitor monitor) {
                        WorkItemLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelProvider.this, (Object)event.getWorkItem()));
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        private boolean affectsLabel(WorkItemChangeEvent event) {
            if (!this.affectsCachedWis(event)) {
                return false;
            }
            int i = 0;
            while (i < REQUIRED_PROPERTIES.length) {
                if (event.affects(REQUIRED_PROPERTIES[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean affectsCachedWis(WorkItemChangeEvent event) {
            Map<UUID, IWorkItem> map = WorkItemLabelProvider.this.fLabeledWorkItems;
            synchronized (map) {
                return WorkItemLabelProvider.this.fLabeledWorkItems.containsKey(event.getWorkItem().getItemId());
            }
        }
    };

    public WorkItemLabelProvider() {
        ClientModel.getWorkItemActivationManager().addActivationParticipant(this.fActivationListener);
    }

    private String getText(IWorkItem workItem) {
        return WorkItemTextUtilities.getWorkItemText((IWorkItem)workItem);
    }

    private Image getImage(IWorkItem workitem) {
        if (!workitem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) || !workitem.isPropertySet(IWorkItem.TYPE_PROPERTY)) {
            return this.getImage(ImagePool.WORKITEM_TITLE);
        }
        if (workitem.getProjectArea() == null || workitem.getWorkItemType() == null) {
            return this.getImage(ImagePool.WORKITEM_TITLE);
        }
        ITeamRepository teamRepository = (ITeamRepository)workitem.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItemType workItemType = workItemClient.findCachedWorkItemType(workitem.getProjectArea(), workitem.getWorkItemType());
        ImageDescriptor desc = null;
        if (workItemType != null) {
            IWorkflowInfo wfi;
            URL url = null;
            if (workitem.sameItemId((IItemHandle)this.fActiveWorkItemHandle)) {
                url = workItemType.getIconURL();
                ImageDescriptor original = WorkItemUI.getImageDescriptor(url);
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.WORKITEM_CURRENT_OVR;
                desc = new OverlayIcon(original, imageDescriptorArray, 17408);
            } else if (workitem.isPropertySet(IWorkItem.WORKFLOW_SURROGATE_PROPERTY) && workitem.isPropertySet(IWorkItem.STATE_PROPERTY) && (wfi = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workitem)) != null) {
                int stateGroup = wfi.getStateGroup(workitem.getState2());
                switch (stateGroup) {
                    case 2: {
                        ImageDescriptor original;
                        url = workItemType.getDimmedIconURL();
                        if (url == null) {
                            url = workItemType.getIconURL();
                            ImageDescriptor undimmed = WorkItemUI.getImageDescriptor(url);
                            original = new DimmedIconDescriptor(undimmed);
                        } else {
                            original = WorkItemUI.getImageDescriptor(url);
                        }
                        ImageDescriptor overlay = WorkItemUI.getImageDescriptor(ImageURLPool.WORKITEM_COMPLETE_OVR);
                        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                        imageDescriptorArray[1] = overlay;
                        desc = new OverlayIcon(original, imageDescriptorArray, new Point(16, 16), 17408);
                        break;
                    }
                    case 4: {
                        url = workItemType.getIconURL();
                        ImageDescriptor original = WorkItemUI.getImageDescriptor(url);
                        ImageDescriptor overlay = WorkItemUI.getImageDescriptor(ImageURLPool.WORKITEM_IN_PROGRESS_OVR);
                        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                        imageDescriptorArray[1] = overlay;
                        desc = new OverlayIcon(original, imageDescriptorArray, 17408);
                    }
                }
            }
            if (desc == null) {
                url = workItemType.getIconURL();
                desc = WorkItemUI.getImageDescriptor(url);
            }
        } else {
            desc = ImagePool.WORKITEM_TITLE;
        }
        return this.getImage(desc);
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof IWorkItem) {
            IWorkItem workItem = (IWorkItem)element;
            this.registerListenerFor(workItem);
            if (!workItem.isPropertySet(IWorkItem.ID_PROPERTY) || !workItem.isPropertySet(IWorkItem.SUMMARY_PROPERTY)) {
                label.setText(Messages.WorkItemLabelProvider_RESOLVING);
                label.setImage(this.getImage(ImagePool.WORKITEM_TITLE));
                this.refresh(workItem);
                return;
            }
            label.setText(this.getText(workItem));
            label.setImage(this.getImage(workItem));
        }
    }

    private void refresh(final IWorkItem workItem) {
        if (this.fWorkItemsBeingRefreshed.containsKey(workItem.getItemId())) {
            return;
        }
        this.fWorkItemsBeingRefreshed.put(workItem.getItemId(), workItem);
        new UIUpdaterJob(Messages.WorkItemLabelProvider_RESOLVING_WORK_ITEM){
            TeamRepositoryException fEx;

            public IStatus runInBackground(IProgressMonitor monitor) {
                IWorkItemClient workItemClient = WorkItemLabelProvider.this.getTeamServicesForWorkItem(workItem);
                try {
                    workItemClient.resolveWorkItem((IWorkItemHandle)workItem.getItemHandle(), IWorkItem.SMALL_PROFILE, null);
                }
                catch (TeamRepositoryException e) {
                    this.fEx = e;
                }
                WorkItemLabelProvider.this.fWorkItemsBeingRefreshed.remove(workItem.getItemId());
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fEx == null) {
                    WorkItemLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelProvider.this, (Object)workItem));
                }
                return super.runInUI(monitor);
            }
        }.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ClientModel.getWorkItemActivationManager().removeActivationParticipant(this.fActivationListener);
        Map<UUID, IWorkItem> map = this.fLabeledWorkItems;
        synchronized (map) {
            for (IWorkItem wi : this.fLabeledWorkItems.values()) {
                IWorkItemClient workItemClient = this.getTeamServicesForWorkItem(wi);
                if (workItemClient == null) continue;
                workItemClient.removeWorkItemListener(this.fWorkItemListener);
            }
            this.fLabeledWorkItems.clear();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerFor(IWorkItem workitem) {
        if (this.fLabeledWorkItems.containsKey(workitem.getItemId())) {
            return;
        }
        IWorkItemClient workItemClient = this.getTeamServicesForWorkItem(workitem);
        if (workItemClient != null) {
            workItemClient.addWorkItemListener(this.fWorkItemListener);
        }
        Map<UUID, IWorkItem> map = this.fLabeledWorkItems;
        synchronized (map) {
            this.fLabeledWorkItems.put(workitem.getItemId(), workitem);
        }
    }

    private IWorkItemClient getTeamServicesForWorkItem(IWorkItem workitem) {
        Object origin = workitem.getOrigin();
        ITeamRepository teamRepository = origin instanceof ITeamRepository ? (ITeamRepository)origin : (ITeamRepository)workitem.getOrigin();
        return (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
    }
}

