/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class WorkItemLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static boolean fIsWin = "win32".equals(SWT.getPlatform());
    private static final ColorDescriptor NORMAL_COLOR = ColorDescriptor.createFrom((RGB)new RGB(0, 0, 0));
    private static final ColorDescriptor CLOSED_COLOR = ColorDescriptor.createFrom((RGB)new RGB(160, 160, 160));
    private static final ColorDescriptor MY_WORKITEMS_COLOR = ColorDescriptor.createFrom((RGB)new RGB(0, 0, 128));
    private static final ColorDescriptor MY_CURRENT_WORKITEM_COLOR = ColorDescriptor.createFrom((RGB)new RGB(6, 97, 240));
    private ResourceManager fResources;
    private final FontDescriptor fClosedFont;
    private boolean fUseReducedColors;
    private final TeamRepositoryLoginListener fRepositoryListener = new TeamRepositoryLoginListener();
    private IWorkItemHandle fActiveWorkItemHandle = null;
    private WorkItemActivationParticipant fActivationListener = new WorkItemActivationParticipant(){

        public IStatus handleActivationEvent(WorkItemActivationEvent event, IProgressMonitor monitor) {
            int type = event.getType();
            final IWorkItemHandle handle = event.getWorkItem();
            if (type == 0) {
                WorkItemLabelDecorator.this.fActiveWorkItemHandle = handle;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelDecorator.this, (Object)WorkItemLabelDecorator.this.fActiveWorkItemHandle));
                    }
                });
            } else if (type == 1) {
                WorkItemLabelDecorator.this.fActiveWorkItemHandle = null;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelDecorator.this, (Object)handle));
                    }
                });
            }
            return Status.OK_STATUS;
        }
    };

    public WorkItemLabelDecorator() {
        ITeamRepository[] repositories;
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.fRepositoryListener.addedRepository(repository);
            if (repository.loggedIn()) {
                this.fRepositoryListener.handleLogin(repository);
            }
            ++n2;
        }
        ClientModel.getWorkItemActivationManager().addActivationParticipant(this.fActivationListener);
        this.fResources = new LocalResourceManager(JFaceResources.getResources((Display)Display.getDefault()));
        try {
            this.fResources.createColor(CLOSED_COLOR);
        }
        catch (DeviceResourceException e) {
            WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemLabelDecorator_ERROR_CREATING_COLOR, e);
        }
        this.fClosedFont = WorkItemLabelDecorator.createStrikethroughFont(JFaceResources.getFont((String)"org.eclipse.jface.defaultfont").getFontData());
        this.fUseReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IWorkItem) {
            IContributorHandle owner;
            IWorkItem workitem = (IWorkItem)element;
            int stateCategory = WorkItemLabelDecorator.getStateCategory(workitem);
            boolean isOwner = false;
            if (workitem.isPropertySet(IWorkItem.OWNER_PROPERTY) && (owner = workitem.getOwner()) != null) {
                ITeamRepository teamRepository = (ITeamRepository)workitem.getOrigin();
                isOwner = owner.sameItemId((IItemHandle)teamRepository.loggedInContributor());
            }
            if (isOwner) {
                if (!this.fUseReducedColors) {
                    if (workitem.sameItemId((IItemHandle)this.fActiveWorkItemHandle)) {
                        decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)MY_CURRENT_WORKITEM_COLOR));
                    } else {
                        decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)MY_WORKITEMS_COLOR));
                    }
                }
                if (stateCategory == 2) {
                    if (this.fClosedFont != null) {
                        decoration.setFont(JazzResources.getFont((ResourceManager)this.fResources, (FontDescriptor)this.fClosedFont, null));
                    } else if (!this.fUseReducedColors) {
                        decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)CLOSED_COLOR));
                    }
                }
            } else {
                if (!this.fUseReducedColors) {
                    decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)NORMAL_COLOR));
                }
                if (stateCategory == 2) {
                    if (this.fClosedFont != null) {
                        decoration.setFont(JazzResources.getFont((ResourceManager)this.fResources, (FontDescriptor)this.fClosedFont, null));
                    } else if (!this.fUseReducedColors) {
                        decoration.setForegroundColor(JazzResources.getColor((ResourceManager)this.fResources, (ColorDescriptor)CLOSED_COLOR));
                    }
                } else {
                    decoration.setFont(JFaceResources.getFont((String)"org.eclipse.jface.defaultfont"));
                }
            }
        }
    }

    public void dispose() {
        ITeamRepository[] repositories;
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        service.removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this.fRepositoryListener);
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.fRepositoryListener.removedRepository(repository);
            ++n2;
        }
        ClientModel.getWorkItemActivationManager().removeActivationParticipant(this.fActivationListener);
        this.fResources.dispose();
    }

    private static FontDescriptor createStrikethroughFont(FontData[] basedata) {
        if (fIsWin) {
            FontData[] copiedData = WorkItemLabelDecorator.getCopiedFontData(basedata);
            try {
                Field dataField = FontData.class.getDeclaredField("data");
                Object dataObject = dataField.get(copiedData[0]);
                Class<?> clazz = dataObject.getClass().getSuperclass();
                Field strikeOutField = clazz.getDeclaredField("lfStrikeOut");
                int i = 0;
                while (i < copiedData.length) {
                    Object data = dataField.get(copiedData[i]);
                    strikeOutField.setByte(data, (byte)1);
                    ++i;
                }
                return FontDescriptor.createFrom((FontData[])copiedData);
            }
            catch (SecurityException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemLabelDecorator_ERROR_CREATING_STRIKE_THROUGH, e);
            }
            catch (NoSuchFieldException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemLabelDecorator_ERROR_CREATING_STRIKE_THROUGH, e);
            }
            catch (IllegalArgumentException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemLabelDecorator_ERROR_CREATING_STRIKE_THROUGH, e);
            }
            catch (IllegalAccessException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages.WorkItemLabelDecorator_ERROR_CREATING_STRIKE_THROUGH, e);
            }
        }
        return null;
    }

    private static FontData[] getCopiedFontData(FontData[] baseData) {
        FontData[] styleData = new FontData[baseData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = baseData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle());
            ++i;
        }
        return styleData;
    }

    private static int getStateCategory(IWorkItem workitem) {
        int stateGroup;
        if (!workitem.isPropertySet(IWorkItem.WORKFLOW_SURROGATE_PROPERTY) || !workitem.isPropertySet(IWorkItem.STATE_PROPERTY)) {
            return -1;
        }
        IWorkflowInfo workflowInfo = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workitem);
        if (workflowInfo != null && (stateGroup = workflowInfo.getStateGroup(workitem.getState2())) != 0) {
            return stateGroup;
        }
        return -1;
    }

    private final class TeamRepositoryLoginListener
    implements ITeamRepositoryService.IRepositoryServiceListener,
    IListener {
        TeamRepositoryLoginListener() {
        }

        public void addedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.addGenericListener((Object)"state", (IListener)this);
        }

        void handleLogin(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            final IWorkItemHandle handle = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
            if (handle != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelDecorator.this, (Object)handle));
                    }
                });
            }
        }

        void handleLogout(ITeamRepository repository) {
            ITeamRepository extended;
            Object origin;
            Assert.isNotNull((Object)repository);
            final IWorkItemHandle handle = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
            if (handle != null && (origin = handle.getOrigin()) instanceof ITeamRepository && (extended = (ITeamRepository)origin).equals(repository)) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        WorkItemLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkItemLabelDecorator.this, (Object)handle));
                    }
                });
            }
        }

        public void removedRepository(ITeamRepository repository) {
            Assert.isNotNull((Object)repository);
            repository.removeGenericListener((Object)"state", (IListener)this);
        }

        public void handleEvents(List events) {
            Assert.isNotNull((Object)events);
            for (Object event : events) {
                IEventSource source;
                PropertyChangeEvent extended;
                Object property;
                if (!(event instanceof PropertyChangeEvent) || !"state".equals(property = (extended = (PropertyChangeEvent)event).getProperty()) || !((source = extended.getEventSource()) instanceof ITeamRepository)) continue;
                ITeamRepository repository = (ITeamRepository)source;
                int state = repository.getState();
                switch (state) {
                    case 1: {
                        this.handleLogin(repository);
                        break;
                    }
                    case 3: {
                        this.handleLogout(repository);
                    }
                }
            }
        }
    }
}

