/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AbstractContentAssistProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContextProviderContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ISubscriptions;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.Messages;
import com.ibm.team.workitem.rcp.ui.internal.UserResolvableProposal;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemContextProvider;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProposalComputer
extends AbstractContentAssistProposalComputer {
    private static final int MAX_PROPOSALS = 20;
    private final boolean fInsertAsLink;
    private final ReferenceInsertionStrategy fInsertionStrategy;
    private StandardLabelProvider fStandardLabelProvider;

    public UserProposalComputer(ReferenceInsertionStrategy insertionStrategy) {
        this.fInsertionStrategy = insertionStrategy;
        this.fInsertAsLink = true;
    }

    public UserProposalComputer(ReferenceInsertionStrategy insertionStrategy, boolean insertAsLink) {
        this.fInsertionStrategy = insertionStrategy;
        this.fInsertAsLink = insertAsLink;
    }

    public void sessionStarted() {
        super.sessionStarted();
        this.fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)new FallbackLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl());
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        ITeamRepository[] teamRepositories = null;
        IWorkItem workItem = null;
        if (context instanceof ContextProviderContentAssistContext) {
            WorkItemContextProvider workItemContextProvider;
            ContentAssistContextProvider contextProvider = ((ContextProviderContentAssistContext)context).getContextProvider();
            if (contextProvider instanceof TeamContextProvider) {
                teamRepositories = new ITeamRepository[]{((TeamContextProvider)contextProvider).getTeamRepository()};
            }
            if (contextProvider instanceof WorkItemContextProvider && (workItemContextProvider = (WorkItemContextProvider)contextProvider) != null) {
                workItem = ((WorkItemContextProvider)contextProvider).getWorkItem();
            }
        }
        if (teamRepositories == null) {
            teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        }
        ITeamRepository[] iTeamRepositoryArray = teamRepositories;
        int n = teamRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository tr = iTeamRepositoryArray[n2];
            if (tr != null) {
                List<Object> possibleProposals = workItem != null ? this.getContributorsConnectedToTheWorkItem(workItem, tr) : new ArrayList();
                List knownContributors = tr.itemManager().getKnownSharedItems(IContributor.ITEM_TYPE);
                possibleProposals.addAll(knownContributors);
                ItemHandleAwareHashSet ignoreList = new ItemHandleAwareHashSet();
                IContributor loggedInContributor = tr.loggedInContributor();
                if (loggedInContributor != null) {
                    ignoreList.add((Object)loggedInContributor);
                }
                for (IContributor iContributor : possibleProposals) {
                    if (result.size() >= 20) {
                        return this.filter(context, result);
                    }
                    if (!this.canAdd(tr, iContributor, (ItemHandleAwareHashSet<IContributorHandle>)ignoreList)) continue;
                    this.addToResultList(result, tr, iContributor);
                    ignoreList.add((Object)iContributor);
                }
            }
            ++n2;
        }
        return this.filter(context, result);
    }

    private List<IContributor> getContributorsConnectedToTheWorkItem(IWorkItem workItem, ITeamRepository tr) {
        IContributorHandle[] subscribers;
        IItem creator;
        ArrayList<IContributor> contributorsConnectedToWorkItem = new ArrayList<IContributor>();
        IItem owner = tr.itemManager().getSharedItemIfKnown((IItemHandle)workItem.getOwner());
        if (owner instanceof IContributor) {
            contributorsConnectedToWorkItem.add((IContributor)owner);
        }
        if ((creator = tr.itemManager().getSharedItemIfKnown((IItemHandle)workItem.getCreator())) instanceof IContributor) {
            contributorsConnectedToWorkItem.add((IContributor)creator);
        }
        ISubscriptions subscriptions = workItem.getSubscriptions();
        IContributorHandle[] iContributorHandleArray = subscribers = subscriptions.getContents();
        int n = subscribers.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle subscriberHandle = iContributorHandleArray[n2];
            IItem subscriber = tr.itemManager().getSharedItemIfKnown((IItemHandle)subscriberHandle);
            if (subscriber instanceof IContributor) {
                contributorsConnectedToWorkItem.add((IContributor)subscriber);
            }
            ++n2;
        }
        return contributorsConnectedToWorkItem;
    }

    private boolean canAdd(ITeamRepository tr, IContributor contributor, ItemHandleAwareHashSet<IContributorHandle> ignoreList) {
        if (contributor == null) {
            return false;
        }
        if (contributor.isArchived()) {
            return false;
        }
        if (DefaultModel.NULL_CONTRIBUTOR_ITEM_ID.equals((Object)contributor.getItemId())) {
            return false;
        }
        return !ignoreList.contains((Object)contributor);
    }

    private void addToResultList(ArrayList<ICompletionProposal> result, ITeamRepository tr, IContributor contributor) {
        ViewerLabel label = new ViewerLabel("", null);
        this.fStandardLabelProvider.updateLabel(label, (Object)contributor);
        if (!this.fInsertAsLink) {
            label.setText(NLS.bind((String)Messages.UserProposalComputer_PROPOSAL_TEXT, (Object)contributor.getUserId(), (Object)label.getText()));
        }
        result.add((ICompletionProposal)new UserProposal(label.getText(), label.getImage(), (IContributorHandle)contributor, this.fInsertionStrategy, tr, this.fInsertAsLink));
    }

    public void sessionEnded() {
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        super.sessionEnded();
    }

    private static final class FallbackLabelProvider
    extends LabelProvider {
        private LocalResourceManager fManager;

        public Image getImage(Object element) {
            if (this.fManager == null) {
                this.fManager = new LocalResourceManager(JFaceResources.getResources());
            }
            return this.fManager.createImageWithDefault(ImagePool.USER);
        }

        public String getText(Object element) {
            IContributor contributor = (IContributor)element;
            return contributor.getName();
        }

        public void dispose() {
            super.dispose();
            if (this.fManager != null) {
                this.fManager.dispose();
                this.fManager = null;
            }
        }
    }

    private static final class UserProposal
    extends UserResolvableProposal {
        private IContributorHandle fContributorHandle;
        private final boolean fInsertAsLink;

        public UserProposal(String displayString, Image image, IContributorHandle element, ReferenceInsertionStrategy insertionStrategy, ITeamRepository repository, boolean insertAsLink) {
            super(displayString, image, element, insertionStrategy, repository);
            this.fContributorHandle = element;
            this.fInsertAsLink = insertAsLink;
        }

        public boolean isValidFor(IDocument document, int offset) {
            try {
                String prefix = this.getPrefix(document, offset);
                if (!this.fInsertAsLink && prefix.length() > 0 && prefix.charAt(0) == '@') {
                    prefix = prefix.substring(1);
                }
                return this.getDisplayString().toLowerCase().contains(prefix.toLowerCase());
            }
            catch (BadLocationException e) {
                WorkItemRCPUIPlugin.getDefault().log(e.getMessage(), e);
                return false;
            }
        }

        public void apply(IDocument document, char trigger, int offset) {
            IContributorHandle[] contributorHandle = new IContributorHandle[]{this.fContributorHandle};
            this.resolveAndInsert(document, offset, contributorHandle, NLS.bind((String)Messages.UserProposalComputer_RESOLVE_PROGRESS_LABEL, (Object)this.getDisplayString()), this.fInsertAsLink);
        }

        protected String getPrefix(IDocument doc, int offset) throws BadLocationException {
            if (doc == null || offset > doc.getLength()) {
                return null;
            }
            int length = 0;
            while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
                if (doc.getChar(offset) == '@') {
                    return doc.get(offset, length + 1);
                }
                ++length;
            }
            return doc.get(offset + 1, length);
        }
    }
}

