/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.internal.ISubjectRelationshipTracker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SubjectRelationshipTrackerFactory
implements IAdapterFactory {
    private Class[] fAdapterList = new Class[]{ISubjectRelationshipTracker.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (ISubjectRelationshipTracker.class.equals((Object)adapterType)) {
            IItemHandle handle;
            if (adaptableObject instanceof IItemHandle) {
                IItemHandle handle2 = (IItemHandle)adaptableObject;
                return new SubjectRelationshipTracker(handle2);
            }
            if (adaptableObject instanceof IReference && ((IReference)adaptableObject).isItemReference() && (handle = ((IItemReference)adaptableObject).getReferencedItem()) != null) {
                return new SubjectRelationshipTracker(handle);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return this.fAdapterList;
    }

    private static class SubjectRelationshipTracker
    implements ISubjectRelationshipTracker {
        private IItemHandle fItemHandle;

        public SubjectRelationshipTracker(IItemHandle itemHandle) {
            this.fItemHandle = itemHandle;
        }

        public String getRelationship() {
            if (this.fItemHandle instanceof IWorkItemHandle) {
                IWorkItem workItem;
                IContributor user;
                block10: {
                    block9: {
                        block8: {
                            IWorkItemHandle workItemHandle = (IWorkItemHandle)this.fItemHandle;
                            ITeamRepository repository = (ITeamRepository)workItemHandle.getOrigin();
                            user = repository.loggedInContributor();
                            if (user == null) {
                                return "unknown";
                            }
                            IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
                            workItem = this.getWorkItem(workItemClient, workItemHandle);
                            if (!user.sameItemId((IItemHandle)workItem.getOwner())) break block8;
                            return "owner";
                        }
                        if (!user.sameItemId((IItemHandle)workItem.getCreator())) break block9;
                        return "creator";
                    }
                    if (!this.isSubscriber((IContributorHandle)user, workItem)) break block10;
                    return "subscriber";
                }
                try {
                    if (this.isConsumer((IContributorHandle)user, workItem)) {
                        return "consumer";
                    }
                }
                catch (TeamRepositoryException x) {
                    WorkItemRCPUIPlugin.getDefault().log(x.getMessage(), x);
                }
            }
            return "unknown";
        }

        private boolean isSubscriber(IContributorHandle contributor, IWorkItem workItem) {
            if (((WorkItem)workItem).isSetInternalSubscriptions()) {
                return workItem.getSubscriptions().contains(contributor);
            }
            return false;
        }

        private boolean isConsumer(IContributorHandle contributor, IWorkItem workItem) {
            IApprovals approvals = workItem.getApprovals();
            List contents = approvals.getContents();
            for (IApproval approval : contents) {
                if (!contributor.sameItemId((IItemHandle)approval.getApprover())) continue;
                return true;
            }
            return false;
        }

        private IWorkItem getWorkItem(IWorkItemClient workItemClient, IWorkItemHandle handle) throws TeamRepositoryException {
            IWorkItem workItem;
            if (handle instanceof IWorkItem && (workItem = (IWorkItem)handle).hasAttribute(workItemClient.findAttribute(workItem.getProjectArea(), IWorkItem.OWNER_PROPERTY, (IProgressMonitor)new NullProgressMonitor())) && workItem.hasAttribute(workItemClient.findAttribute(workItem.getProjectArea(), IWorkItem.CREATOR_PROPERTY, (IProgressMonitor)new NullProgressMonitor()))) {
                return workItem;
            }
            HashSet<String> attributes = new HashSet<String>();
            attributes.addAll(IWorkItem.SMALL_PROFILE.getProperties());
            attributes.add(IWorkItem.OWNER_PROPERTY);
            attributes.add(IWorkItem.CREATOR_PROPERTY);
            return workItemClient.resolveWorkItem(handle, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, attributes), (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

