/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.jface.internal.DecorationImageDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.ui.internal.IActivationTracker;
import com.ibm.team.workitem.rcp.ui.internal.ISubjectRelationshipTracker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class PendingNotificationsDecorator
implements ILabelDecorator,
IFontDecorator,
IColorDecorator {
    private static final String PREFIX = PendingNotificationsDecorator.class.getName();
    private static final String MY_CURRENT_WORKITEM_COLOR = "my_current_workitem";
    private final ListenerList fListeners = new ListenerList();
    private final ImageRegistry fRegistry;
    private final ColorRegistry fColorRegistry;
    private final Font fBold;
    private boolean fUseReducedColors;

    public PendingNotificationsDecorator() {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        this.fUseReducedColors = "org.eclipse.ui.ide.systemDefault".equals(theme.getId());
        FontRegistry fontRegistry = theme.getFontRegistry();
        this.fBold = fontRegistry.getBold("org.eclipse.jface.defaultfont");
        this.fColorRegistry = theme.getColorRegistry();
        this.initializeColors(this.fColorRegistry);
        this.fRegistry = WorkItemRCPUIPlugin.getDefault().getImageRegistry();
    }

    private void initializeColors(ColorRegistry colorRegistry) {
        this.fColorRegistry.put(String.valueOf(PREFIX) + MY_CURRENT_WORKITEM_COLOR, new RGB(6, 97, 240));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "owner".toString(), new RGB(0, 0, 128));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "creator".toString(), new RGB(254, 211, 222));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "subscriber".toString(), new RGB(226, 228, 254));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "contributor".toString(), new RGB(240, 241, 255));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "consumer".toString(), new RGB(255, 255, 255));
        this.fColorRegistry.put(String.valueOf(PREFIX) + "unknown".toString(), new RGB(255, 255, 255));
    }

    public void dispose() {
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int flags = this.computeFlags(element);
        if (flags != 0) {
            Rectangle bounds = image.getBounds();
            DecorationImageDescriptor descriptor = new DecorationImageDescriptor(image, flags, new Point(bounds.width, bounds.height));
            String key = this.generateKey((ImageDescriptor)descriptor, flags);
            Image decoratedImage = this.fRegistry.get(key);
            if (decoratedImage == null) {
                this.fRegistry.put(key, (ImageDescriptor)descriptor);
                decoratedImage = this.fRegistry.get(key);
            }
            return decoratedImage;
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Font decorateFont(Object element) {
        if (this.isMarkedUnread(element)) {
            return this.fBold;
        }
        return null;
    }

    public Color decorateForeground(Object element) {
        if (!this.fUseReducedColors) {
            if (this.isMyCurrentWorkItem(element)) {
                return this.computeForeground(MY_CURRENT_WORKITEM_COLOR);
            }
            if (this.getRelationship(element) == "owner") {
                return this.computeForeground("owner");
            }
        }
        return null;
    }

    public Color decorateBackground(Object element) {
        if (!this.fUseReducedColors && this.isMarkedUnread(element)) {
            return this.computeBackground(this.getRelationship(element));
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private int computeFlags(Object element) {
        int flags = 0;
        if (this.isActive(element)) {
            flags |= 2;
        }
        return flags;
    }

    private String generateKey(ImageDescriptor descriptor, int flags) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(descriptor.hashCode());
        buffer.append('_');
        buffer.append(flags);
        return buffer.toString();
    }

    private boolean isMyCurrentWorkItem(Object element) {
        if (element instanceof IWorkItemHandle) {
            IWorkItemHandle active = ClientModel.getWorkItemActivationManager().getActiveWorkItem();
            return ((IWorkItemHandle)element).sameItemId((IItemHandle)active);
        }
        return false;
    }

    private boolean isMarkedUnread(Object element) {
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IReadStateTracker tracker = (IReadStateTracker)adaptable.getAdapter(IReadStateTracker.class);
            return tracker != null && !tracker.isMarkedRead();
        }
        if (element != null) {
            IAdapterManager manager = Platform.getAdapterManager();
            IReadStateTracker tracker = (IReadStateTracker)manager.getAdapter(element, IReadStateTracker.class);
            return tracker != null && !tracker.isMarkedRead();
        }
        return false;
    }

    private boolean isActive(Object element) {
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IActivationTracker tracker = (IActivationTracker)adaptable.getAdapter(IActivationTracker.class);
            return tracker != null && tracker.isActive();
        }
        IAdapterManager manager = Platform.getAdapterManager();
        IActivationTracker tracker = (IActivationTracker)manager.getAdapter(element, IActivationTracker.class);
        return tracker != null && tracker.isActive();
    }

    private String getRelationship(Object element) {
        IAdaptable adaptable;
        ISubjectRelationshipTracker tracker;
        if (element instanceof IAdaptable && (tracker = (ISubjectRelationshipTracker)(adaptable = (IAdaptable)element).getAdapter(ISubjectRelationshipTracker.class)) != null) {
            return tracker.getRelationship();
        }
        IAdapterManager manager = Platform.getAdapterManager();
        tracker = (ISubjectRelationshipTracker)manager.getAdapter(element, ISubjectRelationshipTracker.class);
        return tracker != null ? tracker.getRelationship() : "unknown";
    }

    private Color computeForeground(String relationship) {
        return this.fColorRegistry.get(String.valueOf(PREFIX) + relationship.toString());
    }

    private Color computeBackground(String relationship) {
        return null;
    }
}

