/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeWorkItemStateOperation
extends WorkItemOperation {
    private final Identifier<IWorkflowAction> fActionId;
    private final Identifier<IResolution> fResolutionId;

    public ChangeWorkItemStateOperation(String name, Identifier<IWorkflowAction> actionId, Identifier<IResolution> resolutionId) {
        super(name, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, (String[])new String[]{IWorkItem.STATE_PROPERTY, IWorkItem.RESOLUTION_PROPERTY}));
        this.fActionId = actionId;
        this.fResolutionId = resolutionId;
    }

    protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopy[] workItemWorkingCopyArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository teamRepository;
            IWorkItemClient workItemClient;
            IWorkflowInfo workflowInfo;
            WorkItemWorkingCopy workingCopy = workItemWorkingCopyArray[n2];
            IWorkItem workItem = workingCopy.getWorkItem();
            Identifier state = workItem.getState2();
            if (state != null && (workflowInfo = (workItemClient = (IWorkItemClient)(teamRepository = workingCopy.getTeamRepository()).getClientLibrary(IWorkItemClient.class)).findWorkflowInfo(workItem, monitor)) != null) {
                Identifier[] actionIds = workflowInfo.getActionIds(state);
                int i = 0;
                while (i < actionIds.length) {
                    Identifier identifier = actionIds[i];
                    if (identifier.equals(this.fActionId)) {
                        if (this.fResolutionId != null) {
                            Identifier[] validResIds = workflowInfo.getResolutionIds(this.fActionId);
                            if (!Arrays.asList(validResIds).contains(this.fResolutionId)) break;
                            workItem.setResolution2(this.fResolutionId);
                            workingCopy.setWorkflowAction(this.fActionId.getStringIdentifier());
                            break;
                        }
                        workingCopy.setWorkflowAction(this.fActionId.getStringIdentifier());
                        break;
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }
}

