/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.ui;

import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.rcp.ui.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class UIWorkItemListener
implements IWorkItemListener {
    private ListenerList fListeners = new ListenerList();
    private Map fAttributeListenerMap = new HashMap();

    public UIWorkItemListener() {
    }

    public UIWorkItemListener(IWorkItemListener listener) {
        this.addListener(listener);
    }

    public UIWorkItemListener(IWorkItemListener listener, String attributeIdentifier) {
        this.addListener(listener, attributeIdentifier);
    }

    public UIWorkItemListener(IWorkItemListener listener, String[] attributeIdentifiers) {
        int i = 0;
        while (i < attributeIdentifiers.length) {
            this.addListener(listener, attributeIdentifiers[i]);
            ++i;
        }
    }

    public void addListener(IWorkItemListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IWorkItemListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void addListener(IWorkItemListener listener, String attributeIdentifier) {
        this.getListeners(this.fAttributeListenerMap, attributeIdentifier, true).add((Object)listener);
    }

    public void removeListener(IWorkItemListener listener, String attributeIdentifier) {
        ListenerList listeners = this.getListeners(this.fAttributeListenerMap, attributeIdentifier, false);
        if (listeners != null) {
            listeners.remove((Object)listener);
        }
    }

    public void workItemAttributeChanged(final WorkItemChangeEvent event) {
        IStatus status = WorkItemRCPUIPlugin.runInUI(Messages.UIWorkItemListener_UI_WORKITEM_NOTIFICATION, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                this.fireWorkItemAttributeChanged(UIWorkItemListener.this.fListeners, event);
                String[] attributes = event.getChangedAttributes();
                int i = 0;
                while (i < attributes.length) {
                    ListenerList listenerList = UIWorkItemListener.this.getListeners(UIWorkItemListener.this.fAttributeListenerMap, attributes[i], false);
                    if (listenerList != null) {
                        this.fireWorkItemAttributeChanged(listenerList, event);
                    }
                    ++i;
                }
            }

            private void fireWorkItemAttributeChanged(final ListenerList listenerList, final WorkItemChangeEvent event2) {
                Object[] listeners = listenerList.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    final IWorkItemListener listener = (IWorkItemListener)listeners[i];
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.workItemAttributeChanged(event2);
                        }

                        public void handleException(Throwable exception) {
                            listenerList.remove((Object)listener);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                    ++i;
                }
            }
        }, null);
        if (!status.isOK()) {
            WorkItemRCPUIPlugin.getDefault().log(status);
        }
    }

    public void workItemAttributeDependencyChanged(final WorkItemChangeEvent event) {
        IStatus status = WorkItemRCPUIPlugin.runInUI(Messages.UIWorkItemListener_UI_WORKITEM_NOTIFICATION, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                this.fireAttributeDependencyChanged(UIWorkItemListener.this.fListeners, event);
                String[] dependents = event.getAffectedDependents();
                int i = 0;
                while (i < dependents.length) {
                    ListenerList listenerList = UIWorkItemListener.this.getListeners(UIWorkItemListener.this.fAttributeListenerMap, dependents[i], false);
                    if (listenerList != null) {
                        this.fireAttributeDependencyChanged(listenerList, event);
                    }
                    ++i;
                }
            }

            private void fireAttributeDependencyChanged(final ListenerList listenerList, final WorkItemChangeEvent event2) {
                Object[] listeners = listenerList.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    final IWorkItemListener listener = (IWorkItemListener)listeners[i];
                    ISafeRunnable runnable = new ISafeRunnable(){

                        public void run() throws Exception {
                            listener.workItemAttributeDependencyChanged(event2);
                        }

                        public void handleException(Throwable exception) {
                            listenerList.remove((Object)listener);
                        }
                    };
                    SafeRunner.run((ISafeRunnable)runnable);
                    ++i;
                }
            }
        }, null);
        if (!status.isOK()) {
            WorkItemRCPUIPlugin.getDefault().log(status);
        }
    }

    private ListenerList getListeners(Map listenerMap, String attributeIdentifier, boolean create) {
        ListenerList listeners = (ListenerList)listenerMap.get(attributeIdentifier);
        if (listeners == null && create) {
            listeners = new ListenerList();
            listenerMap.put(attributeIdentifier, listeners);
        }
        return listeners;
    }
}

