/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.CommentsDocument;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class WorkItemUIWorkingCopyManager {
    private WorkItemUIWorkingCopy fUIWorkingCopy;
    private IComment fIgnoredComment;
    private InternalListener fInternalListener = new InternalListener();
    private InternalWorkingCopyListener fInternalWorkingCopyListener = new InternalWorkingCopyListener();

    public WorkItemUIWorkingCopyManager(WorkItemUIWorkingCopy uiWorkingCopy) {
        this.fUIWorkingCopy = uiWorkingCopy;
        this.fUIWorkingCopy.getUIWorkItemListener().addListener(this.fInternalListener);
        this.getWorkingCopy().addWorkingCopyListener((IWorkingCopyListener)this.fInternalWorkingCopyListener);
    }

    public IComment[] getVisibleComments() {
        if (this.fIgnoredComment == null) {
            return this.getWorkItem().getComments().getContents();
        }
        ArrayList<IComment> comments = new ArrayList<IComment>(Arrays.asList(this.getWorkItem().getComments().getContents()));
        comments.remove(this.fIgnoredComment);
        return comments.toArray(new IComment[comments.size()]);
    }

    public IComment getIgnoredComment() {
        return this.fIgnoredComment;
    }

    private void handleCommentsChanged(CommentsChangeDetails changeDetails, int kind) {
        for (DocumentModel documentModel : this.fUIWorkingCopy.getDocumentModels()) {
            IStyledDocument document = documentModel.getDocument();
            if (!(document instanceof CommentsDocument)) continue;
            ((CommentsDocument)document).handleCommentsChanged(changeDetails, kind);
        }
    }

    private void handleAboutToBeDisposed() {
        this.getWorkingCopy().removeWorkingCopyListener((IWorkingCopyListener)this.fInternalWorkingCopyListener);
        this.fUIWorkingCopy.getUIWorkItemListener().removeListener(this.fInternalListener);
        this.fUIWorkingCopy.dispose();
    }

    private void handleAboutToBeSaved() {
        XMLString newCommentHTML;
        this.synchronizeDocumentChanges();
        if (this.getWorkItem().isPropertySet(IWorkItem.COMMENTS_PROPERTY) && this.fUIWorkingCopy.isNewCommentInUse() && (newCommentHTML = this.fUIWorkingCopy.getNewComment().getHTML()).getXMLText().trim().length() > 0) {
            IContributor creator = this.getWorkingCopy().getTeamRepository().loggedInContributor();
            this.fIgnoredComment = this.getWorkItem().getComments().createComment((IContributorHandle)creator, newCommentHTML);
            this.getWorkItem().getComments().append(this.fIgnoredComment);
        }
    }

    public void synchronizeDocumentChanges() {
        DocumentModel documentModel;
        if (this.getWorkItem().isPropertySet(IWorkItem.SUMMARY_PROPERTY) && this.fUIWorkingCopy.isSummaryInUse() && (documentModel = this.fUIWorkingCopy.getSummarySupport()).isDirty()) {
            XMLString newHtml = documentModel.getDocument().getHTML();
            this.getWorkItem().setHTMLSummary(newHtml);
            documentModel.markClean();
        }
        if (this.fUIWorkingCopy.isResolvedWorkItemSet()) {
            for (String key : this.fUIWorkingCopy.getAttributeModels().keySet()) {
                DocumentModel documentModel2;
                IAttribute attribute = this.fUIWorkingCopy.getResolvedWorkItem().findAttribute(key);
                if (attribute == null || !(documentModel2 = this.fUIWorkingCopy.getDocumentModel(attribute)).isDirty()) continue;
                XMLString newHtml = documentModel2.getDocument().getHTML();
                this.getWorkItem().setValue(attribute, (Object)newHtml.getXMLText());
                documentModel2.markClean();
            }
        }
    }

    private void handleSaved() {
        if (this.getWorkItem().isPropertySet(IWorkItem.COMMENTS_PROPERTY) && this.fUIWorkingCopy.isNewCommentInUse() && this.fIgnoredComment != null) {
            CommentsChangeDetails changeDetails = null;
            List<IComment> comments = Arrays.asList(this.getWorkItem().getComments().getContents());
            int index = comments.indexOf(this.fIgnoredComment);
            if (index != -1 && this.fIgnoredComment.getCreator().sameItemId((IItemHandle)this.getWorkingCopy().getTeamRepository().loggedInContributor())) {
                changeDetails = new CommentsChangeDetails(this.fIgnoredComment, this.getWorkingCopy().getTeamRepository().loggedInContributor(), index, true);
            }
            this.fIgnoredComment = null;
            this.handleCommentsChanged(changeDetails, 1);
            WorkItemRCPUIPlugin.runInUI(Messages2.WorkItemUIWorkingCopyManager_UPDATING_NEW_COMMENT, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (WorkItemUIWorkingCopyManager.this.getWorkingCopy() == null) {
                        return;
                    }
                    WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getNewComment().set("");
                }
            }, null);
        }
    }

    private void handleSaveCanceled() {
        if (this.getWorkItem().isPropertySet(IWorkItem.COMMENTS_PROPERTY) && this.fUIWorkingCopy.isNewCommentInUse() && this.fIgnoredComment != null) {
            ((WorkItem)this.getWorkItem()).getInternalComments().remove(this.fIgnoredComment);
            this.fIgnoredComment = null;
        }
    }

    private void handleReverted() {
        if (this.fUIWorkingCopy.isNewCommentInUse() && this.fUIWorkingCopy.getNewComment().getLength() > 0) {
            WorkItemRCPUIPlugin.runInUI(Messages2.WorkItemUIWorkingCopyManager_UPDATING_NEW_COMMENT, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (WorkItemUIWorkingCopyManager.this.getWorkingCopy() == null) {
                        return;
                    }
                    WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getNewComment().set("");
                }
            }, null);
        }
    }

    private WorkItemWorkingCopy getWorkingCopy() {
        return this.fUIWorkingCopy.getWorkingCopy();
    }

    private IWorkItem getWorkItem() {
        return this.getWorkingCopy().getWorkItem();
    }

    private class InternalListener
    implements IWorkItemListener {
        private InternalListener() {
        }

        public void workItemAttributeChanged(final WorkItemChangeEvent event) {
            if (WorkItemUIWorkingCopyManager.this.getWorkingCopy() == null || !event.affects((IWorkItemHandle)WorkItemUIWorkingCopyManager.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.isResolvedWorkItemSet()) {
                for (String key : WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getAttributeModels().keySet()) {
                    final IAttribute attribute = WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getResolvedWorkItem().findAttribute(key);
                    if (attribute == null || !event.affects(attribute.getIdentifier())) continue;
                    WorkItemRCPUIPlugin.runInUI(NLS.bind((String)Messages2.WorkItemUIWorkingCopyManager_UPDATING, (Object)attribute.getIdentifier(), (Object[])new Object[0]), new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            if (WorkItemUIWorkingCopyManager.this.getWorkingCopy() == null) {
                                return;
                            }
                            final XMLString newHTML = XMLString.createFromXMLText((String)((String)WorkItemUIWorkingCopyManager.this.getWorkItem().getValue(attribute)));
                            XMLString oldHTML = WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getDocumentModel(attribute).getDocument().getHTML();
                            if (!oldHTML.equals((Object)newHTML)) {
                                WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.changeDocument(new Runnable(){

                                    public void run() {
                                        WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getDocumentModel(attribute).getDocument().setHTML(newHTML);
                                    }
                                }, event.getAttributeChangeType(attribute.getIdentifier()));
                            }
                        }
                    }, null);
                }
            }
            if (event.affects(IWorkItem.SUMMARY_PROPERTY) && WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.isSummaryInUse()) {
                WorkItemRCPUIPlugin.runInUI(Messages2.WorkItemUIWorkingCopyManager_UPDATING_SUMMARY, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (WorkItemUIWorkingCopyManager.this.getWorkingCopy() == null) {
                            return;
                        }
                        final XMLString newHTML = WorkItemUIWorkingCopyManager.this.getWorkItem().getHTMLSummary();
                        XMLString oldHTML = WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getSummary().getHTML();
                        if (!oldHTML.equals((Object)newHTML)) {
                            WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.changeDocument(new Runnable(){

                                public void run() {
                                    WorkItemUIWorkingCopyManager.this.fUIWorkingCopy.getSummary().setHTML(newHTML);
                                }
                            }, event.getAttributeChangeType(IWorkItem.SUMMARY_PROPERTY));
                        }
                    }
                }, null);
            }
            if (event.affects(IWorkItem.COMMENTS_PROPERTY)) {
                CommentsChangeDetails change = null;
                IAdaptable details = event.getAttributeChangeDetails(IWorkItem.COMMENTS_PROPERTY);
                if (details != null) {
                    change = (CommentsChangeDetails)details.getAdapter(CommentsChangeDetails.class);
                }
                WorkItemUIWorkingCopyManager.this.handleCommentsChanged(change, event.getAttributeChangeType(IWorkItem.COMMENTS_PROPERTY));
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }

    private class InternalWorkingCopyListener
    implements IWorkingCopyListener {
        private InternalWorkingCopyListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (event.hasType("reverted")) {
                WorkItemUIWorkingCopyManager.this.handleReverted();
            } else if (event.hasType("aboutToBeSaved")) {
                WorkItemUIWorkingCopyManager.this.handleAboutToBeSaved();
            } else if (event.hasType("saved")) {
                WorkItemUIWorkingCopyManager.this.handleSaved();
            } else if (event.hasType("saveCanceled")) {
                WorkItemUIWorkingCopyManager.this.handleSaveCanceled();
            } else if (event.hasType("aboutToBeDisposed")) {
                WorkItemUIWorkingCopyManager.this.handleAboutToBeDisposed();
            }
        }
    }
}

