/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class WorkItemEditorToolkit
extends TeamFormToolkit {
    private boolean fShared = false;

    public WorkItemEditorToolkit(FormColors colors) {
        super(colors);
        this.getHyperlinkGroup().setBackground(null);
        this.getHyperlinkGroup().setActiveBackground(null);
    }

    public Label createTitle(Composite parent, String text, int style) {
        Label label = super.createLabel(parent, text, style);
        label.setForeground(this.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setFont(JFaceResources.getHeaderFont());
        return label;
    }

    public Label createLabel(Composite parent, String text, int style, int backgroundStyle) {
        Label label = super.createLabel(parent, text, style);
        if (this.isInherit(backgroundStyle)) {
            label.setBackground(null);
        }
        return label;
    }

    public Button createButton(Composite parent, String text, int style, int backgroundStyle) {
        Button button = super.createButton(parent, text, style);
        if (this.isInherit(backgroundStyle)) {
            button.setBackground(null);
        }
        return button;
    }

    public Composite createComposite(Composite parent, int style, int backgroundStyle) {
        Composite composite = super.createComposite(parent, style);
        if (this.isInherit(backgroundStyle)) {
            composite.setBackground(null);
        }
        return composite;
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        this.adapt(control, trackFocus, trackKeyboard, -1);
    }

    public void adapt(DecoratedControl control, boolean trackFocus, boolean trackKeyboard, int backgroundStyle) {
        super.adapt(control.getDecoratedControl(), trackFocus, trackKeyboard);
        super.adapt(control.getLayoutControl(), trackFocus, false);
        if (control.getLayoutControl() instanceof Composite) {
            this.adaptComposite((Composite)control.getLayoutControl(), backgroundStyle);
        } else if (this.isInherit(backgroundStyle)) {
            control.getLayoutControl().setBackground(null);
        }
        if (control.getDecoratedControl() instanceof Composite) {
            this.adaptComposite((Composite)control.getDecoratedControl(), backgroundStyle);
        } else if (this.isInherit(backgroundStyle)) {
            control.getDecoratedControl().setBackground(null);
        }
        if (control.getImageControl() != null) {
            super.adapt(control.getImageControl(), trackFocus, false);
            if (control.getImageControl() instanceof Composite) {
                this.adaptComposite((Composite)control.getImageControl(), backgroundStyle);
            } else if (this.isInherit(backgroundStyle)) {
                control.getImageControl().setBackground(null);
            }
        }
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard, int backgroundStyle) {
        super.adapt(control, trackFocus, trackKeyboard);
        if (control instanceof Composite) {
            this.adaptComposite((Composite)control, backgroundStyle);
        } else if (this.isInherit(backgroundStyle)) {
            control.setBackground(null);
        }
    }

    private boolean isInherit(int style) {
        return style == 1 || style == 2;
    }

    public void adapt(Composite composite) {
        this.adapt(composite, -1);
    }

    public void adapt(Composite composite, int backgroundStyle) {
        super.adapt(composite);
        this.adaptComposite(composite, backgroundStyle);
    }

    private void adaptComposite(Composite composite, int backgroundSyle) {
        if (composite instanceof StyledText || this.isInherit(backgroundSyle)) {
            composite.setBackground(null);
        } else if (composite instanceof CCombo) {
            composite.setBackground(null);
        }
    }

    public Text createReadOnlyText(Composite parent, String value, int style, int backgroundStyle) {
        Text text = this.createText(parent, value, style | 8);
        if (this.isInherit(backgroundStyle)) {
            text.setBackground(null);
        } else {
            text.setBackground(this.getColors().getBackground());
        }
        text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        return text;
    }

    public ImageHyperlink createCustomImageHyperlink(Composite parent, int style) {
        return this.createCustomImageHyperlink(parent, style, -1);
    }

    public ImageHyperlink createCustomImageHyperlink(Composite parent, int style, int backgroundStyle) {
        ImageHyperlink hyperlink = new ImageHyperlink(parent, style | this.getOrientation());
        this.adapt((Control)hyperlink, true, true, backgroundStyle);
        return hyperlink;
    }

    public Hyperlink createCustomHyperlink(Composite parent, String text, int style) {
        return this.createCustomHyperlink(parent, text, style, -1);
    }

    public Hyperlink createCustomHyperlink(Composite parent, String text, int style, int backgroundStyle) {
        Hyperlink hyperlink = new Hyperlink(parent, style | this.getOrientation());
        if (text != null) {
            hyperlink.setText(text);
        }
        this.adapt((Control)hyperlink, true, true, backgroundStyle);
        return hyperlink;
    }

    public StandardControlLabelProvider createDecoratedHyperlink(TeamFormPart part, Composite parent, final ContextProvider contextProvider, int backgroundStyle) {
        Hyperlink hyperlink = this.createHyperlink(parent, "", 0);
        if (this.isInherit(backgroundStyle)) {
            hyperlink.setBackground(null);
        }
        final StandardControlLabelProvider hyperlinkLabelProvider = new StandardControlLabelProvider((Control)hyperlink);
        hyperlinkLabelProvider.setForegroundAware(true);
        hyperlinkLabelProvider.setTextAware(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FoundationJob job = new FoundationJob(Messages2.WorkItemEditorToolkit_OPEN_LINK){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        Object element = hyperlinkLabelProvider.getElement();
                        if (element == null) {
                            return Status.CANCEL_STATUS;
                        }
                        URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)monitor);
                        if (reference == null) {
                            return Status.CANCEL_STATUS;
                        }
                        Hyperlinks.open((URI)reference.getURI(), (ContextProvider)contextProvider, (IProgressMonitor)monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
        new TooltipSupport((Control)hyperlink, true, false){

            protected Object mapElement(int x, int y) {
                return hyperlinkLabelProvider.getElement();
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                Object data = hyperlinkLabelProvider.getElement();
                return data == null ? StructuredSelection.EMPTY : new StructuredSelection(data);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
            }
        });
        part.getSite().registerContextMenu(part.getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)hyperlink);
        hyperlink.setMenu(menu);
        return hyperlinkLabelProvider;
    }

    public Font getFont() {
        return null;
    }

    public void markShared() {
        this.fShared = true;
    }

    public void dispose() {
        if (!this.fShared) {
            super.dispose();
        }
    }

    public void doDispose() {
        super.dispose();
    }
}

