/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.icu.text.Collator;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class TagsTextField {
    private DecoratedText fText;
    private TagFetchingJob fFetchingJob;
    private List<String> fAllTags;
    private IAttribute fAttribute;

    public TagsTextField(Composite parent, ITeamFormPartSite site, int backgroundStyle) {
        this.fText = site != null ? new DecoratedFormsText(parent, site, 0, 2, backgroundStyle) : new DecoratedText(parent, 0, 2);
        this.fFetchingJob = new TagFetchingJob(Messages2.TagsTextField_FETCHING_TAGS);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.fText.getText(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TagContentProposalProvider(), keyStroke, new char[]{'*'});
        adapter.setProposalAcceptanceStyle(3);
        adapter.setPropagateKeys(true);
        adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (proposal instanceof TagContentProposal) {
                    Text tags = TagsTextField.this.fText.getText();
                    TagContentProposal prop = (TagContentProposal)proposal;
                    String text = tags.getText();
                    String result = prop.getBegin() > text.length() ? String.valueOf(text) + ", " + prop.getLabel() : String.valueOf(text.substring(0, prop.getBegin())) + prop.getLabel() + ", " + text.substring(prop.getEnd());
                    int pos = (result = TagsAttributeType.normalizeTags((String)result)).indexOf(prop.getLabel().toLowerCase()) + prop.getLabel().length() + 1;
                    if (pos >= result.length()) {
                        result = String.valueOf(result) + ", ";
                        ++pos;
                    }
                    tags.setText(result);
                    tags.setSelection(pos, pos);
                }
            }
        });
    }

    public DecoratedText getDecoratedText() {
        return this.fText;
    }

    public void setAttribute(IAttribute attribute) {
        this.fAttribute = attribute;
        if (this.fFetchingJob != null && this.fFetchingJob.getState() != 4) {
            this.fFetchingJob.schedule();
        }
    }

    private class TagContentProposal
    implements IContentProposal {
        private String fTag;
        private int fBegin;
        private int fEnd;

        public TagContentProposal(String tag, int begin, int end) {
            this.fTag = tag;
            this.fBegin = begin;
            this.fEnd = end;
        }

        public String getContent() {
            return this.fTag;
        }

        public String getLabel() {
            return this.fTag;
        }

        public String getDescription() {
            return null;
        }

        public int getCursorPosition() {
            return (this.fBegin == this.fEnd ? this.fBegin + 1 : this.fBegin) + this.fTag.length();
        }

        public int getBegin() {
            return this.fBegin;
        }

        public int getEnd() {
            return this.fEnd;
        }
    }

    private class TagContentProposalProvider
    implements IContentProposalProvider {
        private TagContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            int beginOfWord = 0;
            int i = position - 1;
            while (i >= 0) {
                if (contents.charAt(i) == ',' || contents.charAt(i) == ' ') {
                    beginOfWord = i + 1 < contents.length() ? i + 1 : i;
                    break;
                }
                --i;
            }
            int endOfWord = contents.length();
            if (position == 0) {
                endOfWord = 0;
            } else {
                int i2 = position - 1;
                while (i2 < contents.length()) {
                    if (contents.charAt(i2) == ',' || contents.charAt(i2) == ' ') {
                        endOfWord = i2;
                        break;
                    }
                    ++i2;
                }
            }
            String word = contents.substring(beginOfWord, position);
            if (word.equals(" ") || word.equals(",")) {
                word = "";
                ++beginOfWord;
                ++endOfWord;
            }
            ArrayList<TagContentProposal> proposals = new ArrayList<TagContentProposal>();
            WildcardMatcher matcher = new WildcardMatcher(String.valueOf(word) + '*');
            if (TagsTextField.this.fAllTags == null && TagsTextField.this.fFetchingJob.getState() != 4) {
                TagsTextField.this.fFetchingJob.schedule();
            }
            int t = 0;
            try {
                while (TagsTextField.this.fAllTags == null && t < 2000) {
                    Thread.sleep(100L);
                    t += 100;
                }
            }
            catch (InterruptedException interruptedException) {}
            if (TagsTextField.this.fAllTags != null && TagsTextField.this.fAllTags.size() > 0) {
                for (String tag : TagsTextField.this.fAllTags) {
                    if (!matcher.match(tag)) continue;
                    proposals.add(new TagContentProposal(tag, beginOfWord, endOfWord));
                }
                Collections.sort(proposals, new Comparator<TagContentProposal>(){

                    @Override
                    public int compare(TagContentProposal o1, TagContentProposal o2) {
                        return Collator.getInstance().compare(o1.getLabel(), o2.getLabel());
                    }
                });
                return proposals.toArray(new TagContentProposal[proposals.size()]);
            }
            String msg = Messages2.TagsTextField_NO_PROPOSALS;
            if (TagsTextField.this.fAllTags == null) {
                msg = Messages2.TagsTextField_PROPOSALS_NOT_RETRIEVED;
            }
            final String message = msg;
            return new IContentProposal[]{new IContentProposal(){

                public String getContent() {
                    return null;
                }

                public int getCursorPosition() {
                    return 0;
                }

                public String getDescription() {
                    return null;
                }

                public String getLabel() {
                    return message;
                }
            }};
        }
    }

    private class TagFetchingJob
    extends FoundationJob {
        public TagFetchingJob(String name) {
            super(name);
            this.setSystem(true);
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            if (TagsTextField.this.fAttribute == null) {
                return Status.CANCEL_STATUS;
            }
            ITeamRepository repository = (ITeamRepository)TagsTextField.this.fAttribute.getOrigin();
            IWorkItemClient workItemClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
            try {
                TagsTextField.this.fAllTags = workItemClient.findTags2(TagsTextField.this.fAttribute, monitor);
            }
            catch (TeamRepositoryException e) {
                WorkItemRCPUIPlugin.getDefault().log(Messages2.TagsTextField_ERROR_RETRIEVING_TAGS, e);
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

