/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import java.util.ArrayList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;

public class LabelBasedProposalProvider
implements IContentProposalProvider {
    private static final String CONTENTASSIST_KEY = "Ctrl+Space";
    private static final char[] CONTENTASSIST_AUTOACTIVATIONCHARS = null;
    private ILabelProvider fLabelProvider;
    private IValueProvider fValueProvider;

    public void install(Control control, IControlContentAdapter contentAdapter) {
        KeyStroke keyStroke;
        try {
            keyStroke = KeyStroke.getInstance((String)CONTENTASSIST_KEY);
        }
        catch (ParseException parseException) {
            keyStroke = KeyStroke.getInstance((int)0x1000013);
        }
        new ContentProposalAdapter(control, contentAdapter, (IContentProposalProvider)this, keyStroke, CONTENTASSIST_AUTOACTIVATIONCHARS);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.fLabelProvider = provider;
    }

    public ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public IValueProvider getValueProvider() {
        return this.fValueProvider;
    }

    public void setValueProvider(IValueProvider contentProvider) {
        this.fValueProvider = contentProvider;
    }

    public Object getValue(String text) {
        if (text == null || this.getValueProvider() == null || this.getValueProvider().getElements() == null) {
            return null;
        }
        Object closest = null;
        int closestMatch = 0;
        Object[] values = this.getValueProvider().getElements();
        int i = 0;
        while (i < values.length) {
            String name = this.fLabelProvider.getText(values[i]);
            if (name.equals(text)) {
                return values[i];
            }
            int matching = this.matchingCharacters(name, text);
            if (matching > closestMatch) {
                closestMatch = matching;
                closest = values[i];
            }
            ++i;
        }
        return closest;
    }

    private int matchingCharacters(String first, String second) {
        int matching = 0;
        while (matching < first.length() && matching < second.length() && Character.toLowerCase(first.charAt(matching)) == Character.toLowerCase(second.charAt(matching))) {
            ++matching;
        }
        return matching;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        Object[] values;
        ArrayList<Object> proposals = new ArrayList<Object>();
        String toMatch = contents.substring(0, position).toLowerCase();
        if (this.getValueProvider() != null && (values = this.getValueProvider().getElements()) != null) {
            int i = 0;
            while (i < values.length) {
                String text = this.fLabelProvider.getText(values[i]);
                if (contents == null || text.toLowerCase().startsWith(toMatch)) {
                    proposals.add(new StringProposal(text));
                }
                ++i;
            }
        }
        if (proposals.isEmpty()) {
            proposals.add(new NoProposal());
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public static interface IValueProvider {
        public Object[] getElements();
    }

    private static class NoProposal
    implements IContentProposal {
        private NoProposal() {
        }

        public String getContent() {
            return null;
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return Messages2.LabelBasedProposalProvider_NO_PROPOSALS;
        }
    }

    private static class StringProposal
    implements IContentProposal {
        private final String fProposal;

        public StringProposal(String proposal) {
            this.fProposal = proposal;
        }

        public String getContent() {
            return this.fProposal;
        }

        public int getCursorPosition() {
            return this.fProposal.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.fProposal;
        }
    }
}

