/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModel {
    private XMLString fInitialContent = null;
    private IStyledDocument fDocument = null;
    private IAnnotationModel fAnnotationModel = null;
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fDirty = false;

    public DocumentModel() {
        this(XMLString.EMPTY);
    }

    public DocumentModel(XMLString initialContent) {
        this.fInitialContent = initialContent;
    }

    public DocumentModel(IStyledDocument document) {
        this.fDocument = document;
        this.fDocument.addDocumentListener((IDocumentListener)new InternalDocumentListener());
    }

    public IStyledDocument getDocument() {
        if (this.fDocument == null) {
            this.fDocument = new StyledDocument(this.fInitialContent);
            this.fDocument.addDocumentListener((IDocumentListener)new InternalDocumentListener());
            this.fInitialContent = null;
        }
        return this.fDocument;
    }

    public IAnnotationModel getAnnotationModel() {
        if (this.fAnnotationModel == null) {
            this.fAnnotationModel = new AnnotationModel();
        }
        return this.fAnnotationModel;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void markClean() {
        this.fDirty = false;
    }

    public void markOccurrences(String findString, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        if (findString.length() == 0) {
            this.removeOccurrences();
            return;
        }
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
        try {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter((IDocument)this.getDocument());
            int offset = 0;
            while (offset < this.getDocument().getLength()) {
                IRegion region = adapter.find(offset, findString, true, caseSensitive, wholeWord, regExSearch);
                if (region != null) {
                    String message = this.getDocument().get(region.getOffset(), region.getLength());
                    annotationMap.put(new Annotation("org.eclipse.jdt.ui.occurrences", false, message), new Position(region.getOffset(), region.getLength()));
                    offset = region.getOffset() + region.getLength();
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
        this.replaceAnnotations(this.getAnnotationModel(), this.fOccurrenceAnnotations, annotationMap);
        this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
    }

    public void removeOccurrences() {
        this.replaceAnnotations(this.getAnnotationModel(), this.fOccurrenceAnnotations, null);
        this.fOccurrenceAnnotations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAnnotations(IAnnotationModel annotationModel, Annotation[] existingAnnotations, Map<Annotation, Position> annotationMap) {
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(existingAnnotations, annotationMap);
            } else {
                if (existingAnnotations != null) {
                    int i = 0;
                    while (i < existingAnnotations.length) {
                        annotationModel.removeAnnotation(existingAnnotations[i]);
                        ++i;
                    }
                }
                if (annotationMap != null) {
                    for (Map.Entry<Annotation, Position> entry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    private Object getLockObject(Object annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        private InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            DocumentModel.this.fDirty = true;
        }
    }
}

