/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedRadioGroup;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class DecoratedRadioGroupUpdaterJob
extends UIUpdaterJob {
    public static final long DELAY = 500L;
    public static final String RETRIEVEENTRY = Messages2.DecoratedRadioGroupUpdaterJob_RETRIEVING;
    private String fProperty;
    private DecoratedRadioGroup fDecoratedRadioGroup;
    private Object fNullValue;
    protected Object[] fValueSet;

    public DecoratedRadioGroupUpdaterJob(String name, DecoratedRadioGroup decoratedRadioGroup, String property) {
        super(name);
        this.fDecoratedRadioGroup = decoratedRadioGroup;
        this.fProperty = property;
    }

    public IStatus runInBackground(IProgressMonitor monitor) {
        try {
            WorkItemWorkingCopy workingCopy = this.getWorkingCopy();
            if (workingCopy != null) {
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = workingCopy.getWorkItem();
                IAttribute attribute = workItemClient.findAttribute(workItem.getProjectArea(), this.fProperty, monitor);
                this.fNullValue = this.resolve(attribute.getNullValue((IAuditableCommon)auditableClient, monitor), monitor);
                Object[] valueSet = attribute.getValueSet((IAuditableCommon)auditableClient, workItem, monitor);
                this.fValueSet = new Object[valueSet.length];
                int i = 0;
                while (i < valueSet.length) {
                    this.fValueSet[i] = this.resolve(valueSet[i], monitor);
                    ++i;
                }
            } else {
                this.fNullValue = null;
                this.fValueSet = new Object[0];
            }
        }
        catch (TeamRepositoryException x) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages2.DecoratedRadioGroupUpdaterJob_EXCEPTION_UPDATING_VALUESET, (Throwable)x);
        }
        return super.runInBackground(monitor);
    }

    public IStatus runInUI(IProgressMonitor monitor) {
        if (this.fDecoratedRadioGroup.getRadioGroup().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        this.fDecoratedRadioGroup.setNullValue(this.fNullValue);
        this.fDecoratedRadioGroup.setValueSet(this.fValueSet);
        return super.runInUI(monitor);
    }

    public void scheduleJob() {
        this.setRetrieving();
        this.schedule();
    }

    public void scheduleDefered() {
        this.setRetrieving();
        this.schedule(500L);
    }

    protected Object resolve(Object value, IProgressMonitor monitor) throws TeamRepositoryException {
        return value;
    }

    protected abstract WorkItemWorkingCopy getWorkingCopy();

    private void setRetrieving() {
        this.fDecoratedRadioGroup.setValueSet(new Object[]{RETRIEVEENTRY});
    }
}

