/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ValueSetProvider;
import com.ibm.team.workitem.common.internal.ValueSetProviderRegistry;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedList;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class DecoratedListUpdaterJob
extends UIUpdaterJob {
    public static final long DELAY = 500L;
    protected String fProperty;
    private DecoratedList fDecoratedList;
    protected Object fNullValue;
    protected Object[] fValueSet;
    protected String fEnumTypeId;
    private ValueSetProvider fValueSetProvider;

    public DecoratedListUpdaterJob(String name, DecoratedList decoratedList, String property, String enumTypeId, String valueSetProviderId) {
        super(name);
        this.fDecoratedList = decoratedList;
        this.fProperty = property;
        this.fEnumTypeId = enumTypeId;
        if (valueSetProviderId != null) {
            this.fValueSetProvider = ValueSetProviderRegistry.getValueSetProvider((String)valueSetProviderId);
        }
    }

    public IStatus runInBackground(IProgressMonitor monitor) {
        try {
            WorkItemWorkingCopy workingCopy = this.getWorkingCopy();
            if (workingCopy != null) {
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                WorkItemCommon workItemClient = (WorkItemCommon)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = workingCopy.getWorkItem();
                IAttribute attribute = workItemClient.findAttribute(workItem.getProjectArea(), this.fProperty, monitor);
                if (this.fValueSetProvider != null) {
                    this.fNullValue = this.fValueSetProvider.getNullValue(attribute, workItem, (IWorkItemCommon)workItemClient, monitor);
                    this.fValueSet = this.fValueSetProvider.getValueSet(attribute, workItem, (IWorkItemCommon)workItemClient, monitor).toArray();
                } else {
                    IEnumeration enumeration;
                    Object[] valueSet = null;
                    if (workItem != null && (enumeration = workItemClient.internalResolveEnumeration(workItem.getProjectArea(), this.fEnumTypeId, monitor)) != null) {
                        List enumerationLiterals = enumeration.getEnumerationLiterals();
                        valueSet = new Object[enumerationLiterals.size()];
                        int i = 0;
                        for (ILiteral lit : enumerationLiterals) {
                            valueSet[i++] = lit;
                        }
                    }
                    this.fNullValue = this.resolve(attribute.getNullValue((IAuditableCommon)auditableClient, monitor), monitor);
                    this.fValueSet = valueSet != null ? valueSet : new Object[0];
                }
            } else {
                this.fNullValue = null;
                this.fValueSet = new Object[0];
            }
            this.fDecoratedList.setRetrieving(false);
        }
        catch (TeamRepositoryException x) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", 4, Messages2.DecoratedRadioGroupUpdaterJob_EXCEPTION_UPDATING_VALUESET, (Throwable)x);
        }
        return super.runInBackground(monitor);
    }

    private void setRetrieving(boolean retrieving) {
        this.fDecoratedList.setRetrieving(retrieving);
    }

    protected Object resolve(Object value, IProgressMonitor monitor) throws TeamRepositoryException {
        return value;
    }

    public IStatus runInUI(IProgressMonitor monitor) {
        if (this.fDecoratedList.getDecoratedControl().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        this.fDecoratedList.setNullValue(this.fNullValue);
        this.fDecoratedList.setValueSet(this.fValueSet);
        return super.runInUI(monitor);
    }

    public void scheduleJob() {
        this.setRetrieving(true);
        this.schedule();
    }

    public void scheduleDefered() {
        this.schedule(500L);
    }

    protected abstract WorkItemWorkingCopy getWorkingCopy();
}

