/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.Workbench;

public class DecoratedHyperlink
extends DecoratedControl
implements ISelectionProvider {
    private static final int DEFAULT_OPTION = 0;
    private StandardControlLabelProvider fHyperlink;
    private Label fImageLabel;
    private StandardLabelProvider fLabelProvider;

    public DecoratedHyperlink(Composite parent, int style) {
        this(parent, style, 0);
    }

    public DecoratedHyperlink(Composite parent, int style, int options) {
        super(parent, style, options);
    }

    public Object getValue() {
        return this.fHyperlink.getElement();
    }

    public void setValue(Object value) {
        if (value == null) {
            this.fHyperlink.setElement(null);
            ((Hyperlink)this.fHyperlink.getControl()).setText(Messages2.DecoratedHyperlink_NONE);
        } else {
            this.fHyperlink.setElement(value);
        }
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(this.getImage(value));
        }
    }

    private Image getImage(Object element) {
        return this.fLabelProvider != null && element != null ? this.fLabelProvider.getImage(element) : null;
    }

    protected boolean isSet() {
        return this.fHyperlink.getElement() != null;
    }

    public StandardControlLabelProvider getHyperlink() {
        return this.fHyperlink;
    }

    public Control getImageControl() {
        return this.fImageLabel;
    }

    protected Control getDecoratedControl() {
        return this.fHyperlink.getControl();
    }

    protected Control createControl(Composite parent, int style) {
        IEditorSite site;
        IEditorPart editor;
        GridLayout layout;
        Composite container;
        boolean hasDecoration;
        boolean hasImage = (this.getOptions() & 1) != 0;
        boolean bl = hasDecoration = (this.getOptions() & 4) == 0;
        if (hasImage) {
            container = new Composite(parent, 0);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = !hasDecoration ? 0 : 7;
            container.setLayout((Layout)layout);
            this.fImageLabel = new Label(container, 0);
            GridData data = new GridData(131072, 0x1000000, false, false);
            data.widthHint = 16;
            data.heightHint = 16;
            this.fImageLabel.setLayoutData((Object)data);
        } else if (!hasDecoration) {
            container = new Composite(parent, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
        } else {
            container = new Composite(parent, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginLeft = 7;
            container.setLayout((Layout)layout);
        }
        final Hyperlink hyperlink = new Hyperlink(container, style);
        hyperlink.setText("");
        new HyperlinkGroup(Display.getCurrent()).add(hyperlink);
        this.fHyperlink = new StandardControlLabelProvider((Control)hyperlink);
        this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        this.fHyperlink.setLabelProvider((IViewerLabelProvider)this.fLabelProvider);
        this.fHyperlink.setForegroundAware(true);
        this.fHyperlink.setTextAware(true);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (DecoratedHyperlink.this.fHyperlink.getElement() == null) {
                    return;
                }
                FoundationJob job = new FoundationJob(Messages2.DecoratedHyperlink_OPEN_LINIK){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        Object element = DecoratedHyperlink.this.fHyperlink.getElement();
                        if (element == null) {
                            return Status.CANCEL_STATUS;
                        }
                        URIReference reference = Hyperlinks.createHyperlink((Object)element);
                        if (reference == null) {
                            return Status.CANCEL_STATUS;
                        }
                        Hyperlinks.openHyperlink((URI)reference.getURI(), null, (String)hyperlink.getText());
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
        new TooltipSupport((Control)hyperlink, true, false){

            protected Object mapElement(int x, int y) {
                return DecoratedHyperlink.this.fHyperlink.getElement();
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                Object data = DecoratedHyperlink.this.fHyperlink.getElement();
                return data == null ? StructuredSelection.EMPTY : new StructuredSelection(data);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
            }
        });
        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && (site = editor.getEditorSite()) != null) {
            site.registerContextMenu(menuMgr, (ISelectionProvider)selectionProvider);
        }
        Menu menu = menuMgr.createContextMenu((Control)hyperlink);
        hyperlink.setMenu(menu);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 3;
        this.fHyperlink.getControl().setLayoutData((Object)data);
        int horizOffset = 3;
        if (hasImage) {
            horizOffset += 16;
        }
        if (hasDecoration) {
            horizOffset += 7;
        }
        ITeamFormData base = ITeamFormData.HYPERLINK;
        TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)base.addOffset(horizOffset, 0));
        return container;
    }

    public ISelection getSelection() {
        Object value = this.getValue();
        if (value == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(value);
    }

    public void setSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Assert.isTrue((structuredSelection.size() <= 1 ? 1 : 0) != 0);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        this.setValue(element);
    }
}

