/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.workitem.ide.ui.internal.editor.Messages2;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class DecoratedControl
implements ISelectionProvider {
    public static final int NO_OPTION = 0;
    public static final int IMAGE_OPTION = 1;
    public static final int FIELD_ASSIST_OPTION = 2;
    public static final int NO_DECORATION_OPTION = 4;
    public static final int DECORATION_WIDTH = 7;
    private Control fControl;
    private int fOptions;
    private int fStatusPos;
    private int fContentAssistPos;
    private boolean fIsRequired;
    private IStatus fStatus = Status.OK_STATUS;
    protected ControlDecoration fStatusDecoration;
    private ControlDecoration fContentProposalDecoration;
    private ResourceManager fResourceManager;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    public static final int IMAGE_WIDTH = 16;

    public DecoratedControl(Composite parent, int style, int options) {
        this(options);
        this.createContent(parent, style);
    }

    public DecoratedControl(Composite parent, int style, int options, int statusPos, int contentAssistPos) {
        this(options, statusPos, contentAssistPos);
        this.createContent(parent, style);
    }

    public DecoratedControl(int options) {
        this(options, 0x1004000, 16512);
    }

    public DecoratedControl(int options, int statusPos, int contentAssistPos) {
        this.fOptions = options;
        this.fStatusPos = statusPos;
        this.fContentAssistPos = contentAssistPos;
    }

    protected final void createContent(Composite parent, int style) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fControl = this.createControl(parent, style);
        this.fStatusDecoration = new ControlDecoration(this.getDecoratedControl(), this.fStatusPos);
        this.fStatusDecoration.hide();
        if ((this.fOptions & 2) != 0) {
            this.fContentProposalDecoration = new ControlDecoration(this.getDecoratedControl(), this.fContentAssistPos);
            this.fContentProposalDecoration.hide();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 26) {
                        DecoratedControl.this.fContentProposalDecoration.show();
                    }
                    if (event.type == 27) {
                        DecoratedControl.this.fContentProposalDecoration.hide();
                    }
                }
            };
            this.getDecoratedControl().addListener(26, listener);
            this.getDecoratedControl().addListener(27, listener);
            String message = Messages2.DecoratedControl_CONTENT_ASSIST_AVAILABLE;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
            if (activeBindings.length != 0) {
                message = String.valueOf(message) + " (" + activeBindings[0].format() + ")";
            }
            this.fContentProposalDecoration.setDescriptionText(message);
            this.fContentProposalDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        }
    }

    public void setRequired(boolean isRequired) {
        this.fIsRequired = isRequired;
        this.updateRequiredDecoration();
    }

    public boolean isRequired() {
        return this.fIsRequired;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        Image image;
        this.fStatus = status;
        switch (status.getSeverity()) {
            case 4: 
            case 8: {
                image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
                break;
            }
            case 2: {
                image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
                break;
            }
            case 1: {
                image = this.fResourceManager.createImage(ImagePool.INFO_OVR);
                break;
            }
            default: {
                image = null;
            }
        }
        if (image != null) {
            this.fStatusDecoration.setDescriptionText(status.getMessage());
            this.fStatusDecoration.setImage(image);
            this.fStatusDecoration.show();
        } else {
            this.fStatusDecoration.setDescriptionText(null);
            this.fStatusDecoration.hide();
        }
    }

    protected void updateRequiredDecoration() {
    }

    protected abstract boolean isSet();

    public Control getLayoutControl() {
        return this.fControl;
    }

    protected Control getDecoratedControl() {
        return this.getLayoutControl();
    }

    public Control getImageControl() {
        return null;
    }

    protected int getOptions() {
        return this.fOptions;
    }

    protected abstract Control createControl(Composite var1, int var2);

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged() {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }
}

