/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.LabelBasedProposalProvider;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.FieldAssistColors;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DecoratedCombo
extends DecoratedControl
implements ISelectionProvider {
    private static final int DEFAULT_OPTION = 0;
    private Object fValue;
    private Object[] fValueSet = new Object[0];
    private Combo fCombo;
    private Label fImageLabel;
    private ILabelProvider fLabelProvider;
    private IElementComparer fElementComparer;
    private Comparator fComparator;
    private LabelBasedProposalProvider fFieldAssist;
    private Object fNullValue;
    private Color fMissingRequiredBackground;

    public DecoratedCombo(Composite parent, int style) {
        this(parent, style, 0);
    }

    public DecoratedCombo(Composite parent, int style, int options) {
        super(parent, style, options);
    }

    public Object[] getValueSet() {
        return this.fValueSet;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
        String text = this.getText(value);
        if (!this.getCombo().getText().equals(text)) {
            if (this.getCombo().getItemCount() > this.fValueSet.length) {
                this.getCombo().remove(0);
            }
            if (this.getCombo().indexOf(text) == -1) {
                this.getCombo().add(text, 0);
            }
            this.getCombo().setText(text);
        }
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(this.getImage(value));
        }
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    public void setValueSet(Object[] valueSet) {
        String text;
        Combo combo;
        int index;
        Assert.isNotNull((Object)valueSet);
        this.fValueSet = valueSet;
        if (this.fComparator != null) {
            Object[] sortedValues = new Object[valueSet.length];
            System.arraycopy(valueSet, 0, sortedValues, 0, valueSet.length);
            Arrays.sort(sortedValues, this.fComparator);
            this.fValueSet = sortedValues;
        }
        if ((index = (combo = this.getCombo()).indexOf(text = this.getText(this.fValue))) != -1) {
            int n;
            if (index > 0) {
                combo.remove(0, index - 1);
            }
            if ((n = combo.getItemCount()) > 1) {
                combo.remove(1, n - 1);
            }
        } else {
            combo.removeAll();
        }
        if (combo.getItemCount() == 0 && this.indexOf(this.fValueSet, this.fValue) == -1) {
            combo.add(text);
        }
        int i = 0;
        while (i < this.fValueSet.length) {
            combo.add(this.getText(this.fValueSet[i]));
            ++i;
        }
        if (combo.getItemCount() > this.fValueSet.length) {
            if (this.indexOf(this.fValueSet, this.fValue) != -1) {
                combo.remove(0);
            } else if (combo.indexOf(text, 1) != -1) {
                combo.remove(0);
            }
        }
        combo.setText(text);
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(this.getImage(this.fValue));
        }
    }

    public void setNullValue(Object nullValue) {
        this.fNullValue = nullValue;
        this.updateRequiredDecoration();
    }

    public void setElementComparer(IElementComparer elementComparer) {
        this.fElementComparer = elementComparer;
        this.updateRequiredDecoration();
    }

    protected void updateRequiredDecoration() {
        super.updateRequiredDecoration();
        if (this.isRequired() && !this.isSet()) {
            if (this.fMissingRequiredBackground == null) {
                this.fMissingRequiredBackground = FieldAssistColors.getRequiredFieldBackgroundColor((Control)this.getCombo());
            }
            this.getCombo().setBackground(this.fMissingRequiredBackground);
        } else {
            this.getCombo().setBackground(null);
        }
    }

    protected boolean isSet() {
        return !this.equals(this.fValue, this.fNullValue);
    }

    private int indexOf(Object[] values, Object value) {
        int i = 0;
        while (i < values.length) {
            if (this.equals(values[i], value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean equals(Object left, Object right) {
        if (this.fElementComparer != null) {
            return this.fElementComparer.equals(left, right);
        }
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    public Combo getCombo() {
        return this.fCombo;
    }

    protected Control getDecoratedControl() {
        return this.fCombo;
    }

    public Control getImageControl() {
        return this.fImageLabel;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.getFieldAssist().setLabelProvider(labelProvider);
    }

    public void setSorter(Comparator comparator) {
        this.fComparator = comparator;
    }

    protected Control createControl(Composite parent, int style) {
        GridLayout layout;
        Composite container;
        boolean hasDecoration;
        boolean hasImage = (this.getOptions() & 1) != 0;
        boolean bl = hasDecoration = (this.getOptions() & 4) == 0;
        if (hasImage) {
            container = new Composite(parent, 0);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = !hasDecoration ? 0 : 7;
            container.setLayout((Layout)layout);
            this.fImageLabel = new Label(container, 0);
            GridData data = new GridData(131072, 0x1000000, false, false);
            data.widthHint = 16;
            data.heightHint = 16;
            this.fImageLabel.setLayoutData((Object)data);
        } else if (!hasDecoration) {
            container = new Composite(parent, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            container.setLayout((Layout)layout);
        } else {
            container = new Composite(parent, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginLeft = 7;
            container.setLayout((Layout)layout);
        }
        this.fCombo = new Combo(container, style);
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecoratedCombo.this.handleSelectionEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DecoratedCombo.this.setClosestValue(DecoratedCombo.this.getCombo().getText(), -1);
            }
        });
        this.fCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        int horizOffset = 0;
        if (hasImage) {
            horizOffset += 16;
        }
        if (hasDecoration) {
            horizOffset += 7;
        }
        boolean readOnly = (style & 8) != 0;
        ITeamFormData base = readOnly ? ITeamFormData.READ_ONLY_COMBO : ITeamFormData.COMBO;
        TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)base.addOffset(horizOffset, 0));
        if (hasImage) {
            return container;
        }
        if (this.isFieldAssistEnabled()) {
            this.getFieldAssist().install((Control)this.fCombo, (IControlContentAdapter)new DecoratedComboContentAdapter());
            this.getFieldAssist().setValueProvider(new LabelBasedProposalProvider.IValueProvider(){

                public Object[] getElements() {
                    return DecoratedCombo.this.getValueSet();
                }
            });
            this.fCombo.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    DecoratedCombo.this.fCombo.setText(DecoratedCombo.this.getText(DecoratedCombo.this.getValue()));
                }
            });
            this.fCombo.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.keyCode == 9) {
                        DecoratedCombo.this.setClosestValue(DecoratedCombo.this.getCombo().getText(), -1);
                    }
                }
            });
        }
        return container;
    }

    private void handleSelectionEvent(SelectionEvent e) {
        int index = this.getCombo().getSelectionIndex();
        if (index != -1) {
            if (this.getCombo().getItemCount() > this.fValueSet.length) {
                --index;
            }
            if (index >= 0 && index < this.fValueSet.length) {
                this.fValue = this.fValueSet[index];
                if (this.getCombo().getItemCount() > this.fValueSet.length) {
                    this.getCombo().remove(0);
                    if ("carbon".equals(SWT.getPlatform())) {
                        this.getCombo().select(index);
                    }
                }
            }
        } else {
            this.fValue = null;
        }
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(this.getImage(this.fValue));
        }
        this.updateRequiredDecoration();
        this.fireSelectionChanged();
    }

    private String getText(Object element) {
        if (this.fLabelProvider == null) {
            if (element == null) {
                return "";
            }
            return element.toString();
        }
        String text = this.fLabelProvider.getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    private Image getImage(Object element) {
        return this.fLabelProvider != null ? this.fLabelProvider.getImage(element) : null;
    }

    public ISelection getSelection() {
        if (this.fValue == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(this.fValue);
    }

    public void setSelection(ISelection selection) {
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Assert.isTrue((structuredSelection.size() <= 1 ? 1 : 0) != 0);
        Object element = ((IStructuredSelection)selection).getFirstElement();
        this.setValue(element);
    }

    private boolean isFieldAssistEnabled() {
        return (this.getOptions() & 2) != 0;
    }

    private void setClosestValue(String text, int cursorPosition) {
        if (!this.isFieldAssistEnabled()) {
            return;
        }
        Object value = this.getFieldAssist().getValue(text);
        this.setValue(value == null ? this.getValue() : value);
        int position = cursorPosition == -1 ? this.getText(this.getValue()).length() : cursorPosition;
        this.fCombo.setSelection(new Point(position, position));
    }

    private LabelBasedProposalProvider getFieldAssist() {
        if (this.fFieldAssist == null) {
            this.fFieldAssist = new LabelBasedProposalProvider();
        }
        return this.fFieldAssist;
    }

    private class DecoratedComboContentAdapter
    extends ComboContentAdapter {
        private DecoratedComboContentAdapter() {
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
            DecoratedCombo.this.setClosestValue(text, cursorPosition);
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            DecoratedCombo.this.setClosestValue(text, cursorPosition);
        }
    }
}

