/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.workitem.common.expression.IQueryableAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableLinkAttribute;
import com.ibm.team.workitem.common.internal.expression.QueryableWorkItemAttribute;
import com.ibm.team.workitem.common.internal.expression.WorkItemQueryAttributeFactory;
import com.ibm.team.workitem.common.internal.query.presentations.IControlPresentationDescriptor;
import com.ibm.team.workitem.common.internal.util.QueryableAttributePath;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.query.SyntheticAttributeIdentifiers;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.contributions.IDefaultQueryEditorControlFactory;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.DurationConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.FileSizeConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.MessageConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.ApprovalProviders;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.AttributeListControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.AttributeValueSetInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.BasicQueryEditorControlFactory;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.CategoryTreeViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.ContributorListControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.IterationTreeViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.ProcessAreaProviders;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.ProcessAreaTreeViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.TypeInputProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.WorkItemListControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.WorkflowProviders;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.WorkflowTreeViewerControl;
import java.util.HashMap;

public class WorkItemQueryEditorControlFactory
implements IDefaultQueryEditorControlFactory {
    private static HashMap<String, ConditionControl> fgTypeControls = new HashMap();
    private static HashMap<String, ConditionControl> fgAttributeControls;

    static {
        fgTypeControls.put("type", ConditionControl.TYPE_LIST_CONTROL);
        fgTypeControls.put("category", ConditionControl.CATEGORY_TREE_CONTROL);
        fgTypeControls.put("interval", ConditionControl.ITERATION_TREE_CONTROL);
        fgTypeControls.put("tags", ConditionControl.TAGS_TEXT_CONTROL);
        fgTypeControls.put("contributor", ConditionControl.CONTRIBUTOR_LIST_CONTROL);
        fgTypeControls.put("subscriptions", ConditionControl.CONTRIBUTOR_LIST_CONTROL);
        fgTypeControls.put("approvalState", ConditionControl.ATTRIBUTE_LIST_CONTROL);
        fgTypeControls.put("approvalType", ConditionControl.ATTRIBUTE_LIST_CONTROL);
        fgTypeControls.put("comments", ConditionControl.CONTRIBUTOR_LIST_CONTROL);
        fgTypeControls.put("approvals", ConditionControl.CONTRIBUTOR_LIST_CONTROL);
        fgTypeControls.put("duration", ConditionControl.DURATION_CONTROL);
        fgTypeControls.put("deliverable", ConditionControl.ATTRIBUTE_LIST_CONTROL);
        fgTypeControls.put("teamArea", ConditionControl.TEAM_AREA_CONTROL);
        fgTypeControls.put("processArea", ConditionControl.PROCESS_AREA_CONTROL);
        fgTypeControls.put("projectArea", ConditionControl.PROJECT_AREA_CONTROL);
        fgTypeControls.put("workItem", ConditionControl.WORK_ITEM);
        fgTypeControls.put("timestamp", ConditionControl.DATE_CONTROL);
        fgTypeControls.put("fileSize", ConditionControl.FILE_SIZE_CONTROL);
        fgAttributeControls = new HashMap();
        fgAttributeControls.put(IWorkItem.STATE_PROPERTY, ConditionControl.STATUS_LIST_CONTROL);
        fgAttributeControls.put(IWorkItem.RESOLUTION_PROPERTY, ConditionControl.RESOLUTION_LIST_CONTROL);
        String approvalDescriptorName = QueryableAttributePath.createPathString((String[])new String[]{IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY, WorkItemQueryAttributeFactory.APPROVAL_DESC_NAME_PROPERTY});
        fgAttributeControls.put(approvalDescriptorName, ConditionControl.APPROVAL_DESCRIPTOR_NAME_CONTROL);
    }

    public IConditionControl createConditionControl(IControlPresentationDescriptor descriptor) {
        ConditionControl control = this.getConditionControl(descriptor.getAttribute());
        return control != null ? control.createControl(descriptor) : null;
    }

    public boolean supports(IControlPresentationDescriptor descriptor) {
        return this.getConditionControl(descriptor.getAttribute()) != null;
    }

    private ConditionControl getConditionControl(IQueryableAttribute attribute) {
        if (IWorkItem.PROJECT_AREA_PROPERTY.equals(attribute.getIdentifier())) {
            return null;
        }
        if (attribute.isSynthetic() && !(attribute instanceof QueryableLinkAttribute) && !SyntheticAttributeIdentifiers.QUERYABLE_ATTRIBUTES.contains(attribute.getIdentifier())) {
            return null;
        }
        ConditionControl control = this.getAttributeConditionControl(QueryableAttributePath.createPathString((IQueryableAttribute)attribute));
        if (control == null) {
            control = this.getAttributeConditionControl(attribute.getIdentifier());
        }
        if (control == null && attribute instanceof QueryableLinkAttribute) {
            control = ConditionControl.LINK_CONTROL;
        }
        if (control == null) {
            String attributeType = attribute.getAttributeType();
            if (AttributeTypes.isItemListAttributeType((String)attributeType)) {
                attributeType = AttributeTypes.getContainedType((String)attributeType);
            }
            control = this.getTypeConditionControl(attributeType);
        }
        return control;
    }

    private ConditionControl getAttributeConditionControl(String attributeIdentifier) {
        return fgAttributeControls.get(attributeIdentifier);
    }

    private ConditionControl getTypeConditionControl(String typeIdentifier) {
        ConditionControl control = fgTypeControls.get(typeIdentifier);
        if (control == null && AttributeTypes.isEnumerationAttributeType((String)typeIdentifier)) {
            control = ConditionControl.ATTRIBUTE_LIST_CONTROL;
        }
        return control;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConditionControl {
        ATTRIBUTE_LIST_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new AttributeListControl(descriptor.getAttribute());
            }
        }
        ,
        TYPE_LIST_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                AttributeListControl control = new AttributeListControl(descriptor.getAttribute());
                control.setInputProvider(new TypeInputProvider());
                control.setComparator(null);
                return control;
            }
        }
        ,
        CATEGORY_TREE_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new CategoryTreeViewerControl();
            }
        }
        ,
        ITERATION_TREE_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new IterationTreeViewerControl();
            }
        }
        ,
        STATUS_LIST_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                WorkflowTreeViewerControl control = new WorkflowTreeViewerControl();
                control.setInputProvider(WorkflowProviders.createStateInputProvider());
                control.setConverter(WorkflowProviders.createStateConverter());
                return control;
            }
        }
        ,
        RESOLUTION_LIST_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                WorkflowTreeViewerControl control = new WorkflowTreeViewerControl();
                control.setInputProvider(WorkflowProviders.createResolutionInputProvider());
                control.setConverter(WorkflowProviders.createResolutionConverter());
                return control;
            }
        }
        ,
        TAGS_TEXT_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                TextConditionControl control = new TextConditionControl();
                control.setInputProvider(new AttributeValueSetInputProvider(descriptor.getAttribute()));
                return control;
            }
        }
        ,
        APPROVAL_DESCRIPTOR_NAME_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                TextConditionControl control = new TextConditionControl();
                control.setInputProvider(ApprovalProviders.createNameInputProvider());
                return control;
            }
        }
        ,
        DURATION_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new DurationConditionControl();
            }
        }
        ,
        CONTRIBUTOR_LIST_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new ContributorListControl(descriptor.getAttribute());
            }
        }
        ,
        DATE_CONTROL{
            private BasicQueryEditorControlFactory fDelegate = new BasicQueryEditorControlFactory();

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                if (!descriptor.hasConfigurationValue("futureVariables")) {
                    boolean isPastDateAttribute = QueryableWorkItemAttribute.isPastDateAttribute((IQueryableAttribute)descriptor.getAttribute());
                    descriptor.setConfigurationValue("futureVariables", Boolean.toString(!isPastDateAttribute));
                }
                return this.fDelegate.createConditionControl(descriptor);
            }
        }
        ,
        TEAM_AREA_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                boolean restrictToProjectArea = "teamArea".equals(descriptor.getAttribute().getIdentifier());
                ProcessAreaProviders.ProjectMode projectMode = restrictToProjectArea ? ProcessAreaProviders.ProjectMode.SINGLE : ProcessAreaProviders.ProjectMode.MULTI;
                return new ProcessAreaTreeViewerControl(ProcessAreaProviders.ContentMode.TEAM_AREA, projectMode);
            }
        }
        ,
        PROCESS_AREA_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new ProcessAreaTreeViewerControl(ProcessAreaProviders.ContentMode.PROCESS_AREA, ProcessAreaProviders.ProjectMode.MULTI);
            }
        }
        ,
        PROJECT_AREA_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new ProcessAreaTreeViewerControl(ProcessAreaProviders.ContentMode.PROJECT_AREA, ProcessAreaProviders.ProjectMode.MULTI);
            }
        }
        ,
        WORK_ITEM{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new WorkItemListControl();
            }
        }
        ,
        FILE_SIZE_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new FileSizeConditionControl();
            }
        }
        ,
        LINK_CONTROL{

            protected IConditionControl createControl(IControlPresentationDescriptor descriptor) {
                return new MessageConditionControl(Messages.WorkItemQueryEditorControlFactory_NO_VALUES_NEEDED_INFO, ImagePool.INFO_ICON);
            }
        };


        protected abstract IConditionControl createControl(IControlPresentationDescriptor var1);
    }
}

