/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.NullAwareArrayContentProvider;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TableViewerControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.Messages;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.workitem.WorkItemProviders;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemListControl
extends TableViewerControl {
    private Action fAddWorkItemAction = new Action(){

        public void run() {
            WorkItemListControl.this.addWorkItems();
        }
    };
    private Updater fUpdater = new Updater();
    private ArrayList<Object> fWorkItems;

    public WorkItemListControl() {
        this.setInputProvider(WorkItemProviders.createInputProvider());
        this.setLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.setPopupLabelProvider((IBaseLabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.setContentProvider((IContentProvider)new NullAwareArrayContentProvider());
        this.setPopupContentProvider((IContentProvider)new NullAwareArrayContentProvider());
        this.setWidthHintInChars(30);
        this.fAddWorkItemAction.setImageDescriptor(ImagePool.WORK_ITEMS);
        this.fAddWorkItemAction.setText(Messages.WorkItemListControl_ADD_WORK_ITEMS);
        this.fAddWorkItemAction.setToolTipText(Messages.WorkItemListControl_ADD_WORK_ITEMS_TOOLTIP);
    }

    @Override
    protected void initializeToolBar() {
        super.initializeToolBar();
        IToolBarManager toolBarManager = this.getSite().getToolBarManager();
        toolBarManager.add((IAction)this.fAddWorkItemAction);
        toolBarManager.update(false);
    }

    @Override
    protected void inputChanged(Object input) {
        if (input instanceof Object[]) {
            this.fWorkItems = new ArrayList<Object>(Arrays.asList((Object[])input));
        }
        if (input instanceof List) {
            this.fWorkItems = new ArrayList((List)input);
        }
        this.getViewer().setInput(this.fWorkItems);
    }

    @Override
    protected Object getResolvedInput() {
        return this.fWorkItems;
    }

    private void addWorkItems() {
        if (this.getInput() == null) {
            return;
        }
        ITeamRepository repository = (ITeamRepository)this.getInput().getProjectArea().getOrigin();
        List<IWorkItemHandle> workItems = Arrays.asList(WorkItemSelectionDialog.getWorkItems((Shell)this.getShell(), (ITeamRepository)repository));
        if (!workItems.isEmpty()) {
            ArrayList<IWorkItemHandle> toResolve = new ArrayList<IWorkItemHandle>();
            ItemHandleAwareHashSet values = new ItemHandleAwareHashSet(this.fWorkItems);
            for (IWorkItemHandle workItem : workItems) {
                if (values.contains((Object)workItem)) continue;
                toResolve.add(workItem);
            }
            if (!toResolve.isEmpty()) {
                this.fUpdater.setMissing(toResolve);
                this.fUpdater.setSelection(workItems);
                this.fUpdater.schedule();
            } else {
                this.updateSelection(workItems);
            }
        }
    }

    private void updateSelection(List<IWorkItemHandle> workItems) {
        ArrayList<Object> newSelection = new ArrayList<Object>();
        newSelection.addAll(workItems);
        newSelection.addAll(Arrays.asList(this.getSelectedElements()));
        this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(newSelection));
    }

    private Shell getShell() {
        return this.getCheckBoxTableViewer().getTable().getShell();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Updater
    extends UIUpdaterJob {
        private List<IWorkItemHandle> fMissing;
        private List<IWorkItem> fResolvedMissing;
        private List<IWorkItemHandle> fSelection;

        public Updater() {
            super(Messages.WorkItemListControl_UPDATING);
        }

        public void setMissing(List<IWorkItemHandle> missing) {
            this.fMissing = missing;
        }

        public void setSelection(List<IWorkItemHandle> selection) {
            this.fSelection = selection;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            if (!this.fMissing.isEmpty()) {
                IAuditableClient auditableClient = (IAuditableClient)ClientUtils.getClientLibrary((IItemHandle)((IItemHandle)this.fMissing.get(0)), IAuditableClient.class);
                try {
                    this.fResolvedMissing = CollectionUtils.removeNulls((List)auditableClient.resolveAuditables(this.fMissing, IWorkItem.SMALL_PROFILE, monitor));
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemListControl_ERROR_RESOLVING, e);
                    WorkItemListControl.this.getSite().showStatusText(Messages.WorkItemListControl_COULD_NOT_ADD_WORKITEMS);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.fResolvedMissing != null && !this.fResolvedMissing.isEmpty() && !WorkItemListControl.this.getSite().isDisposed()) {
                WorkItemListControl.this.fWorkItems.addAll(this.fResolvedMissing);
                WorkItemListControl.this.getCheckBoxTableViewer().add(this.fResolvedMissing.toArray());
                WorkItemListControl.this.updateSelection(this.fSelection);
            }
            return super.runInUI(monitor);
        }
    }
}

